/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.plugins.architecture.controller.DbHelper;
import com.contrastsecurity.agent.plugins.architecture.controller.DbInfoBlock;
import com.contrastsecurity.agent.plugins.architecture.controller.a;
import com.contrastsecurity.agent.plugins.architecture.controller.c;
import com.contrastsecurity.agent.plugins.architecture.controller.d;
import com.contrastsecurity.agent.plugins.architecture.controller.e;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

@Singleton
@DontObfuscate
public final class ContrastSqlDispatcherImpl
implements ContrastSqlDispatcher {
    private final ApplicationManager applicationManager;
    private final e[] statementListeners;
    private final ContrastEngine contrastEngine;
    private final ScopeProvider scopeProvider;
    private final a reporter;
    private final Map<Connection, ArchitectureComponent> dbCacheMap;
    private static final Logger logger = LoggerFactory.getLogger(ContrastSqlDispatcherImpl.class);

    @Inject
    ContrastSqlDispatcherImpl(g g2, ApplicationManager applicationManager, ContrastEngine contrastEngine, ScopeProvider scopeProvider, a a2) {
        this.applicationManager = applicationManager;
        this.contrastEngine = contrastEngine;
        this.statementListeners = new e[]{new d(), new c(g2)};
        this.scopeProvider = scopeProvider;
        this.reporter = a2;
        this.dbCacheMap = new ConcurrentReferenceHashMap<Connection, ArchitectureComponent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSqlStatementExecuting(Object object, Class<?> clazz, Object[] objectArray) {
        Object object2;
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        if (object instanceof Statement) {
            object2 = null;
            try {
                object2 = ((Statement)object).getConnection();
            }
            catch (SQLException sQLException) {
                logger.debug("Failed to extract SQL connection from Statement", sQLException);
            }
            if (object2 != null) {
                ArchitectureComponent object3 = this.dbCacheMap.get(object2);
                if (object3 == null) {
                    logger.debug("Found undetected DB connection in use");
                } else {
                    this.reporter.a(application, object3);
                }
            } else {
                logger.debug("DB connection was null");
            }
        }
        object2 = this.scopeProvider.enterScope();
        try {
            for (e e2 : this.statementListeners) {
                e2.a(application, clazz, objectArray, this.contrastEngine);
            }
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Exception exception) {
            logger.error("Problem issuing SQL event to listener", exception);
        }
        finally {
            ((ScopeAggregator)object2).leaveScope();
        }
    }

    public void connect(Object object, String string) {
        DbInfoBlock dbInfoBlock = DbHelper.parseDbUrl(string);
        if (dbInfoBlock == null) {
            logger.debug("Cannot profile the database because the URL could not be parsed: {}", (Object)string);
            return;
        }
        String string2 = dbInfoBlock.host;
        String string3 = dbInfoBlock.port == -1 ? "(unknown)" : String.valueOf(dbInfoBlock.port);
        ArchitectureComponent architectureComponent = ArchitectureComponent.databaseFrom(string, string2, string3);
        if (architectureComponent == null) {
            logger.debug("Cannot profile the database because we were unable to identify the architecture component: {}", (Object)string);
            return;
        }
        this.dbCacheMap.put((Connection)object, architectureComponent);
    }
}

