/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.commons.i;
import com.contrastsecurity.agent.commons.j;
import com.contrastsecurity.agent.commons.v;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsProtectDTM;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogEnhancerDTM;
import com.contrastsecurity.agent.plugins.a.a.a.g;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.H;
import com.contrastsecurity.agent.plugins.protect.I;
import com.contrastsecurity.agent.plugins.protect.Q;
import com.contrastsecurity.agent.plugins.protect.c.e;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.l;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.telemetry.b.c.a;
import com.contrastsecurity.agent.telemetry.b.g;
import com.contrastsecurity.agent.telemetry.b.k;
import com.contrastsecurity.agent.telemetry.b.n;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

@DontObfuscate
public class ProtectManager
implements I {
    private final CommonConfigProtectionMode globalOverrideMode;
    private final com.contrastsecurity.agent.config.g config;
    private final com.contrastsecurity.agent.plugins.protect.b.c canonicalizer;
    private final ConcurrentHashMap<String, Boolean> errorsLoggedForRuleMode;
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final com.contrastsecurity.agent.telemetry.b.k metrics;
    private final a.a reportCardFactory;
    private final g.c<n> requestTimer;
    private e deadzoneManager;
    private Collection<p> rules;
    private Map<Q, p> ruleById;
    private List<k> inputAwareRules;
    private Map<Long, LogEnhancerDTM> logEnhancers;
    private List<com.contrastsecurity.agent.plugins.protect.a> logEnhancerList;
    private Set<String> userTargetedClasses;
    private volatile boolean activated;
    private final ThreadLocal<H> protectContext = new ThreadLocal<H>(){

        protected H a() {
            return new H(ProtectManager.this.canonicalizer, ProtectManager.this.reportCardFactory.a(ProtectManager.this.requestTimer));
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ProtectManager.class);

    public ProtectManager(com.contrastsecurity.agent.config.g g2, ApplicationManager applicationManager, HttpManager httpManager, com.contrastsecurity.agent.telemetry.b.k k2) {
        this.config = Objects.requireNonNull(g2);
        this.applicationManager = Objects.requireNonNull(applicationManager);
        this.httpManager = Objects.requireNonNull(httpManager);
        this.metrics = Objects.requireNonNull(k2);
        n.a a2 = k2.d("requestTime", k.a.d).a("Records time taken to handle requests end-to-end, split by constituent parts (e.g. source analysis, sink analysis, etc.)").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L));
        this.requestTimer = k2.a(a2).a("aspect").a(com.contrastsecurity.agent.telemetry.b.a.a.b());
        this.reportCardFactory = new a.a(k2);
        this.canonicalizer = new com.contrastsecurity.agent.plugins.protect.b.c(k2, (d)new v());
        if (!g2.f(ConfigProperty.PROTECT_SINKS)) {
            G.a("Disabling defensive instrumentation sensors. No attacks can be blocked or confirmed exploited.");
        }
        this.errorsLoggedForRuleMode = new ConcurrentHashMap(0);
        this.globalOverrideMode = ProtectManager.calcGlobalModeOverride(g2);
    }

    void initializeDeadzoneManager(e e2) {
        Objects.requireNonNull(e2);
        if (this.deadzoneManager != null) {
            throw new IllegalStateException("DeadzoneManager has already been initialized");
        }
        this.deadzoneManager = e2;
    }

    void setRules(Collection<p> collection) {
        Objects.requireNonNull(collection);
        if (this.rules != null) {
            throw new IllegalStateException("rules have already been set");
        }
        if (this.deadzoneManager == null) {
            throw new IllegalStateException("DeadzoneManager has not yet been initialized");
        }
        j.a<p> a2 = j.b();
        this.inputAwareRules = new LinkedList<k>();
        this.ruleById = new EnumMap<Q, p>(Q.class);
        for (p p2 : collection) {
            this.ruleById.put(p2.getRuleId(), p2);
            if (p2 instanceof k) {
                if (p2.g() && this.metrics.a()) {
                    p2 = new l((k)p2, this.metrics);
                }
                this.inputAwareRules.add((k)p2);
            }
            a2.a(p2);
        }
        this.rules = a2.a();
    }

    public Set<String> getUserTargetedClasses() {
        if (this.userTargetedClasses == null && this.logEnhancerList != null) {
            this.userTargetedClasses = new HashSet<String>();
            for (com.contrastsecurity.agent.plugins.protect.a a2 : this.logEnhancerList) {
                if (a2 == null) continue;
                this.userTargetedClasses.add(a2.b());
            }
        }
        return this.userTargetedClasses;
    }

    public void onServerFeatureUpdate(ServerSettingsProtectDTM serverSettingsProtectDTM) {
        if (serverSettingsProtectDTM != null) {
            List<LogEnhancerDTM> list = serverSettingsProtectDTM.getLogEnhancers();
            if (list != null) {
                this.logEnhancers = this.toLogEnhancerMap(list);
                this.logEnhancerList = this.toList(list);
                logger.info("Enabling log enhancers of size={}", (Object)this.logEnhancerList.size());
            } else {
                this.logEnhancers = Collections.emptyMap();
                this.logEnhancerList = Collections.emptyList();
                logger.info("No log enhancers provided");
            }
        }
    }

    private List<com.contrastsecurity.agent.plugins.protect.a> toList(List<LogEnhancerDTM> list) {
        ArrayList<com.contrastsecurity.agent.plugins.protect.a> arrayList = new ArrayList<com.contrastsecurity.agent.plugins.protect.a>();
        if (list != null) {
            for (LogEnhancerDTM logEnhancerDTM : list) {
                arrayList.add(new com.contrastsecurity.agent.plugins.protect.a(logEnhancerDTM));
            }
        }
        return arrayList;
    }

    private Map<Long, LogEnhancerDTM> toLogEnhancerMap(List<LogEnhancerDTM> list) {
        HashMap<Long, LogEnhancerDTM> hashMap = new HashMap<Long, LogEnhancerDTM>();
        for (LogEnhancerDTM logEnhancerDTM : list) {
            hashMap.put(logEnhancerDTM.getId(), logEnhancerDTM);
        }
        return hashMap;
    }

    Collection<p> getRules() {
        return this.rules;
    }

    public Iterable<p> getEnabledRules() {
        return this.filterEnabled(this.rules);
    }

    public List<k> getEnabledInputRulesCalculated() {
        ArrayList<k> arrayList = new ArrayList<k>();
        for (k k2 : this.getEnabledInputAwareRules()) {
            arrayList.add(k2);
        }
        return arrayList;
    }

    public Iterable<k> getEnabledInputAwareRules() {
        return this.filterEnabled(this.inputAwareRules);
    }

    public Iterable<k> getInputAwareRules(H h2, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, String string) {
        Application application = this.applicationManager.current();
        return this.getInputAwareRules(new b<k>(h2, inputType, exceptionInputTypeDTM, string, this, application));
    }

    public Iterable<k> getInputAwareRules(Predicate<k> predicate) {
        a<k> a2 = new a<k>(predicate, this, this.httpManager.getCurrentRequest());
        return () -> i.a(this.inputAwareRules, a2);
    }

    public <T extends p> Iterable<T> filterEnabled(Collection<T> collection) {
        return () -> this.filterEnabledIterator(collection);
    }

    private <T extends p> Iterator<T> filterEnabledIterator(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyIterator();
        }
        return i.a(collection, new c(this, this.httpManager.getCurrentRequest()));
    }

    public boolean isDisabledByInputExclusion(p p2, ExceptionInputTypeDTM exceptionInputTypeDTM, String string, Application application) {
        Objects.requireNonNull(p2);
        Objects.requireNonNull(exceptionInputTypeDTM);
        com.contrastsecurity.agent.apps.exclusions.g g2 = this.getApplicationExclusionProcessor(application);
        if (g2 == null) {
            return false;
        }
        return g2.isInputExclusion(c.a.b, p2.getRuleId().a(), string, exceptionInputTypeDTM);
    }

    public com.contrastsecurity.agent.apps.exclusions.g getApplicationExclusionProcessor(Application application) {
        if (application == null) {
            return null;
        }
        return application.getExclusionProcessor();
    }

    public p getRuleById(Q q2) {
        return this.ruleById.get((Object)q2);
    }

    @C
    public <T extends p> T getRuleById(Q q2, Class<T> clazz) {
        return (T)((p)clazz.cast(this.ruleById.get((Object)q2)));
    }

    public boolean isSinksDisabled() {
        return !this.config.f(ConfigProperty.PROTECT_SINKS);
    }

    public boolean shouldProcessSink() {
        return this.activated && this.config.f(ConfigProperty.PROTECT_SINKS);
    }

    public H newContext() {
        H h2 = new H(this.canonicalizer, this.reportCardFactory.a(this.requestTimer));
        this.protectContext.set(h2);
        if (logger.isDebugEnabled()) {
            logger.debug("Created new context {}", (Object)P.a(h2));
        }
        return h2;
    }

    @Override
    public H currentContext() {
        return this.protectContext.get();
    }

    public void currentContext(H h2) {
        this.protectContext.set(Objects.requireNonNull(h2));
    }

    public LogEnhancerDTM getLogEnhancerById(long l2) {
        return this.logEnhancers.get(l2);
    }

    public List<com.contrastsecurity.agent.plugins.protect.a> getLogEnhancers() {
        return this.logEnhancerList;
    }

    private CommonConfigProtectionMode getAppRuleMode(p p2) {
        if (this.globalOverrideMode != null) {
            return this.globalOverrideMode;
        }
        return p2.getProtectRuleMode().a();
    }

    public CommonConfigProtectionMode getGlobalModeOverride() {
        return this.globalOverrideMode;
    }

    static CommonConfigProtectionMode calcGlobalModeOverride(com.contrastsecurity.agent.config.g g2) {
        CommonConfigProtectionMode commonConfigProtectionMode = null;
        String string = g2.c(ConfigProperty.PROTECT_RULE_MODE_OVERRIDE);
        if (!StringUtils.isEmpty(string)) {
            ProtectionModeDTM protectionModeDTM = com.contrastsecurity.agent.util.l.a(ProtectionModeDTM.class, string);
            if (protectionModeDTM == null) {
                logger.error("Invalid global override setting, will use defaults -- must be off,blocking or monitoring, was: {}", (Object)string);
            } else {
                commonConfigProtectionMode = CommonConfigProtectionMode.fromString(protectionModeDTM.toString());
            }
        }
        return commonConfigProtectionMode;
    }

    public boolean isRuleDisabled(Q q2) {
        return this.isRuleDisabled(q2, null);
    }

    public boolean isRuleDisabled(Q q2, HttpRequest httpRequest) {
        p p2 = this.ruleById.get((Object)q2);
        if (p2 == null) {
            throw new IllegalStateException("Rule not found for id: " + (Object)((Object)q2));
        }
        return this.isRuleDisabled(p2, httpRequest);
    }

    public boolean isRuleDisabled(p p2) {
        return this.isRuleDisabled(p2, null);
    }

    public boolean isRuleDisabled(p p2, HttpRequest httpRequest) {
        Object object;
        if (p2.a()) {
            return false;
        }
        if (!this.ruleById.containsKey((Object)p2.getRuleId().b())) {
            return true;
        }
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(p2);
        if (CommonConfigProtectionMode.OFF == commonConfigProtectionMode) {
            return true;
        }
        if (!this.shouldProcessSink()) {
            return true;
        }
        H h2 = this.currentContext();
        if (h2 != null && h2.b(p2.getRuleId())) {
            return true;
        }
        String string = p2.getRuleId().b().a();
        if (this.deadzoneManager.a(string)) {
            return true;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return false;
        }
        com.contrastsecurity.agent.apps.exclusions.g g2 = application.getExclusionProcessor();
        if (g2.hasUrlExclusions(c.a.b)) {
            Object object2 = object = httpRequest == null ? this.httpManager.getCurrentRequest() : httpRequest;
            if (object != null && application.getExclusionProcessor().isDisabledByUrl(c.a.b, string, ((HttpRequest)object).getUri())) {
                return true;
            }
        }
        if ((object = application.context().a(g.a)) == null) {
            return false;
        }
        return ((g)object).a(string, c.a.b);
    }

    public boolean canBlock(p p2) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(p2);
        return CommonConfigProtectionMode.BLOCK.equals((Object)commonConfigProtectionMode) || CommonConfigProtectionMode.BLOCK_AT_PERIMETER.equals((Object)commonConfigProtectionMode);
    }

    boolean shouldBlockAtPerimeter(k k2, UserInputDTM.InputType inputType) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(k2);
        return commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK_AT_PERIMETER || commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK && k2.a(inputType);
    }

    public boolean hasContextAndSinksAllowed() {
        return this.currentContext() != null && this.shouldProcessSink();
    }

    public boolean isScanParameterAsAnything() {
        return this.config.f(ConfigProperty.INSPECT_PARAMETERS_AS_JSON) || this.config.f(ConfigProperty.INSPECT_PARAMETERS_AS_XML);
    }

    public void checkParameterAccess() {
        H h2 = this.currentContext();
        if (h2.g()) {
            throw new AttackBlockedException("Attack already detected in parameters");
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
    }

    static final class c<T extends p>
    implements Predicate<T> {
        private final ProtectManager a;
        private final HttpRequest b;

        c(ProtectManager protectManager, HttpRequest httpRequest) {
            this.a = protectManager;
            this.b = httpRequest;
        }

        public boolean a(T t2) {
            return !this.a.isRuleDisabled((p)t2, this.b);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((p)object);
        }
    }

    static final class a<T extends p>
    implements Predicate<T> {
        private final Predicate<T> a;
        private final Predicate<T> b;

        a(Predicate<T> predicate, ProtectManager protectManager, HttpRequest httpRequest) {
            this.a = predicate;
            this.b = new c(protectManager, httpRequest);
        }

        public boolean a(T t2) {
            return this.a.test(t2) && this.b.test(t2);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((p)object);
        }
    }

    static final class b<T extends k>
    implements Predicate<T> {
        private final H a;
        private final UserInputDTM.InputType b;
        private final ExceptionInputTypeDTM c;
        private final String d;
        private final ProtectManager e;
        private final Application f;

        b(H h2, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, String string, ProtectManager protectManager, Application application) {
            this.a = h2;
            this.b = inputType;
            this.c = exceptionInputTypeDTM;
            this.d = string;
            this.e = protectManager;
            this.f = application;
        }

        public boolean a(T t2) {
            boolean bl2;
            Q q2 = t2.getRuleId();
            boolean bl3 = bl2 = t2.appliesToInputType(this.b) && !this.a.b(q2) && !this.e.isDisabledByInputExclusion((p)t2, this.c, this.d, this.f);
            if (!bl2 && logger.isTraceEnabled()) {
                logger.trace("Skipping {} input scanning for {} for {} due to exception", UserInputDTM.InputType.getStringType(this.b), q2.a(), this.d);
            }
            return bl2;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((k)object);
        }
    }
}

