/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.commons.j;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.contrastapi_v1_0.telemetry.SilentTelemetryDTM;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.f.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.r;
import com.contrastsecurity.agent.instr.i;
import com.contrastsecurity.agent.instr.t;
import com.contrastsecurity.agent.messages.app.activity.protect.ApplicationProtectActivityDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.AttackResult;
import com.contrastsecurity.agent.messages.app.activity.protect.AttackerActivityDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.ProtectRuleSampleDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.ProtectionRuleActivityDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.RuleEventsDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.SourceDTM;
import com.contrastsecurity.agent.messages.server.activity.protect.ServerProtectActivityDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.c;
import com.contrastsecurity.agent.plugins.protect.F;
import com.contrastsecurity.agent.plugins.protect.G;
import com.contrastsecurity.agent.plugins.protect.M;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.Q;
import com.contrastsecurity.agent.plugins.protect.b;
import com.contrastsecurity.agent.plugins.protect.c.e;
import com.contrastsecurity.agent.plugins.protect.g.k;
import com.contrastsecurity.agent.plugins.protect.h;
import com.contrastsecurity.agent.plugins.protect.i.g;
import com.contrastsecurity.agent.plugins.protect.i.o;
import com.contrastsecurity.agent.plugins.protect.rules.a;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.plugins.protect.u;
import com.contrastsecurity.agent.plugins.protect.v;
import com.contrastsecurity.agent.reloadable.ReloadableBeanManager;
import com.contrastsecurity.agent.services.a.as;
import com.contrastsecurity.agent.telemetry.errors.m;
import com.contrastsecurity.agent.telemetry.f;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.O;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.v.q;
import com.contrastsecurity.agent.v.s;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
public class ProtectPlugin
extends ContrastPlugin
implements com.contrastsecurity.agent.instr.a.c {
    public static final e.b<b> PROTECT_SETTINGS = e.b.a(b.class);
    private final com.contrastsecurity.agent.config.g config;
    private final F protectApplicationSettingsUpdateListener;
    private final com.contrastsecurity.agent.plugins.a.k applicationSettingsUpdateEventBus;
    private final ApplicationManager applicationManager;
    private final com.contrastsecurity.agent.plugins.protect.d.g deserializationContextService;
    private final h attackListener;
    private final List<r> requestLifecycleListeners;
    private final com.contrastsecurity.agent.plugins.e dbListener;
    private final ServerProtectActivityDTM serverProtectActivity;
    private final ProtectManager protectManager;
    private final boolean allowApiBodyRead;
    private final o sampleSettings;
    private final e deadzoneManager;
    private final G component;
    private final List<a> appAwareProtectRules;
    private final M instrumentation;
    public static final String APP_PROTECT_KEY = "defend";
    public static final e.b<g> APP_SOURCE_REPORTS = e.b.a(g.class);
    private static final Logger logger = LoggerFactory.getLogger(ProtectPlugin.class);

    public ProtectPlugin(d d2, ProtectManager protectManager, com.contrastsecurity.agent.features.c c2, com.contrastsecurity.agent.plugins.frameworks.o o2, com.contrastsecurity.agent.config.g g2, ApplicationManager applicationManager, com.contrastsecurity.agent.plugins.a.k k2, s s2, com.contrastsecurity.agent.w.k k3, ContrastEngine contrastEngine, HttpManager httpManager, f f2, com.contrastsecurity.agent.logging.c c3, as<SilentTelemetryDTM> as2, com.contrastsecurity.agent.telemetry.b b2, com.contrastsecurity.agent.q.b b3, com.contrastsecurity.agent.o.e e2) {
        this(g2, protectManager, c2, o2, httpManager, new com.contrastsecurity.agent.instr.e(), ReloadableBeanManager.get(), k3, d2, applicationManager, k2, s2, contrastEngine, f2.d(), f2.g(), c3, as2, b2, b3, e2);
    }

    @C
    public ProtectPlugin(com.contrastsecurity.agent.config.g g2, ProtectManager protectManager, com.contrastsecurity.agent.features.c c2, com.contrastsecurity.agent.plugins.frameworks.o o2, HttpManager httpManager, i i2, ReloadableBeanManager reloadableBeanManager, com.contrastsecurity.agent.w.k k2, d d2, ApplicationManager applicationManager, com.contrastsecurity.agent.plugins.a.k k3, s s2, ContrastEngine contrastEngine, com.contrastsecurity.agent.telemetry.b.k k4, m m2, com.contrastsecurity.agent.logging.c c3, as<SilentTelemetryDTM> as2, com.contrastsecurity.agent.telemetry.b b2, com.contrastsecurity.agent.q.b b3, com.contrastsecurity.agent.o.e e2) {
        Objects.requireNonNull(d2);
        Objects.requireNonNull(i2);
        Objects.requireNonNull(m2);
        Objects.requireNonNull(contrastEngine);
        Objects.requireNonNull(c2);
        Objects.requireNonNull(o2);
        Objects.requireNonNull(httpManager);
        Objects.requireNonNull(c3);
        Objects.requireNonNull(k4);
        Objects.requireNonNull(reloadableBeanManager);
        Objects.requireNonNull(as2);
        Objects.requireNonNull(s2);
        Objects.requireNonNull(k2);
        Objects.requireNonNull(b3);
        this.config = Objects.requireNonNull(g2);
        this.protectManager = Objects.requireNonNull(protectManager);
        this.allowApiBodyRead = g2.f(ConfigProperty.PROTECT_API_BODY_READ);
        this.protectApplicationSettingsUpdateListener = new F();
        this.sampleSettings = new o(g2);
        this.applicationManager = Objects.requireNonNull(applicationManager);
        this.applicationSettingsUpdateEventBus = Objects.requireNonNull(k3);
        N n2 = O.b();
        this.component = v.a().b(applicationManager).b(g2).b(contrastEngine.executorServiceModule()).b(contrastEngine).b(c2).b(d2).b(o2).b(httpManager).b(new t(i2)).b(c3).b(protectManager).b(k2).b(s2).b(reloadableBeanManager).b(new q(s2)).b(k4).b(m2).b(as2).b(b3).b(e2).a();
        this.instrumentation = this.component.o();
        this.deadzoneManager = this.component.c();
        this.appAwareProtectRules = this.component.h();
        n2.b();
        b2.a(PerfUtil.a.e, "protect-wire-dependencies", n2);
        n2.c();
        n2.a();
        e e3 = this.component.c();
        protectManager.initializeDeadzoneManager(e3);
        Collection<p> collection = this.component.g();
        protectManager.setRules(collection);
        n2.b();
        b2.a(PerfUtil.a.e, "protect-manager-init", n2);
        n2.c();
        n2.a();
        k k5 = this.component.w();
        c2.a("ProtectStateChangeListener", k5);
        protectManager.onServerFeatureUpdate(c2.c());
        this.dbListener = this.component.b();
        this.deserializationContextService = this.component.d();
        this.requestLifecycleListeners = j.a(this.component.m());
        this.attackListener = this.component.a();
        this.serverProtectActivity = this.component.n();
        n2.b();
        b2.a(PerfUtil.a.d, "protect-features-init", n2);
    }

    @Override
    public boolean preventDenylistingOf(String string) {
        boolean bl2 = false;
        Set<String> set = this.getTargetedClasses();
        if (set != null) {
            bl2 = set.contains(string);
        }
        return bl2;
    }

    Set<String> getTargetedClasses() {
        Set<String> set = null;
        if (this.protectManager != null) {
            set = this.protectManager.getUserTargetedClasses();
        }
        return set;
    }

    @Override
    public List<c> getClassTransformationListeners() {
        return this.config.f(ConfigProperty.PROTECT_ENABLED) ? j.a(this.component.o()) : Collections.emptyList();
    }

    @Override
    public com.contrastsecurity.agent.plugins.e getActivityEventListener() {
        com.contrastsecurity.agent.plugins.e e2 = null;
        if (this.config.f(ConfigProperty.PROTECT_ENABLED)) {
            e2 = this.dbListener;
        }
        return e2;
    }

    @Override
    public int limitRequestBodySizeCapturing() {
        return this.config.d(ConfigProperty.MAX_REQUEST_BODY_BYTES_CAPTURED);
    }

    @Override
    public List<r> getRequestLifecycleListeners() {
        return this.requestLifecycleListeners;
    }

    @Override
    public boolean requiresPrimordialInstrumentation(Class<?> clazz) {
        return Package.class.equals(clazz) || PrintWriter.class.equals(clazz) || this.instrumentation.a(clazz) || this.deadzoneManager.a(clazz);
    }

    @Override
    public void onApplicationInventoried(Application application) {
        for (a a2 : this.appAwareProtectRules) {
            a2.onApplicationProfiled(application);
        }
    }

    @Override
    public void onAppActivityReportingStarting(com.contrastsecurity.agent.services.ngreporting.a a2, Application application, Map<String, Object> map) {
        g g2 = application.context().a(APP_SOURCE_REPORTS, g.a);
        Map<SourceDTM, List<u<?>>> map2 = g2.b();
        if (!map2.isEmpty()) {
            this.preprocessActivity(a2, map, map2);
        }
    }

    private void preprocessActivity(com.contrastsecurity.agent.services.ngreporting.a a2, Map<String, Object> map, Map<SourceDTM, List<u<?>>> map2) {
        long l2 = System.currentTimeMillis();
        ArrayList<AttackerActivityDTM> arrayList = new ArrayList<AttackerActivityDTM>();
        for (SourceDTM sourceDTM : map2.keySet()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            HashMap hashMap = new HashMap();
            HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
            for (u<?> u2 : map2.get(sourceDTM)) {
                object4 = u2.b();
                object3 = u2.a();
                if (object4 == null || object3 == null) continue;
                object2 = hashMap2.computeIfAbsent((String)object4, string -> new HashMap());
                object = ((ProtectRuleSampleDTM)object3).getResult();
                object2.computeIfAbsent(object, attackResult -> new ArrayList()).add(object3);
            }
            for (String string2 : hashMap2.keySet()) {
                List list;
                List list2;
                List list3;
                object4 = (Map)hashMap2.get(string2);
                object3 = ProtectionRuleActivityDTM.builder().startTime(l2);
                object2 = (List)object4.get((Object)AttackResult.BLOCKED);
                if (object2 != null) {
                    ((ProtectionRuleActivityDTM.Builder)object3).blocked(new RuleEventsDTM(object2.subList(0, Math.min(object2.size(), this.sampleSettings.c())), object2.size(), l2));
                }
                if ((object = (List)object4.get((Object)AttackResult.BLOCKED_AT_PERIMETER)) != null) {
                    ((ProtectionRuleActivityDTM.Builder)object3).blockedAtPerimeter(new RuleEventsDTM(object.subList(0, Math.min(object.size(), this.sampleSettings.d())), object.size(), l2));
                }
                if ((list3 = (List)object4.get((Object)AttackResult.EXPLOITED)) != null) {
                    ((ProtectionRuleActivityDTM.Builder)object3).exploited(new RuleEventsDTM(list3.subList(0, Math.min(list3.size(), this.sampleSettings.b())), list3.size(), l2));
                }
                if ((list2 = (List)object4.get((Object)AttackResult.PROBED)) != null) {
                    ((ProtectionRuleActivityDTM.Builder)object3).ineffective(new RuleEventsDTM(list2.subList(0, Math.min(list2.size(), this.sampleSettings.a())), list2.size(), l2));
                }
                if ((list = (List)object4.get((Object)AttackResult.SUSPICIOUS)) != null) {
                    ((ProtectionRuleActivityDTM.Builder)object3).suspicious(new RuleEventsDTM(list.subList(0, Math.min(list.size(), this.sampleSettings.e())), list.size(), l2));
                }
                hashMap.put(string2, ((ProtectionRuleActivityDTM.Builder)object3).build());
            }
            arrayList.add(new AttackerActivityDTM(hashMap, sourceDTM));
        }
        a2.a();
        map.put(APP_PROTECT_KEY, new ApplicationProtectActivityDTM(arrayList, l2));
    }

    @Override
    public void onServerActivityReportingStarting(com.contrastsecurity.agent.services.ngreporting.a a2, Map<String, Object> map) {
        if (!this.config.f(ConfigProperty.PROTECT_ENABLED)) {
            return;
        }
        ServerProtectActivityDTM serverProtectActivityDTM = this.serverProtectActivity;
        if (this.isEmpty(serverProtectActivityDTM)) {
            return;
        }
        map.put(APP_PROTECT_KEY, serverProtectActivityDTM);
        a2.a();
    }

    private boolean isEmpty(ServerProtectActivityDTM serverProtectActivityDTM) {
        return serverProtectActivityDTM.getIpBlacklists().isEmpty() && serverProtectActivityDTM.getLogEnhancers().isEmpty();
    }

    @Override
    public void onServerActivityReportingFinished() {
        ServerProtectActivityDTM serverProtectActivityDTM = this.serverProtectActivity;
        serverProtectActivityDTM.getIpBlacklists().clear();
        serverProtectActivityDTM.getLogEnhancers().clear();
    }

    @Override
    public void activate() {
        super.activate();
        this.protectManager.activate();
        this.verifyApplicationSettingsEventPublisher();
        this.applicationSettingsUpdateEventBus.a(this.protectApplicationSettingsUpdateListener);
    }

    @Override
    public void deactivate() {
        this.protectManager.deactivate();
        this.verifyApplicationSettingsEventPublisher();
        this.applicationSettingsUpdateEventBus.b(this.protectApplicationSettingsUpdateListener);
        super.deactivate();
    }

    private void verifyApplicationSettingsEventPublisher() {
        if (this.applicationSettingsUpdateEventBus == null) {
            throw new IllegalStateException("Plugin lifecycle violation: expected onApplicationServiceProviderReady to be called before activate");
        }
    }

    @Override
    public boolean requiresHttpRequestBodyBuffering(HttpRequest httpRequest) {
        if (this.isDisabledUri(httpRequest, this.applicationManager.current(), this.config)) {
            logger.debug("Uri {} is skipped from request body buffering.", (Object)httpRequest.getUri());
            return false;
        }
        return this.isActivated() && !"GET".equals(httpRequest.getMethod());
    }

    @Override
    public boolean requiresHttpRequestBodyTotalCapture(HttpRequest httpRequest) {
        if (this.isDisabledUri(httpRequest, this.applicationManager.current(), this.config)) {
            logger.debug("Uri {} is skipped from request body total capturing.", (Object)httpRequest.getUri());
            return false;
        }
        return this.allowApiBodyRead && this.isActivated() && !"GET".equals(httpRequest.getMethod()) && httpRequest.getContentLength() > 0 && httpRequest.getContentType().c();
    }

    @Override
    public void onRequestBodyChunkRead(HttpRequest httpRequest, int n2, byte[] byArray, int n3, int n4) {
        boolean bl2;
        if (!this.isActivated()) {
            return;
        }
        if (!httpRequest.isCheckedForDeserializer()) {
            this.deserializationContextService.a();
            httpRequest.setCheckedForDeserializer(true);
        }
        if (!(bl2 = this.deserializationContextService.c()) && this.isDoneReading(httpRequest, n2 != -1 ? n2 : 0)) {
            this.processBodyInput(httpRequest);
        }
    }

    @Override
    public void onRequestBodyChunkRead(HttpRequest httpRequest, int n2) {
        boolean bl2;
        if (!this.isActivated()) {
            return;
        }
        if (!httpRequest.isCheckedForDeserializer()) {
            httpRequest.setCheckedForDeserializer(true);
            this.deserializationContextService.a();
        }
        if (!(bl2 = this.deserializationContextService.c()) && this.isDoneReading(httpRequest, n2 != -1 ? 1 : 0)) {
            this.processBodyInput(httpRequest);
        }
    }

    private void processBodyInput(HttpRequest httpRequest) {
        if (this.attackListener != null) {
            Charset charset = httpRequest.getCharset();
            H h2 = httpRequest.getMemoryBuffer().a(charset);
            this.attackListener.a(httpRequest, h2);
        }
    }

    private boolean isDoneReading(HttpRequest httpRequest, int n2) {
        com.contrastsecurity.agent.http.o o2 = httpRequest.getMemoryBuffer();
        int n3 = o2.b();
        return n3 == httpRequest.getContentLength();
    }

    @Override
    public boolean isActivated() {
        return this.config.f(ConfigProperty.PROTECT_ENABLED) && super.isActivated();
    }

    @Override
    public boolean isActivatedForUri(Application application, HttpRequest httpRequest) {
        return this.isActivated() && !this.isDisabledUri(httpRequest, application, this.config);
    }

    public G getComponent() {
        return this.component;
    }

    @C
    public p getRule(Q q2) {
        return this.protectManager.getRuleById(q2);
    }

    @Override
    protected boolean isDisabledUri(HttpRequest httpRequest, Application application, com.contrastsecurity.agent.config.g g2) {
        if (httpRequest == null || application == null) {
            return false;
        }
        com.contrastsecurity.agent.apps.exclusions.g g3 = application.getExclusionProcessor();
        boolean bl2 = g3.isDisabledByUrl(c.a.b, "all-rules", httpRequest.getUri());
        if (!bl2) {
            bl2 = g3.isDisabledByUrl(c.a.b, "all-protect-rules", httpRequest.getUri());
        }
        return bl2;
    }
}

