/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect.rules.xxe;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.messages.app.activity.protect.AttackResult;
import com.contrastsecurity.agent.messages.app.activity.protect.details.ExternalEntityWrapperDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.activity.protect.details.XMLMatchDTM;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.H;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.Q;
import com.contrastsecurity.agent.plugins.protect.S;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.XXEDetailsDTM;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d.a;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d.b;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.d.g;
import com.contrastsecurity.agent.plugins.protect.rules.xxe.e;
import com.contrastsecurity.agent.plugins.protect.w;
import com.contrastsecurity.agent.t.c;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.jregex.MatchIterator;
import com.contrastsecurity.thirdparty.jregex.MatchResult;
import com.contrastsecurity.thirdparty.jregex.Matcher;
import com.contrastsecurity.thirdparty.jregex.Pattern;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringEscapeUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.InputSource;

@Singleton
@DontObfuscate
public final class XXEProtectRule
implements p {
    private final com.contrastsecurity.agent.plugins.protect.d attackEventPublisher;
    private final ProtectManager manager;
    private final S protectRuleMode;
    @C
    static final Pattern EXTERNAL_ENTITY = new Pattern("(<!ENTITY(?:\\s+)[a-zA-Z0-f]+(?:\\s+)(?:SYSTEM|PUBLIC)(?:\\s+)(.*?)>)");
    @C
    static final Pattern XINCLUDE = new Pattern("(:include(?:\\s+)href=(?:['\"]((?:\\w:)*(?:\\/)*(?:[A-z0-9.-_+]+(?:\\/)*)+)['\"])(?:\\s*)(?:parse=)*)", 1);
    private static final String ERROR_XDPSTART = "xercesDocParsingStart";
    @C
    static final String WOODSTOX_KEY = Q.J.a() + "_woodstox";
    @C
    static final String XERCES_KEY = Q.J.a() + "_xerces";
    private static final String XERCES_STAX_KEY = Q.J.a() + "_xerces_stax";
    private static final String IBM_KEY = Q.J.a() + "_ibm_xlxp";
    private static final String[] PATH_UP_STRS = new String[]{"../", "..\\"};
    private static final String[] PATH_STRS = new String[]{"/", "."};
    private static final String[] SUSPICIOUS_CHARS = new String[]{"#", "?"};
    public static final int MAX_EVIDENCE_LENGTH = 2048;
    private static final Pattern WINDOWS_FILE_PATTERN = new Pattern("^[\\\\]*[a-zA-Z]{1,3}:.*");
    private static final Logger logger = LoggerFactory.getLogger(XXEProtectRule.class);
    private static final String INPUT_NAME = "XML Prolog";

    @Inject
    public XXEProtectRule(com.contrastsecurity.agent.plugins.protect.d d2, ProtectManager protectManager, com.contrastsecurity.agent.config.g g2) {
        this.attackEventPublisher = d2;
        this.manager = protectManager;
        this.protectRuleMode = new w(g2, ConfigProperty.PROTECT_XXE_MODE);
    }

    @Override
    public Q getRuleId() {
        return Q.J;
    }

    @Override
    public S getProtectRuleMode() {
        return this.protectRuleMode;
    }

    public void onXercesDocumentParsingStart(H h2, Object object) {
        try {
            this._onXercesDocumentParsingStart(h2, (InputSource)object);
        }
        catch (Throwable throwable) {
            com.contrastsecurity.agent.logging.a.a(ERROR_XDPSTART, logger, "Problem handling Xerces document parsing start", throwable);
        }
    }

    private void _onXercesDocumentParsingStart(H h2, InputSource inputSource) {
        Closeable closeable;
        if (logger.isDebugEnabled()) {
            logger.debug("Starting parsing context for input {} / {}", (Object)P.a(inputSource), (Object)inputSource.getClass().getName());
        }
        g g2 = new g();
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            closeable = this.wrap(inputStream);
            inputSource.setByteStream((InputStream)closeable);
            g2.a((a)closeable);
            if (logger.isDebugEnabled()) {
                logger.debug("Created wrapper for bytestream {} for context {}", (Object)P.a(inputStream), (Object)P.a(g2));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Bytestream was null -- no wrapper created for input {} for context {}", (Object)P.a(inputSource), (Object)P.a(g2));
        }
        closeable = inputSource.getCharacterStream();
        if (closeable != null) {
            b b2 = this.wrap((Reader)closeable);
            inputSource.setCharacterStream(b2);
            g2.a(b2);
            if (logger.isDebugEnabled()) {
                logger.debug("Created wrapper for reader {} for context {}", (Object)P.a(closeable), (Object)P.a(g2));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("reader was null -- no wrapper created for input {} for context {}", (Object)P.a(inputSource), (Object)P.a(g2));
        }
        logger.debug("Saving the context {}", (Object)g2);
        h2.a(XERCES_KEY, g2);
    }

    public void onXercesDoctypeDeclarationFinished(H h2) {
        try {
            this._onXercesDoctypeDeclarationFinished(h2);
        }
        catch (Exception exception) {
            logger.error("Problem handling Xerces doctype declaration end", exception);
        }
    }

    private void _onXercesDoctypeDeclarationFinished(H h2) {
        g g2 = (g)h2.a(XERCES_KEY);
        logger.debug("Xerces doctype declaration finishing for context {}", (Object)h2);
        if (g2 == null) {
            logger.debug("No xerces parsing context when doctype declaration finished");
            return;
        }
        g2.k();
        this.scanXml(g2, EXTERNAL_ENTITY);
    }

    public void onXercesEntityResolved(H h2, String string, Object object, boolean bl2, boolean bl3) {
        try {
            this._onXercesEntityResolved(h2, string, object, bl2, bl3);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Exception exception) {
            logger.error("Problem handling Xerces entity resolution", exception);
        }
    }

    private void _onXercesEntityResolved(H h2, String string, Object object, boolean bl2, boolean bl3) {
        d d2;
        String string2;
        e e2 = (e)h2.a(XERCES_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug("Entity {} name resolved for context {}", (Object)string, (Object)P.a(e2));
        }
        boolean bl4 = false;
        if (e2 == null) {
            e2 = (e)h2.a(XERCES_STAX_KEY);
            bl4 = true;
        }
        if (e2 == null) {
            if (!bl4) {
                logger.debug("No xerces parsing context when entity resolved");
                return;
            }
            e2 = new e();
            e2.a(this.buildSpoofedEntity(string, object));
        }
        if (this.isExternalEntityId(string2 = (d2 = new d(object)).a()) && !e2.h()) {
            e2.a(d2);
            e2.g();
            this.scanXml(e2, EXTERNAL_ENTITY);
            this.sendReport(e2);
        }
    }

    public void onXercesDocumentParsingEnd(H h2) {
        try {
            this._onXercesDocumentParsingEnd(h2);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Exception exception) {
            logger.error("Problem handling Xerces document parsing end", exception);
        }
    }

    private void _onXercesDocumentParsingEnd(H h2) {
        g g2 = (g)h2.b(XERCES_KEY);
        logger.debug("Xerces document parsing ends");
        if (g2 == null) {
            logger.debug("No xerces parsing context when document parsing ends");
            return;
        }
        List<d> list = g2.d();
        List<XMLMatchDTM> list2 = g2.c();
        if (!(list.isEmpty() || list2.isEmpty() || g2.h())) {
            if (!g2.e()) {
                this.scanXml(g2, EXTERNAL_ENTITY);
            }
            this.sendReport(g2);
        }
    }

    public void onStAXEventRead(H h2, Object object, Object object2) {
        try {
            this._onStAXEventRead(h2, object, object2);
        }
        catch (Exception exception) {
            logger.error("Problem handling StAX event read", exception);
        }
    }

    private void _onStAXEventRead(H h2, Object object, Object object2) {
        String string;
        logger.debug("Analyzing reader {} and event {}", object, object2);
        e e2 = (e)h2.a(XERCES_STAX_KEY);
        if (e2 == null) {
            e2 = new e();
            h2.a(XERCES_STAX_KEY, e2);
        }
        if ("DTDEvent".equals(string = object2.getClass().getSimpleName())) {
            e2.a(object2.toString());
            this.scanXml(e2, EXTERNAL_ENTITY);
        } else if ("EndDocumentEvent".equals(string)) {
            h2.b(XERCES_STAX_KEY);
        }
    }

    public void onWoodstoxStAXEventRead(H h2, Object object) {
        try {
            this._onWoodstoxStAXEventRead(h2, object);
        }
        catch (Exception exception) {
            logger.error("Problem handling Woodstox/StAX event read", exception);
        }
    }

    private void _onWoodstoxStAXEventRead(H h2, Object object) {
        com.contrastsecurity.agent.plugins.protect.rules.xxe.c.d d2;
        int n2;
        logger.debug("Analyzing reader {}", object);
        e e2 = (e)h2.a(WOODSTOX_KEY);
        if (e2 == null) {
            e2 = new e();
            h2.a(WOODSTOX_KEY, e2);
        }
        if (11 == (n2 = (d2 = new com.contrastsecurity.agent.plugins.protect.rules.xxe.c.d(object)).a())) {
            e2.a("<?xml version=\"1.0\"?>" + d2.b());
            this.scanXml(e2, EXTERNAL_ENTITY);
        } else if (8 == n2) {
            h2.b(WOODSTOX_KEY);
        }
    }

    public void onWoodstoxEntityResolved(H h2, Object object) {
        try {
            this._onWoodstoxEntityResolved(h2, object);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Exception exception) {
            logger.error("Problem handling Woodtstox entity resolution", exception);
        }
    }

    private void _onWoodstoxEntityResolved(H h2, Object object) {
        e e2 = (e)h2.a(WOODSTOX_KEY);
        if (e2 == null) {
            logger.debug("No woodstox parsing context when entity resolved");
            return;
        }
        d d2 = new d(object);
        String string = d2.a();
        if (this.isExternalEntityId(string)) {
            e2.a(d2);
            this.sendReport(e2);
        }
    }

    void onIbmXlxpDoctypeParsingEnd(H h2, Object object) {
        try {
            this._onIbmXlxpDoctypeParsingEnd(h2, object);
        }
        catch (Exception exception) {
            logger.error("Problem handling IBM XLMP doctype parsing", exception);
        }
    }

    private void _onIbmXlxpDoctypeParsingEnd(H h2, Object object) throws NoSuchMethodException, IllegalAccessException {
        String string;
        try {
            string = com.contrastsecurity.agent.t.b.a(object).c("fDoctypeString").b().toString();
        }
        catch (c c2) {
            logger.debug("Unable to obtain fDoctypeString field", c2);
            return;
        }
        if (string == null) {
            logger.debug("Null xml body received by Contrast IBM XLXP listener");
            return;
        }
        if (string.contains("DTDScanner")) {
            throw new NoSuchMethodException("toString is implemented on the Object rather than StAXDTDScanner and thus dont return the string representation we want");
        }
        e e2 = (e)h2.a(IBM_KEY);
        if (e2 == null) {
            e2 = new e();
            h2.a(IBM_KEY, e2);
        }
        e2.a(string);
        this.scanXml(e2, EXTERNAL_ENTITY);
    }

    void onIbmXlxpExternalEntityResolved(H h2, Object object, Object object2) {
        try {
            this._onIbmXlxpExternalEntityResolved(h2, object, object2);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Exception exception) {
            logger.error("Problem handling IBM XLMP entity resolution", exception);
        }
    }

    private void _onIbmXlxpExternalEntityResolved(H h2, Object object, Object object2) {
        String string = object != null ? object.toString() : null;
        String string2 = object2.toString();
        e e2 = (e)h2.a(IBM_KEY);
        if (e2 == null) {
            e2 = new e();
            h2.a(IBM_KEY, e2);
        }
        if (this.isExternalEntityId(string2)) {
            d d2 = new d(string2, string);
            e2.a(d2);
            this.sendReport(e2);
        }
    }

    boolean isExternalEntityId(String string) {
        if (string == null) {
            return false;
        }
        if ((StringUtils.endsWithIgnoreCase(string, ".dtd") || StringUtils.endsWithIgnoreCase(string, ".xsd") || StringUtils.endsWithIgnoreCase(string, ".ent")) && !this.containsSuspiciousChars(string)) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase(string, "http:") || StringUtils.startsWithIgnoreCase(string, "https:") || StringUtils.startsWithIgnoreCase(string, "file:") || StringUtils.startsWithIgnoreCase(string, "ftp:") || StringUtils.startsWithIgnoreCase(string, "jar:") || StringUtils.startsWithIgnoreCase(string, "gopher:")) {
            return true;
        }
        if (StringUtils.startsWithAny(string, PATH_STRS)) {
            return true;
        }
        String string2 = URLDecoder.decode(string);
        for (String string3 : PATH_UP_STRS) {
            if (!string2.contains(string3)) continue;
            return true;
        }
        return WINDOWS_FILE_PATTERN.matches(string);
    }

    private boolean containsSuspiciousChars(String string) {
        String string2 = URLDecoder.decode(string);
        for (String string3 : SUSPICIOUS_CHARS) {
            if (!string.contains(string3) && !string2.contains(string3)) continue;
            return true;
        }
        return false;
    }

    private void sendReport(e e2) {
        String string = e2.b();
        ArrayList<d> arrayList = new ArrayList<d>(e2.d());
        boolean bl2 = this.manager.canBlock(this);
        XXEDetailsDTM xXEDetailsDTM = this.buildXXEDetailsDTM(e2.c(), arrayList, string);
        AttackResult attackResult = bl2 ? AttackResult.BLOCKED : AttackResult.EXPLOITED;
        this.attackEventPublisher.a(Q.J, xXEDetailsDTM, UserInputDTM.builder().value(string).name(INPUT_NAME).type(UserInputDTM.InputType.UNKNOWN).time(e2.a()).build(), attackResult);
        if (bl2) {
            throw new AttackBlockedException("XXE attack detected");
        }
    }

    private XXEDetailsDTM buildXXEDetailsDTM(List<XMLMatchDTM> list, List<d> list2, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<ExternalEntityWrapperDTM> linkedList = new LinkedList<ExternalEntityWrapperDTM>();
        if (list2 != null) {
            for (d d2 : list2) {
                String string2 = d2.a();
                String string3 = d2.b();
                String string4 = string2 + string3;
                if (hashSet.contains(string4)) continue;
                hashSet.add(string4);
                linkedList.add(new ExternalEntityWrapperDTM(string2, string3));
            }
        }
        return new XXEDetailsDTM(string, list, linkedList);
    }

    private void scanXml(e e2, Pattern pattern) {
        String string = e2.b();
        if (string != null) {
            Matcher matcher = pattern.matcher(StringEscapeUtils.unescapeHtml(string));
            MatchIterator matchIterator = matcher.findAll();
            while (matchIterator.hasMore()) {
                MatchResult matchResult = matchIterator.nextMatch();
                int n2 = matchResult.start(2);
                int n3 = matchResult.end(2);
                e2.a(new XMLMatchDTM(n2, n3));
            }
        }
        if (pattern.equals(EXTERNAL_ENTITY)) {
            e2.f();
        }
    }

    private String buildSpoofedEntity(String string, Object object) {
        String string2 = null;
        try {
            string2 = com.contrastsecurity.agent.t.b.a(object).c("fSystemId").a();
        }
        catch (c c2) {
            logger.error("Problem inspecting XML input source during external entity resolution", c2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("...[<!ENTITY ");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(" SYSTEM ");
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(" ... ");
        }
        stringBuilder.append(">]...");
        return stringBuilder.toString();
    }

    private b wrap(Reader reader) {
        return new b(reader);
    }

    private a wrap(InputStream inputStream) {
        return new a(inputStream);
    }

    public void onXercesXIncludeGetReaderCallResolved(H h2, Object object) {
        try {
            this._onXercesXIncludeGetReaderCallResolved(h2, object);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Exception exception) {
            logger.error("Problem handling XInclude getReader call resolved", exception);
        }
    }

    private void _onXercesXIncludeGetReaderCallResolved(H h2, Object object) {
        d d2;
        String string;
        g g2 = (g)h2.a(XERCES_KEY);
        if (g2 == null) {
            g2 = new g();
            h2.a(XERCES_KEY, g2);
        }
        if (this.isExternalEntityId(string = (d2 = new d(object)).a()) && !g2.h()) {
            g2.a(d2);
            g2.g();
            g2.k();
            this.scanXml(g2, XINCLUDE);
            this.sendReport(g2);
        }
    }
}

