/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.messages.server.features.assessment.CustomRuleAPI;
import com.contrastsecurity.agent.messages.server.features.assessment.InputValidatorDTM;
import com.contrastsecurity.agent.messages.server.features.assessment.SanitizerDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.F;
import com.contrastsecurity.agent.plugins.security.M;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.EventHelper;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.a.A;
import com.contrastsecurity.agent.plugins.security.controller.a.B;
import com.contrastsecurity.agent.plugins.security.controller.a.C;
import com.contrastsecurity.agent.plugins.security.controller.a.D;
import com.contrastsecurity.agent.plugins.security.controller.a.E;
import com.contrastsecurity.agent.plugins.security.controller.a.b;
import com.contrastsecurity.agent.plugins.security.controller.a.e;
import com.contrastsecurity.agent.plugins.security.controller.a.g;
import com.contrastsecurity.agent.plugins.security.controller.a.i;
import com.contrastsecurity.agent.plugins.security.controller.a.j;
import com.contrastsecurity.agent.plugins.security.controller.a.k;
import com.contrastsecurity.agent.plugins.security.controller.a.l;
import com.contrastsecurity.agent.plugins.security.controller.a.m;
import com.contrastsecurity.agent.plugins.security.controller.a.n;
import com.contrastsecurity.agent.plugins.security.controller.a.o;
import com.contrastsecurity.agent.plugins.security.controller.a.p;
import com.contrastsecurity.agent.plugins.security.controller.a.q;
import com.contrastsecurity.agent.plugins.security.controller.a.r;
import com.contrastsecurity.agent.plugins.security.controller.a.s;
import com.contrastsecurity.agent.plugins.security.controller.a.t;
import com.contrastsecurity.agent.plugins.security.controller.a.u;
import com.contrastsecurity.agent.plugins.security.controller.a.v;
import com.contrastsecurity.agent.plugins.security.controller.a.w;
import com.contrastsecurity.agent.plugins.security.controller.a.x;
import com.contrastsecurity.agent.plugins.security.controller.a.y;
import com.contrastsecurity.agent.plugins.security.controller.a.z;
import com.contrastsecurity.agent.plugins.security.controller.propagate.c;
import com.contrastsecurity.agent.plugins.security.controller.trigger.ObjectCheck;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.rules.d;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ApplicationAnalyzer;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.f;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.h;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.crossdomainpolicy.CrossDomainResponseWatcher;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Singleton
@DontObfuscate
public final class AssessPlugin
extends ContrastPlugin
implements com.contrastsecurity.agent.instr.a.c,
M {
    private static AssessPlugin global;
    private final List<com.contrastsecurity.agent.util.B> assessInitializationTasks;
    private final com.contrastsecurity.agent.config.g config;
    private final EventHelper eventHelper;
    private final List<com.contrastsecurity.agent.plugins.c> classEventListeners;
    private final com.contrastsecurity.agent.plugins.security.policy.rules.providers.c ruleActivityListener;
    private final h ruleProviders;
    private final com.contrastsecurity.agent.features.c featureManager;
    private final List<com.contrastsecurity.agent.http.r> requestListeners;
    private final ProviderUtil providerUtil;
    private final AssessmentManager assessmentManager;
    private final EventContext eventContext;
    private final HttpManager httpManager;
    private final com.contrastsecurity.agent.scope.e scopeProviderAssess;
    private final com.contrastsecurity.agent.plugins.security.b.a debugStringFactory;
    private final TraceController traceController;
    private final d findingTestCache;
    private final ContrastScopeTrackerDispatcher scopeTrackerDispatcher;
    private final F routeObservationListener;
    private final c contrastDataFlowTaggingService;
    private final com.contrastsecurity.agent.plugins.security.controller.track.a sourceCreationService;
    private final int maxRequestBodyBuffering;
    private final com.contrastsecurity.agent.plugins.security.policy.c policyManager;
    private Set<String> securityControlClassNames;
    private static final Logger logger;

    public static AssessPlugin getGlobal() {
        if (global == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return global;
    }

    public static M getSecurityServiceProvider() {
        return AssessPlugin.getGlobal();
    }

    @Inject
    public AssessPlugin(com.contrastsecurity.agent.config.g g2, com.contrastsecurity.agent.features.c c2, ApplicationManager applicationManager, HttpManager httpManager, AssessmentManager assessmentManager, EventContext eventContext, TraceController traceController, d d2, ProviderUtil providerUtil, EventHelper eventHelper, com.contrastsecurity.agent.scope.e e2, com.contrastsecurity.agent.plugins.security.a a2, Set<com.contrastsecurity.agent.config.x> set, F f2, Set<com.contrastsecurity.agent.http.r> set2, ContrastDataFlowPropagationDispatcher contrastDataFlowPropagationDispatcher, c c3, com.contrastsecurity.agent.plugins.security.controller.track.a a3, ContrastAssessDispatcherLocator contrastAssessDispatcherLocator, ContrastScopeTrackerDispatcher contrastScopeTrackerDispatcher, com.contrastsecurity.agent.plugins.security.policy.rules.providers.c c4, h h2, com.contrastsecurity.agent.telemetry.b b2, com.contrastsecurity.agent.plugins.security.b.a a4, com.contrastsecurity.agent.plugins.security.policy.c c5) {
        this.config = g2;
        this.featureManager = c2;
        this.httpManager = httpManager;
        this.assessmentManager = assessmentManager;
        this.eventContext = eventContext;
        this.traceController = traceController;
        this.findingTestCache = d2;
        this.providerUtil = providerUtil;
        this.eventHelper = eventHelper;
        this.classEventListeners = com.contrastsecurity.agent.commons.j.a(a2);
        this.ruleActivityListener = c4;
        this.ruleProviders = h2;
        this.scopeProviderAssess = e2;
        this.debugStringFactory = a4;
        this.policyManager = Objects.requireNonNull(c5);
        c5.a((c.a)contrastDataFlowPropagationDispatcher);
        this.scopeTrackerDispatcher = contrastScopeTrackerDispatcher;
        this.assessInitializationTasks = com.contrastsecurity.agent.commons.j.a(new a(b2));
        for (com.contrastsecurity.agent.config.x x2 : set) {
            g2.a(x2);
        }
        this.routeObservationListener = f2;
        this.requestListeners = com.contrastsecurity.agent.commons.j.a(set2);
        this.contrastDataFlowTaggingService = c3;
        this.sourceCreationService = a3;
        ContrastAssessDispatcherLocator.Singleton.initialize((ContrastAssessDispatcherLocator)contrastAssessDispatcherLocator);
        this.maxRequestBodyBuffering = g2.d(ConfigProperty.MAX_REQUEST_BODY_BUFFERING_DEFAULT);
    }

    @Override
    public void initializeGlobalContext() {
        super.initializeGlobalContext();
        if (global != null) {
            throw new IllegalStateException("SecurityPlugin global already initialized");
        }
        global = this;
    }

    public static void setEnabled(EventContext eventContext, com.contrastsecurity.agent.scope.e e2, boolean bl2) {
        eventContext.setEnabled(bl2);
        e2.setEnabled(bl2);
    }

    @Override
    public boolean preventDenylistingOf(String string) {
        if (this.securityControlClassNames == null) {
            this.buildSecurityControlClassList(this.featureManager.b());
        }
        return this.securityControlClassNames.contains(string);
    }

    void buildSecurityControlClassList(ServerSettingsAssessDTM serverSettingsAssessDTM) {
        this.securityControlClassNames = new HashSet<String>();
        if (this.config.f(ConfigProperty.ASSESS_ENABLED) && serverSettingsAssessDTM != null) {
            Object object;
            Object object2;
            Object object3;
            Set<SanitizerDTM> set = serverSettingsAssessDTM.getSanitizers();
            if (set != null) {
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object2 = (SanitizerDTM)object3.next();
                    object = this.parseClassName(((CustomRuleAPI)object2).getApi());
                    if (StringUtils.isEmpty((String)object)) continue;
                    logger.debug("Adding {} (sanitizer) to the list of security control class names to prevent denylisting", object);
                    this.securityControlClassNames.add((String)object);
                }
            }
            if ((object3 = serverSettingsAssessDTM.getValidators()) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (InputValidatorDTM)object2.next();
                    String string = this.parseClassName(((CustomRuleAPI)object).getApi());
                    if (StringUtils.isEmpty(string)) continue;
                    logger.debug("Adding {} (validator) to the list of security control class names to prevent denylisting", (Object)string);
                    this.securityControlClassNames.add(string);
                }
            }
        }
    }

    private String parseClassName(String string) {
        String string2 = null;
        try {
            com.contrastsecurity.agent.plugins.security.policy.r r2 = com.contrastsecurity.agent.plugins.security.policy.t.a(string, false, true);
            string2 = r2.a();
        }
        catch (Exception exception) {
            logger.error("Problem parsing API {} to prevent denylisting new security controls", (Object)string, (Object)exception);
        }
        return string2;
    }

    @Override
    public List<com.contrastsecurity.agent.plugins.c> getClassTransformationListeners() {
        List<com.contrastsecurity.agent.plugins.c> list = Collections.emptyList();
        if (this.config.f(ConfigProperty.ASSESS_ENABLED)) {
            list = this.classEventListeners;
        }
        return list;
    }

    @Override
    public List<com.contrastsecurity.agent.http.r> getRequestLifecycleListeners() {
        return this.requestListeners;
    }

    @Override
    public void initialize() throws com.contrastsecurity.agent.plugins.h {
        if (!this.config.f(ConfigProperty.ASSESS_ENABLED)) {
            logger.debug("Not assessing, so skipping policy lookup");
            return;
        }
        for (com.contrastsecurity.agent.util.B b2 : this.assessInitializationTasks) {
            b2.b();
        }
    }

    @Override
    public void onCrossDomainXmlRead(Application application, String string) {
        if (!this.config.f(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        for (f<?> f2 : this.ruleProviders) {
            if (!(f2 instanceof com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.crossdomainpolicy.c)) continue;
            HttpWatcher httpWatcher = f2.d();
            if (httpWatcher instanceof CrossDomainResponseWatcher) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Handing analysis of crossdomain.xml to {}", (Object)httpWatcher.getClass().getName());
                }
                try {
                    ((CrossDomainResponseWatcher)httpWatcher).analyzeCrossDomainXML(application, string);
                }
                catch (Throwable throwable) {
                    logger.error("Problem during crossDomainXmlRead() for {}", (Object)f2.getClass().getName(), (Object)throwable);
                }
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.error("Problem finding the cross domain watcher");
        }
    }

    @Override
    public void onWebConfigurationRead(Application application, String string) {
        if (!this.config.f(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        logger.debug("Letting rule providers know about new app loaded");
        for (f<?> f2 : this.ruleProviders) {
            ApplicationAnalyzer applicationAnalyzer = f2.e();
            if (applicationAnalyzer == null) continue;
            logger.debug("Handing analysis of web root to {}", (Object)applicationAnalyzer.getClass().getName());
            try {
                applicationAnalyzer.onApplicationResolution(application, string);
            }
            catch (Throwable throwable) {
                logger.error("Problem during onWebXmlLoaded() for {}", (Object)f2.getClass().getName(), (Object)throwable);
            }
        }
    }

    @Override
    public boolean requiresPrimordialInstrumentation(Class<?> clazz) {
        return this.config.f(ConfigProperty.ASSESS_ENABLED);
    }

    @Override
    public boolean requiresHttpResponseBuffering(HttpRequest httpRequest, HttpResponse httpResponse) {
        return this.isActivated() && !com.contrastsecurity.agent.util.s.b(httpRequest) && !httpRequest.getResponseWatchers().isEmpty();
    }

    @Override
    public com.contrastsecurity.agent.plugins.e getActivityEventListener() {
        com.contrastsecurity.agent.plugins.security.policy.rules.providers.c c2 = null;
        if (this.config.f(ConfigProperty.ASSESS_ENABLED)) {
            c2 = this.ruleActivityListener;
        }
        return c2;
    }

    @Override
    public int limitRequestBodySizeCapturing() {
        return this.maxRequestBodyBuffering;
    }

    public void onSecurityControlsChanged() {
        this.securityControlClassNames = null;
    }

    @Override
    public boolean isActivated() {
        return super.isActivated() && this.config.f(ConfigProperty.ASSESS_ENABLED);
    }

    @Override
    public boolean isActivatedForUri(Application application, HttpRequest httpRequest) {
        return this.isActivated() && !this.isDisabledUri(httpRequest, application, this.config);
    }

    @Override
    public void activate() {
        super.activate();
        AssessPlugin.setEnabled(this.eventContext, this.scopeProviderAssess, true);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        AssessPlugin.setEnabled(this.eventContext, this.scopeProviderAssess, false);
    }

    @Override
    public List<Purgeable> getPurgeables() {
        return com.contrastsecurity.agent.commons.j.a(this.debugStringFactory, this.eventContext);
    }

    @Override
    public c getContrastDataFlowTaggingService() {
        return this.contrastDataFlowTaggingService;
    }

    @Override
    public com.contrastsecurity.agent.plugins.security.controller.track.a getContrastDataFlowSourceCreationService() {
        return this.sourceCreationService;
    }

    @Override
    public AssessmentManager getAssessmentManager() {
        return this.assessmentManager;
    }

    @Override
    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }

    @Override
    public F getRouteObservationListener() {
        return this.routeObservationListener;
    }

    @Override
    protected boolean isDisabledUri(HttpRequest httpRequest, Application application, com.contrastsecurity.agent.config.g g2) {
        if (httpRequest == null || application == null) {
            return false;
        }
        com.contrastsecurity.agent.apps.exclusions.g g3 = application.getExclusionProcessor();
        return g3.isDisabledByUrl(c.a.a, "all-rules", httpRequest.getUri()) || g3.isDisabledByUrl(c.a.a, "all-assess-rules", httpRequest.getUri());
    }

    static {
        logger = LoggerFactory.getLogger(AssessPlugin.class);
    }

    private class a
    extends com.contrastsecurity.agent.util.B {
        private a(com.contrastsecurity.agent.telemetry.b b2) {
            super(b2, "register-agent-telemetry", PerfUtil.a.c);
        }

        @Override
        public void a() {
            AgentChannelHub agentChannelHub = AgentChannelHub.getOrNull(AssessPlugin.this.config);
            if (agentChannelHub == null) {
                return;
            }
            agentChannelHub.listenForMessage("isTracked", new B(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("isTrackedWithTag", new C(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("isTrackedWithoutTag", new E(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("isTrackedWithType", new D(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("printTagRanges", new com.contrastsecurity.agent.plugins.security.controller.a.F(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("hasFinding", new x(AssessPlugin.this.findingTestCache));
            agentChannelHub.listenForMessage("hasNoFinding", new z(AssessPlugin.this.findingTestCache));
            agentChannelHub.listenForMessage("hasEventSource", new w(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getLastFindingHash", new m(AssessPlugin.this.findingTestCache));
            agentChannelHub.listenForMessage("enableRecentFindings", new com.contrastsecurity.agent.plugins.security.controller.a.f(AssessPlugin.this.findingTestCache));
            agentChannelHub.listenForMessage("clearRecentFindings", new com.contrastsecurity.agent.plugins.security.controller.a.c(AssessPlugin.this.findingTestCache));
            agentChannelHub.listenForMessage("getBitSetForObject", new g(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventStringRepresentations", new k(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventOperations", new i(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventTaintFlags", new l(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("hasTagRange", new A(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("hasFrameworkInfo", new y(AssessPlugin.this.httpManager));
            agentChannelHub.listenForMessage("getTagRangeCount", new r(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getCurrentRequestInfo", new o(AssessPlugin.this.httpManager));
            agentChannelHub.listenForMessage("getTagRanges", new s(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("addTags", new b(AssessPlugin.this.eventHelper, AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getTags", new u(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getTagsAt", new t(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("addTagFrom", new com.contrastsecurity.agent.plugins.security.controller.a.a(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getTagRangeBoundaries", new q(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("doesTagCheckPass", new e(new ObjectCheck(AssessPlugin.this.eventHelper, AssessPlugin.this.traceController), AssessPlugin.this.traceController, AssessPlugin.this.policyManager));
            agentChannelHub.listenForMessage("clearTagRanges", new com.contrastsecurity.agent.plugins.security.controller.a.d(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getTriggerScope", new v(AssessPlugin.this.eventContext, AssessPlugin.this.scopeTrackerDispatcher));
            agentChannelHub.listenForMessage("getEventIdFor", new com.contrastsecurity.agent.plugins.security.controller.a.h(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getSourceEventReturn", new p(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getParentEventIdFor", new n(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventStackTrace", new j(AssessPlugin.this.assessmentManager, AssessPlugin.this.traceController));
            agentChannelHub.subscribe(AssessPlugin.this.config, "clearTraceMap", AssessPlugin.this.eventContext);
        }
    }
}

