/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.g;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.plugins.security.controller.r;
import com.contrastsecurity.agent.plugins.security.controller.trigger.o;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.plugins.security.policy.w;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class AssessSourceExclusionHandler
implements o {
    private final HttpManager httpManager;
    private static final Logger logger = LoggerFactory.getLogger(AssessSourceExclusionHandler.class);

    public AssessSourceExclusionHandler(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, r r2) {
        List<CodeEvent> list = trace.getEvents();
        boolean bl2 = true;
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        g g2 = application.getExclusionProcessor();
        for (int i2 = 0; i2 < list.size() && bl2; ++i2) {
            CodeEvent codeEvent = list.get(i2);
            if (!(codeEvent instanceof SourceEvent)) continue;
            bl2 = !this.isSourceExclusion(trace, rule, (SourceEvent)codeEvent, httpRequest, g2);
        }
        return bl2;
    }

    @C
    boolean isSourceExclusion(Trace trace, Rule rule, SourceEvent sourceEvent, HttpRequest httpRequest, g g2) {
        if (g2 == null) {
            logger.debug("Skipping exclusion processing: exclusion processor is null");
            return false;
        }
        String string = rule.getId();
        u u2 = sourceEvent.getSource();
        if (!u2.hasSourceTypes()) {
            logger.debug("Skipping exclusion processing: untrusted data source [{}] does not have a processable type", (Object)u2.getId());
            return false;
        }
        if (sourceEvent.getQueue() != null && (u2.isSourceType(w.u) || u2.isSourceType(w.v) || u2.isSourceType(w.w) || u2.isSourceType(w.x))) {
            return g2.isQueueExclusion(c.a.a, string, sourceEvent.getQueue());
        }
        if (httpRequest == null) {
            logger.debug("Skipping exclusion processing: request model is null");
            return false;
        }
        if (u2.isSourceType(w.g)) {
            String string2 = this.extractInputName(trace, sourceEvent, u2);
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.PARAMETER, string2);
        }
        if (u2.isSourceType(w.d)) {
            String string3 = this.extractInputName(trace, sourceEvent, u2);
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, string3);
        }
        if (u2.isSourceType(w.h)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.QUERYSTRING);
        }
        if (u2.isSourceType(w.c)) {
            String string4 = sourceEvent.getFieldName();
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.COOKIE, string4);
        }
        if (u2.isSourceType(w.a) || u2.isSourceType(w.f)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.BODY);
        }
        if (u2.isSourceType(w.t)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, "authorization");
        }
        return false;
    }

    private String extractInputName(Trace trace, SourceEvent sourceEvent, u u2) {
        String string = null;
        if (sourceEvent != null) {
            string = sourceEvent.getFieldName();
        }
        if (sourceEvent != null && string == null) {
            char[] cArray;
            int n2;
            if (u2 != null && u2.isSourceType(w.q)) {
                if (sourceEvent.getParameters() != null && sourceEvent.getParameters().length > 0) {
                    string = new String(sourceEvent.getParameters()[0]);
                }
            } else if (u2 != null && u2.isSourceType(w.p) && trace != null && trace.getEvents() != null && !trace.getEvents().isEmpty() && (n2 = trace.getEvents().indexOf(sourceEvent)) >= 0 && trace.getEvents().size() > n2 && (cArray = trace.getEvents().get(n2 + 1).getRet()) != null && cArray.length > 0) {
                string = new String(cArray);
            }
        }
        return string;
    }
}

