/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;

@Singleton
@DontObfuscate
public class AssessmentManager {
    private final d clock;
    private final g config;
    @DontObfuscate
    private final ThreadLocal<AssessmentContext> assessmentContext = ThreadLocal.withInitial(() -> null);
    @DontObfuscate
    private final long maxContextTtl;
    private int contextsCreated;
    private long totalMapSize;
    private static final int DEFAULT_TRACEMAP_SIZE = 75;
    private static final int MINIMUM_CONTEXTS_BEFORE_PREDICTING_TRACEMAP_SIZE = 5;
    private static final Logger logger = LoggerFactory.getLogger(AssessmentManager.class);

    @Inject
    public AssessmentManager(d d2, g g2) {
        this.clock = d2;
        this.config = g2;
        this.maxContextTtl = g2.e(ConfigProperty.MAX_TRACE_TTL);
    }

    public void newContext() {
        int n2;
        AssessmentContext assessmentContext = this.currentContext();
        if (assessmentContext != null && !assessmentContext.isJumpedContexts()) {
            assessmentContext.clear();
        }
        if (this.contextsCreated > 5) {
            n2 = (int)Math.min(this.totalMapSize / (long)this.contextsCreated, 250L);
            n2 = Math.max(n2, 20);
        } else {
            n2 = 75;
        }
        this.assessmentContext.set(new AssessmentContext(this.config, this.clock, n2));
    }

    @C
    void clearContext() {
        AssessmentContext assessmentContext = this.assessmentContext.get();
        if (assessmentContext != null) {
            assessmentContext.clear();
        }
        this.assessmentContext.set(null);
    }

    public void currentContext(AssessmentContext assessmentContext) {
        this.assessmentContext.set(assessmentContext);
    }

    public AssessmentContext currentContext() {
        AssessmentContext assessmentContext = this.assessmentContext.get();
        if (assessmentContext != null) {
            long l2 = assessmentContext.lastUpdatedMillis();
            long l3 = this.clock.a() - l2;
            if (l3 > this.maxContextTtl) {
                assessmentContext.clear();
                logger.debug("Cleared expired assessment context {} in ({}ms)", (Object)assessmentContext, (Object)l3);
                assessmentContext.refresh();
            }
        }
        return assessmentContext;
    }

    public void onContextClearing(int n2) {
        ++this.contextsCreated;
        this.totalMapSize += (long)n2;
    }
}

