/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.t.d;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;

@Singleton
@DontObfuscate
public class TraceController {
    private final EventContext eventContext;
    public static final String TRACKED_FIELD_NAME = "$$CONTRAST_TRACKED$$";
    public static final String PROVIDER_EVENT_ID = "$PROVIDER$";
    public static final String CANARY_ID = "canary";
    public static final short PROVIDER_EVENT_INDEX = -1;
    private static Field FILE_TRACKED_FIELD;
    private static Field STRING_TRACKED_FIELD;
    private static Field STRING_BUILDER_TRACKED_FIELD;
    private static Field STRING_BUFFER_TRACKED_FIELD;
    private static Field PRINT_WRITER_TRACKED_FIELD;
    private static Field BUFFERED_READER_TRACKED_FIELD;
    private static final Logger logger;

    @Inject
    public TraceController(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public int getSize() {
        Map<Object, Trace> map = this.eventContext.getTraceMap();
        return map != null ? map.size() : 0;
    }

    public boolean isTracked(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Object[]) {
            return this.isTrackedArray((Object[])object);
        }
        Map<Object, Trace> map = this.eventContext.getTraceMap();
        return map != null && map.containsKey(object);
    }

    private boolean isTrackedArray(Object[] objectArray) {
        if (objectArray == null) {
            return false;
        }
        for (Object object : objectArray) {
            if (!this.isTracked(object)) continue;
            return true;
        }
        return false;
    }

    public Trace getTrace(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return this.getTraceFromArray((Object[])object);
        }
        Map<Object, Trace> map = this.eventContext.getTraceMap();
        return map.get(object);
    }

    private Trace getTraceFromArray(Object[] objectArray) {
        if (objectArray != null) {
            Map<Object, Trace> map = this.eventContext.getTraceMap();
            if (map == null) {
                return null;
            }
            Trace trace = map.get(objectArray);
            if (trace != null) {
                return trace;
            }
            for (Object object : objectArray) {
                trace = map.get(object);
                if (trace == null) continue;
                return trace;
            }
        }
        return null;
    }

    private Field getFileField() throws NoSuchFieldException {
        if (FILE_TRACKED_FIELD == null) {
            FILE_TRACKED_FIELD = d.d(File.class, TRACKED_FIELD_NAME);
        }
        return FILE_TRACKED_FIELD;
    }

    private Field getStringField() throws NoSuchFieldException {
        if (STRING_TRACKED_FIELD == null) {
            STRING_TRACKED_FIELD = d.d(String.class, TRACKED_FIELD_NAME);
        }
        return STRING_TRACKED_FIELD;
    }

    private Field getStringBufferField() throws NoSuchFieldException {
        if (STRING_BUFFER_TRACKED_FIELD == null) {
            STRING_BUFFER_TRACKED_FIELD = d.d(StringBuffer.class, TRACKED_FIELD_NAME);
        }
        return STRING_BUFFER_TRACKED_FIELD;
    }

    private Field getStringBuilderField() throws NoSuchFieldException {
        if (STRING_BUILDER_TRACKED_FIELD == null) {
            STRING_BUILDER_TRACKED_FIELD = d.d(StringBuilder.class, TRACKED_FIELD_NAME);
        }
        return STRING_BUILDER_TRACKED_FIELD;
    }

    private Field getPrintWriterField() throws NoSuchFieldException {
        if (PRINT_WRITER_TRACKED_FIELD == null) {
            PRINT_WRITER_TRACKED_FIELD = d.d(PrintWriter.class, TRACKED_FIELD_NAME);
        }
        return PRINT_WRITER_TRACKED_FIELD;
    }

    private Field getBufferedReaderField() throws NoSuchFieldException {
        if (BUFFERED_READER_TRACKED_FIELD == null) {
            BUFFERED_READER_TRACKED_FIELD = d.d(BufferedReader.class, TRACKED_FIELD_NAME);
        }
        return BUFFERED_READER_TRACKED_FIELD;
    }

    public boolean isProviderEventIndex(short s2) {
        return -1 == s2;
    }

    static {
        logger = LoggerFactory.getLogger(TraceController.class);
    }
}

