/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.propagate;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.frameworks.V;
import com.contrastsecurity.agent.plugins.frameworks.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.propagate.h;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.a.j;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.scope.e;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.util.v;
import com.contrastsecurity.agent.w.k;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;

@Singleton
@DontObfuscate
public final class ContrastDataFlowPropagationDispatcherImpl
implements c.a,
ContrastDataFlowPropagationDispatcher {
    private ContrastPolicy.c propagators;
    private Map<Integer, Propagator> customSanitizers;
    private final h propagationMachine;
    private final e scopeProviderAssess;
    private final o frameworkManager;
    private final EventContext eventContext;
    private final TraceController traceController;
    private final AssessmentManager assessmentManager;
    private final k stackCaptureFactory;
    private final a methodDescriptionCache;
    private final j propagatorAdaptiveOptimizer;
    private final c policyManager;
    private static final Logger logger = LoggerFactory.getLogger(ContrastDataFlowPropagationDispatcherImpl.class);

    @Inject
    public ContrastDataFlowPropagationDispatcherImpl(h h2, AssessmentManager assessmentManager, e e2, o o2, EventContext eventContext, TraceController traceController, k k2, a a2, j j2, c c2) {
        this.propagationMachine = h2;
        this.scopeProviderAssess = e2;
        this.frameworkManager = o2;
        this.eventContext = eventContext;
        this.traceController = traceController;
        this.assessmentManager = assessmentManager;
        this.stackCaptureFactory = k2;
        this.methodDescriptionCache = a2;
        this.propagatorAdaptiveOptimizer = j2;
        this.policyManager = c2;
        ContrastPolicy contrastPolicy = c2.e();
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    @Override
    public void onPolicyChanged(ContrastPolicy contrastPolicy) {
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    public boolean isScopedPropagationAllowed() {
        if (!this.scopeProviderAssess.isEnabled()) {
            return false;
        }
        com.contrastsecurity.agent.scope.a a2 = this.scopeProviderAssess.scope();
        return a2.b() == 0 && a2.k() == 0 && a2.l() == 1;
    }

    public boolean isUnscopedPropagationAllowed() {
        if (!this.scopeProviderAssess.isEnabled()) {
            return false;
        }
        com.contrastsecurity.agent.scope.a a2 = this.scopeProviderAssess.scope();
        return a2.b() == 0 && a2.k() == 0;
    }

    public void enterPropagationScope() {
        com.contrastsecurity.agent.scope.a a2 = this.scopeProviderAssess.scope();
        a2.e();
    }

    public void leavePropagationScope() {
        com.contrastsecurity.agent.scope.a a2 = this.scopeProviderAssess.scope();
        a2.f();
    }

    public Object cloneReturn(Object object) {
        Object object2 = object;
        try {
            object2 = com.contrastsecurity.agent.util.clone.a.a(object);
        }
        catch (Exception exception) {
            logger.debug("Couldn't clone input for {}", object, (Object)exception);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPropagation(String string, String string2, int n2, Object object, Class<?> clazz, Object[] objectArray, Class<?>[] classArray, Object object2, Class<?> clazz2, int n3, boolean bl2, boolean bl3, int[] nArray) {
        com.contrastsecurity.agent.scope.a a2 = this.scopeProviderAssess.scope();
        try {
            a2.c();
            Propagator propagator = this.getPropagator(n3, bl2);
            Map<Object, Trace> map = this.eventContext.getTraceMap();
            if (map == null) {
                return;
            }
            if (!this.shouldPropagate(propagator, clazz, object, objectArray, nArray, clazz2, object2)) {
                return;
            }
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null && assessmentContext.hasReachedMaximumPropagationEvents()) {
                if (propagator.loggedMaximumEvents()) {
                    logger.debug("Ignoring propagator {} because maximum reached", (Object)propagator.getId());
                } else {
                    logger.warn("Ignoring propagator {} because maximum reached, consider increasing maximum events via the `assess.max_propagation_events` property. Further events will be logged at the `DEBUG` level", (Object)propagator.getId());
                }
                return;
            }
            MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, clazz.getName(), string, string2, n2);
            com.contrastsecurity.agent.plugins.security.model.h h2 = new com.contrastsecurity.agent.plugins.security.model.h();
            h2.a(object);
            h2.a(objectArray);
            h2.b(object2);
            h2.a(methodDescription);
            h2.a(propagator);
            h2.a(clazz);
            h2.b(clazz2);
            h2.a(bl3);
            h2.a(map);
            h2.b(System.currentTimeMillis());
            h2.a(this.stackCaptureFactory.a());
            for (V v2 : this.frameworkManager.i()) {
                if (v2.a(h2)) continue;
                return;
            }
            this.doPropagation(h2);
            this.propagatorAdaptiveOptimizer.a(this.policyManager, h2);
            if (assessmentContext != null) {
                assessmentContext.onPropagationRecorded();
            }
            for (V v2 : this.frameworkManager.i()) {
                v2.b(h2);
            }
        }
        catch (InvalidTagRangeException invalidTagRangeException) {
            logger.debug("Invalid tag range exception", invalidTagRangeException);
        }
        catch (Throwable throwable) {
            logger.error("WARNING: Unexpected exception:", throwable);
        }
        finally {
            a2.d();
        }
    }

    private Propagator getPropagator(int n2, boolean bl2) throws Exception {
        Propagator propagator;
        if (bl2 && logger.isDebugEnabled()) {
            logger.debug("custom sanitizer propagator index detected {} ({} total standard propagators)", (Object)n2, (Object)this.propagators.b());
        }
        Propagator propagator2 = propagator = bl2 ? this.customSanitizers.get(n2) : this.propagators.a(n2);
        if (propagator == null) {
            throw new Exception("Unable to find valid propagator at index " + n2);
        }
        return propagator;
    }

    private boolean shouldPropagate(Propagator propagator, Class<?> clazz, Object object, Object[] objectArray, int[] nArray, Class<?> clazz2, Object object2) {
        boolean bl2 = this.verifySourcePropagation(propagator, clazz, object, objectArray);
        bl2 = bl2 && this.verifyTargetPropagation(propagator, clazz, object, clazz2, object2);
        return bl2;
    }

    private boolean verifySourcePropagation(Propagator propagator, Class<?> clazz, Object object, Object[] objectArray) {
        m[] mArray = propagator.getSources();
        m[] mArray2 = propagator.getTargets();
        boolean bl2 = false;
        if (mArray != null && mArray2 != null) {
            if (mArray.length == 1 && mArray2.length == 1) {
                m m2 = mArray[0];
                m m3 = mArray2[0];
                bl2 = m2.a() && m3.a() ? clazz != String.class && this.traceController.isTracked(object) : true;
            } else {
                for (int i2 = 0; i2 < mArray.length && !bl2; ++i2) {
                    m m4 = mArray[i2];
                    if (m4.a()) {
                        bl2 = this.traceController.isTracked(object);
                        continue;
                    }
                    if (objectArray == null) continue;
                    if (m4.d()) {
                        int n2 = m4.g();
                        if (n2 >= objectArray.length) continue;
                        bl2 = this.traceController.isTracked(objectArray[n2]);
                        continue;
                    }
                    if (!m4.c()) continue;
                    String string = m4.j();
                    for (int i3 = 0; !bl2 && i3 < objectArray.length; ++i3) {
                        if (objectArray[i3] == null || !v.a(objectArray[i3], string)) continue;
                        bl2 = this.traceController.isTracked(objectArray[i3]);
                    }
                }
            }
        }
        return bl2;
    }

    private boolean verifyTargetPropagation(Propagator propagator, Class<?> clazz, Object object, Class<?> clazz2, Object object2) {
        m[] mArray = propagator.getTargets();
        boolean bl2 = false;
        Object object3 = null;
        Class<?> clazz3 = null;
        if (mArray != null) {
            for (int i2 = 0; i2 < mArray.length && !bl2; ++i2) {
                m m2 = mArray[i2];
                if (m2.a()) {
                    object3 = object;
                    clazz3 = clazz;
                } else if (m2.b()) {
                    object3 = object2;
                    clazz3 = clazz2;
                } else {
                    bl2 = true;
                }
                if (bl2) continue;
                bl2 = object3 != null;
                bl2 = bl2 && (clazz3 != String.class || !this.traceController.isTracked(object3));
            }
        }
        return bl2;
    }

    private void doPropagation(com.contrastsecurity.agent.plugins.security.model.h h2) throws InvalidTagRangeException {
        Propagator propagator = h2.e();
        boolean bl2 = h2.i();
        Map<Object, Trace> map = h2.k();
        m[] mArray = propagator.getSources();
        m[] mArray2 = propagator.getTargets();
        if (mArray != null && mArray2 != null) {
            boolean bl3;
            m m2;
            int n2;
            int n3 = -1;
            for (n2 = 0; n2 < mArray.length; ++n2) {
                m2 = mArray[n2];
                if (m2.a() && this.traceController.isTracked(h2.b())) {
                    n3 = n2;
                    continue;
                }
                if (!m2.c() || (bl3 = m2.g()) || !this.traceController.isTracked(h2.c()[bl3])) continue;
                n3 = n2;
            }
            for (n2 = 0; n2 < mArray.length; ++n2) {
                m2 = mArray[n2];
                bl3 = n2 == mArray.length - 1;
                bl3 = bl3 || n2 == n3;
                bl3 = bl3 || m2.c() && propagator.getCountOfArgSources() > 1;
                Object object = this.getObjectFromContextAtLocation(h2, m2);
                for (m m3 : mArray2) {
                    Object object2 = this.getObjectFromContextAtLocation(h2, m3);
                    if (object == null || object2 == null) continue;
                    if (m2.a() && m3.a()) {
                        this.propagationMachine.a(object, h2);
                        continue;
                    }
                    this.propagationMachine.a(object, object2, h2, bl2, map, bl3);
                }
            }
        }
    }

    private Object getObjectFromContextAtLocation(com.contrastsecurity.agent.plugins.security.model.h h2, m m2) {
        Object object = h2.b();
        Object object2 = h2.d();
        Object[] objectArray = h2.c();
        Object object3 = null;
        if (m2.a()) {
            object3 = object;
        } else if (m2.d()) {
            int n2 = m2.g();
            object3 = n2 < objectArray.length ? objectArray[n2] : null;
        } else if (m2.f()) {
            for (int i2 = 0; object3 == null && i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || !v.a(objectArray[i2], m2.i())) continue;
                object3 = objectArray[i2];
            }
        } else if (m2.b()) {
            object3 = object2;
        }
        return object3;
    }
}

