/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.track;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.InheritancePreference;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.r;
import com.contrastsecurity.agent.plugins.security.policy.s;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.plugins.security.policy.w;
import com.contrastsecurity.agent.scope.e;
import com.contrastsecurity.agent.t.d;
import com.contrastsecurity.agent.telemetry.errors.m;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.V;
import com.contrastsecurity.agent.x;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@DontObfuscate
public final class ContrastDynamicSourceDispatcherImpl
implements ContrastDynamicSourceDispatcher {
    private final Map<String, Integer> dynamicSourcesAlreadyHit = new ConcurrentHashMap<String, Integer>();
    private final TraceController traceController;
    private static int dynamicSourceIdCtr = 1;
    private final ContrastEngine contrastEngine;
    private final e scopeProviderAssess;
    private final ApplicationManager applicationManager;
    private final m errorEmitter;
    private final c policyManager;
    private static final String PROBLEM_INSPECTING_DYNAMIC_SOURCE_TYPE = "problemInspectingDynamicSourceType";
    private static final Logger logger = LoggerFactory.getLogger(ContrastDynamicSourceDispatcherImpl.class);

    @Inject
    public ContrastDynamicSourceDispatcherImpl(TraceController traceController, ContrastEngine contrastEngine, e e2, ApplicationManager applicationManager, m m2, c c2) {
        this.traceController = traceController;
        this.contrastEngine = contrastEngine;
        this.scopeProviderAssess = e2;
        this.applicationManager = applicationManager;
        this.errorEmitter = m2;
        this.policyManager = c2;
    }

    private void onDynamicSourceHit(String string, Class<?> clazz, String string2, Set<String> set) {
        boolean bl2;
        if (clazz == null) {
            logger.debug("Attempted to apply a dynamic source to a null class");
            return;
        }
        if (clazz.isInterface()) {
            logger.debug("The class {} is not appropriate for re-transformation - it's an interface", (Object)clazz.getName());
            return;
        }
        if (!this.contrastEngine.getInstrumentation().isModifiableClass(clazz)) {
            logger.debug("The class {} is not modifiable", (Object)clazz.getName());
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.e();
        if (contrastPolicy.getDynamicSource(string) == null) {
            logger.debug("Couldn't find dynamic source for policy: {}", (Object)string);
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        String string3 = ContrastDynamicSourceDispatcherImpl.getMethodSignature(application, clazz, string2);
        if (string2.startsWith("set") && string2.length() > 3) {
            string2 = "get" + string2.substring(3);
        }
        if (!(bl2 = this.dynamicSourcesAlreadyHit.containsKey(string3))) {
            this.dynamicSourcesAlreadyHit.put(string3, 1);
            Class<?> clazz2 = this.tryReadType(clazz, string2);
            if (!this.isAllowedTaintType(clazz2)) {
                return;
            }
            logger.debug("First time seeing new dynamic source for method {}. Adding to policy.", (Object)string3);
            String string4 = string + dynamicSourceIdCtr++;
            r r2 = new r(clazz.getName(), string2, Empty.STRING_ARRAY);
            String[] stringArray = set != null ? set.toArray(Empty.STRING_ARRAY) : Empty.STRING_ARRAY;
            u u2 = new u(contrastPolicy.getId(), contrastPolicy.getLocation(), string4, com.contrastsecurity.agent.plugins.security.policy.m.n, new s(r2), stringArray);
            u2.setInheritancePreference(InheritancePreference.NONE);
            u2.setScoped(true);
            u2.addSourceType(w.i);
            u2.setDeep(false);
            this.policyManager.b(u2);
            V.a(this.contrastEngine.getInstrumentation(), this.errorEmitter, clazz);
        } else {
            logger.trace("Already seen the dynamic source {}. Ignoring.", (Object)string3);
        }
    }

    private boolean isAllowedTaintType(Class<?> clazz) {
        return String.class.equals(clazz) || Empty.STRING_ARRAY.getClass().equals(clazz);
    }

    private Class<?> tryReadType(Class<?> clazz, String string) {
        Class<?> clazz2 = null;
        try {
            Method method = d.a(clazz, string, Empty.CLASS_ARRAY);
            clazz2 = method != null ? method.getReturnType() : null;
        }
        catch (Throwable throwable) {
            a.b(PROBLEM_INSPECTING_DYNAMIC_SOURCE_TYPE, logger, "Problem inspecting class for dynamic source", throwable);
        }
        return clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDynamicSourceMethodCall(String string, Object object, Class<?> clazz, Object[] objectArray, Class<?>[] classArray, Class<?> clazz2, String string2) {
        com.contrastsecurity.agent.scope.a a2 = this.scopeProviderAssess.enterScope();
        try {
            if (objectArray.length == 1 && this.traceController.isTracked(objectArray[0])) {
                Trace trace;
                if (logger.isDebugEnabled()) {
                    logger.debug("DETECTED and EXECUTING dynamic source call from {}.{}()", (Object)clazz.getName(), (Object)string);
                }
                Set<String> set = (trace = this.traceController.getTrace(objectArray[0])) != null ? trace.getTags() : null;
                this.onDynamicSourceHit(string2, clazz, string, set);
            } else if (logger.isTraceEnabled()) {
                logger.trace("DETECTED and IGNORING dynamic source call from {}.{}()", (Object)clazz.getName(), (Object)string);
            }
        }
        catch (Throwable throwable) {
            logger.error("Unexpected exception:", throwable);
        }
        finally {
            a2.d();
        }
    }

    private static String getMethodSignature(Application application, Class<?> clazz, String string) {
        return application.getContextPath() + ':' + clazz.getName() + ':' + x.b(clazz) + ':' + string;
    }
}

