/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.trigger;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.k;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.g.c;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.r;
import com.contrastsecurity.agent.plugins.security.controller.trigger.o;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.d;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.plugins.security.policy.w;
import com.contrastsecurity.agent.plugins.security.t;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Set;

@DontObfuscate
public final class QueueFindingListener
implements o {
    private final HttpManager httpManager;
    private final Finding.d findingFactory;
    private final g config;
    private final d findingTestCache;
    private final com.contrastsecurity.agent.services.ngreporting.g legacyReportingService;
    private final t.c cryptographicHasher;
    private final t.d dataflowHasher;
    private static final String INVALID_DATA_FLOW_ERROR = "dataflow.invalid.notenough";
    private static final String RULE_HASH_CHANNEL = "assess.rule-and-hash";
    private static final Logger logger = LoggerFactory.getLogger(QueueFindingListener.class);

    public QueueFindingListener(HttpManager httpManager, g g2, Finding.d d2, d d3, com.contrastsecurity.agent.services.ngreporting.g g3, t t2) {
        this.httpManager = httpManager;
        this.findingFactory = d2;
        this.config = g2;
        this.findingTestCache = d3;
        this.legacyReportingService = g3;
        this.cryptographicHasher = t2.c();
        this.dataflowHasher = t2.e();
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, r r2) {
        Set<String> set;
        String string;
        String string2 = rule.getId();
        if (this.shouldUpdateIdToStoredXSS(string2, trace)) {
            string2 = "stored-xss";
        }
        if (StringUtils.isNotEmpty(string = this.config.b(ConfigProperty.ASSESS_DISABLED_RULES)) && (set = P.e(string, ",")).contains(string2)) {
            logger.debug("Suppressed trace {} in {} for the disabled rule {}", trace.getId(), application, string2);
            return false;
        }
        if (this.isInvalidDataFlow(rule, trace)) {
            a.a(INVALID_DATA_FLOW_ERROR, logger, "Not enough data flow events for trace {}", null, new Object[]{c.a(logger, String.valueOf(trace))});
            logger.debug("Suppressed trace {} w/o enough events {}", (Object)trace.getId(), (Object)trace);
            return false;
        }
        long l2 = "crypto-bad-ciphers".equals(string2) || "crypto-bad-mac".equals(string2) ? this.cryptographicHasher.a(rule.getId(), this.httpManager.getCurrentRequest(), objectArray.length == 0 ? QueueFindingListener.getCryptoHashArgument(trace) : (String)objectArray[0]) : this.dataflowHasher.a(rule.getId(), this.httpManager.getCurrentRequest(), trace);
        Finding finding = this.findingFactory.a(application, string2, trace, l2);
        HttpRequest httpRequest = this.httpManager.cloneCurrentRequest();
        finding.setRequest(httpRequest);
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string2, (Object)finding.getHash());
        this.broadcastToLegacyChannel(string2, finding);
        this.legacyReportingService.a(finding);
        if (this.findingTestCache.e()) {
            try {
                if (finding.hasEvents()) {
                    this.findingTestCache.a(string2, finding.getHash());
                }
            }
            catch (Exception exception) {
                logger.debug("Error encountered handling finding", exception);
            }
        }
        return true;
    }

    private static String getCryptoHashArgument(Trace trace) {
        if (trace == null) {
            return "";
        }
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent == null) {
            return "";
        }
        MethodDescription methodDescription = codeEvent.getMethod();
        if (methodDescription == null) {
            return "";
        }
        String string = methodDescription.getSignature();
        return string == null ? "" : string;
    }

    private void broadcastToLegacyChannel(String string, Finding finding) {
        AgentChannelHub agentChannelHub = AgentChannelHub.getOrNull(this.config);
        if (agentChannelHub == null) {
            return;
        }
        if (agentChannelHub.hasSubscribers(RULE_HASH_CHANNEL)) {
            agentChannelHub.broadcast(RULE_HASH_CHANNEL, k.a().a(string, finding.getHash()).a());
        }
    }

    private boolean isInvalidDataFlow(Rule rule, Trace trace) {
        if (rule.requiresDataFlow() && trace != null) {
            List<CodeEvent> list = trace.getEvents();
            return list != null && list.size() <= 1;
        }
        return false;
    }

    private boolean shouldUpdateIdToStoredXSS(String string, Trace trace) {
        List<CodeEvent> list;
        if ("reflected-xss".equals(string) && trace != null && (list = trace.getEvents()) != null && !list.isEmpty()) {
            for (CodeEvent codeEvent : list) {
                u u2;
                if (!(codeEvent instanceof SourceEvent) || (u2 = ((SourceEvent)codeEvent).getSource()) == null || !u2.hasSourceTypes() || !u2.isSourceType(w.i) && !u2.isSourceType(w.b)) continue;
                return true;
            }
        }
        return false;
    }
}

