/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.security.controller.SortedDisallowedTags;
import com.contrastsecurity.agent.plugins.security.controller.l;
import com.contrastsecurity.agent.plugins.security.policy.PolicyNode;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.EventPattern;
import com.contrastsecurity.agent.plugins.security.policy.rules.Parameter;
import com.contrastsecurity.agent.plugins.security.policy.rules.ParameterList;
import com.contrastsecurity.agent.services.ngreporting.ConfidenceLevel;
import com.contrastsecurity.agent.trace.Trace;
import java.util.List;
import java.util.Objects;

@DontObfuscate
public class Rule
extends PolicyNode {
    boolean enabled = true;
    boolean unique;
    boolean observable;
    List<String> hashComponents;
    String id;
    String name;
    String category;
    ConfidenceLevel level;
    SortedDisallowedTags disallowedTags = new SortedDisallowedTags();
    EventPattern pattern;

    public Rule(int n2) {
        super(n2);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        Objects.requireNonNull(string, () -> "Rule ID cannot be null parameter cannot be null");
        this.id = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public ConfidenceLevel getLevel() {
        return this.level;
    }

    public void setLevel(ConfidenceLevel confidenceLevel) {
        this.level = confidenceLevel;
    }

    public SortedDisallowedTags getDisallowedTags() {
        return this.disallowedTags;
    }

    public void setDisallowedTags(SortedDisallowedTags sortedDisallowedTags) {
        this.disallowedTags = sortedDisallowedTags;
    }

    public void setDisallowedTags(String[] stringArray) {
        this.disallowedTags = new SortedDisallowedTags(stringArray);
    }

    public EventPattern getEventPattern() {
        return this.pattern;
    }

    public void setEventPattern(EventPattern eventPattern) {
        this.pattern = eventPattern;
    }

    public boolean eventsCompleteRule(Trace trace) {
        if (!this.enabled) {
            return false;
        }
        return l.a(this, trace);
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setUnique(boolean bl2) {
        this.unique = bl2;
    }

    public void setObservable(boolean bl2) {
        this.observable = bl2;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public List<String> getHashComponents() {
        return this.hashComponents;
    }

    public void setHashComponents(List<String> list) {
        this.hashComponents = list;
    }

    public boolean requiresDataFlow() {
        Event[] eventArray;
        if (this.pattern != null && (eventArray = this.pattern.getEvents()) != null) {
            for (Event event : eventArray) {
                Parameter[] parameterArray;
                String[] stringArray = event.getRequiredObjectTags();
                if (stringArray != null && stringArray.length > 0) {
                    return true;
                }
                ParameterList parameterList = event.getParameterList();
                if (parameterList == null || (parameterArray = parameterList.getParameters()) == null) continue;
                for (Parameter parameter : parameterArray) {
                    if (!parameter.requiresTracking()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public n getMethodMatcher() {
        throw new UnsupportedOperationException("rule parent nodes have no matching mechanism");
    }

    @Override
    public boolean isSignatureBased() {
        return false;
    }

    @Override
    protected String getTypeLabel() {
        return "rule";
    }
}

