/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.d;
import com.contrastsecurity.agent.services.ngreporting.r;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.TraceEvent;
import com.contrastsecurity.agent.trace.e;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.Set;

@Singleton
@DontObfuscate
public class ProviderUtil {
    private final g config;
    private final com.contrastsecurity.agent.services.ngreporting.g legacyReportingService;
    private final Finding.d findingFactory;
    private final e traceFactory;
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final c policyManager;
    private final d telemetryCache;
    private static final Logger logger = LoggerFactory.getLogger(ProviderUtil.class);

    @Inject
    public ProviderUtil(g g2, ApplicationManager applicationManager, Finding.d d2, d d3, HttpManager httpManager, com.contrastsecurity.agent.services.ngreporting.g g3, e e2, c c2) {
        this.applicationManager = applicationManager;
        this.policyManager = c2;
        this.config = g2;
        this.findingFactory = d2;
        this.httpManager = httpManager;
        this.legacyReportingService = g3;
        this.telemetryCache = d3;
        this.traceFactory = e2;
    }

    public void reportFinding(String string, String string2, long l2) {
        this.reportFinding(string, string2, l2, null, true, null);
    }

    public void reportFinding(String string, Map<PropertyKey, String> map, long l2) {
        this.reportFinding(string, null, l2, map, true, null);
    }

    public void reportFinding(String string, String string2, long l2, Map<PropertyKey, String> map) {
        this.reportFinding(string, string2, l2, map, true, null);
    }

    public void reportFinding(String string, Map<PropertyKey, String> map, long l2, boolean bl2) {
        this.reportFinding(string, null, l2, map, bl2, null);
    }

    public void reportFinding(String string, String string2, long l2, Map<PropertyKey, String> map, boolean bl2, r r2) {
        Application application = this.applicationManager.current();
        this.reportFinding(application, string, string2, l2, map, bl2, r2);
    }

    public void reportFinding(Application application, String string, String string2, long l2, Map<PropertyKey, String> map, boolean bl2, r r2) {
        if (application == null) {
            logger.debug("Unable to send report, app == NULL");
            return;
        }
        String string3 = this.config.b(ConfigProperty.ASSESS_DISABLED_RULES);
        Set<String> set = P.e(string3, ",");
        if (set.contains(string)) {
            logger.debug("Suppressed finding in {} for the disabled rule {}", (Object)application, (Object)string);
            return;
        }
        Trace trace = this.traceFactory.a();
        trace.setEvidence(string2);
        trace.setRuleId(string);
        ContrastPolicy contrastPolicy = this.policyManager.e();
        if (contrastPolicy == null) {
            return;
        }
        Rule rule = contrastPolicy.getRuleById(string);
        if (rule == null) {
            return;
        }
        Finding finding = this.findingFactory.a(application, string, trace, l2);
        if (bl2) {
            finding.setRequest(this.httpManager.cloneCurrentRequest());
        }
        finding.setProperties(map);
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string, (Object)l2);
        TraceEvent traceEvent = new TraceEvent(trace);
        if (this.telemetryCache.e()) {
            this.telemetryCache.a(string, l2);
        }
        finding.setListener(r2);
        this.legacyReportingService.a(finding);
    }
}

