/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.socketfactory;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.model.f;
import com.contrastsecurity.agent.plugins.security.model.n;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.d;
import com.contrastsecurity.agent.plugins.security.t;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.trace.e;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.agent.util.v;
import com.contrastsecurity.agent.w.j;
import com.contrastsecurity.agent.w.k;
import com.contrastsecurity.agent.x;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.Socket;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

@Singleton
@DontObfuscate
public final class ContrastSocketFactoryDispatcherImpl
implements ContrastSocketFactoryDispatcher {
    private final ApplicationManager applicationManager;
    private final g config;
    private final AssessmentManager assessmentManager;
    private final HttpManager httpManager;
    private final d findingTestCache;
    private final e traceFactory;
    private final com.contrastsecurity.agent.plugins.security.model.c codeEventFactory;
    private final Finding.d findingFactory;
    private final k stackCaptureFactory;
    private final com.contrastsecurity.agent.services.ngreporting.g legacyReportingService;
    private final a methodDescriptionCache;
    private final t.h triggerHasher;
    private final c policyManager;
    private static final boolean IS_SUSCEPTIBLE = ContrastSocketFactoryDispatcherImpl.isSusceptibleJavaVersion();
    private static final String MASQUERADE_NAME = "insecure-socket-factory";
    public static final String RULE_NAME = "insecure-socket-factory";
    private static final String DEFAULT_SOCKET_FACTORY_PROPERTY = "ssl.SocketFactory.provider";
    private static final Logger logger = LoggerFactory.getLogger(ContrastSocketFactoryDispatcherImpl.class);

    @Inject
    public ContrastSocketFactoryDispatcherImpl(ApplicationManager applicationManager, AssessmentManager assessmentManager, g g2, HttpManager httpManager, d d2, e e2, com.contrastsecurity.agent.plugins.security.model.c c2, Finding.d d3, k k2, com.contrastsecurity.agent.services.ngreporting.g g3, a a2, t t2, c c3) {
        this.applicationManager = applicationManager;
        this.assessmentManager = assessmentManager;
        this.config = g2;
        this.httpManager = httpManager;
        this.findingTestCache = d2;
        this.traceFactory = e2;
        this.codeEventFactory = c2;
        this.findingFactory = d3;
        this.stackCaptureFactory = k2;
        this.legacyReportingService = g3;
        this.methodDescriptionCache = a2;
        this.triggerHasher = t2.d();
        this.policyManager = c3;
    }

    @ScopedSensor
    public void trackSocketCreate(Object object, Object object2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        ContrastSocketFactoryDispatcherImpl contrastSocketFactoryDispatcherImpl = this;
        Object object3 = object;
        Object object4 = object2;
        try {
            try {
                if (contrastSocketFactoryDispatcherImpl.isDefaultSocketFactory() && IS_SUSCEPTIBLE) {
                    contrastSocketFactoryDispatcherImpl.reportInsecureSocket((SSLSocketFactory)object3, (Socket)object4, contrastSocketFactoryDispatcherImpl.findingFactory);
                }
            }
            catch (Throwable throwable) {
                logger.error("Problem checking insecure-socket-factory trigger during socket creation", throwable);
            }
            contrastSocketFactoryDispatcherImpl = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (contrastSocketFactoryDispatcherImpl != null) {
            throw contrastSocketFactoryDispatcherImpl;
        }
    }

    private boolean isDefaultSocketFactory() {
        return x.b(DEFAULT_SOCKET_FACTORY_PROPERTY) == null;
    }

    private void reportInsecureSocket(SSLSocketFactory sSLSocketFactory, Socket socket, Finding.d d2) {
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        String string = this.config.b(ConfigProperty.ASSESS_DISABLED_RULES);
        Set<String> set = P.e(string, ",");
        if (set.contains("insecure-socket-factory")) {
            logger.debug("Suppressed socket connection report in {} for the disabled rule {}", (Object)application, (Object)"insecure-socket-factory");
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.e();
        Rule rule = contrastPolicy.getRuleById("insecure-socket-factory");
        if (rule == null || !rule.isEnabled()) {
            return;
        }
        j j2 = this.stackCaptureFactory.a();
        StackTraceElement stackTraceElement = j2.a().get(0);
        MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), "()Ljava/net/Socket;", 0);
        TriggerEvent triggerEvent = ((n)((n)((n)((n)((n)this.codeEventFactory.b().a(methodDescription)).a(rule).e("O")).a(sSLSocketFactory)).b(socket)).a(j2)).g();
        try {
            AssessmentContext assessmentContext;
            Trace trace = this.traceFactory.a();
            trace.addEvent(triggerEvent);
            trace.setRuleId("insecure-socket-factory");
            long l2 = this.triggerHasher.a("insecure-socket-factory", this.httpManager.getCurrentRequest());
            Finding finding = d2.a(application, "insecure-socket-factory", trace, l2);
            HttpRequest httpRequest = this.httpManager.cloneCurrentRequest();
            if (httpRequest != null) {
                finding.setRequest(httpRequest);
            }
            logger.info("Added finding for rule ID: insecure-socket-factory");
            if (this.findingTestCache.e()) {
                this.findingTestCache.a("insecure-socket-factory", finding.getHash());
            }
            if ((assessmentContext = this.assessmentManager.currentContext()) != null) {
                assessmentContext.setLastTriggerEvent(triggerEvent);
            }
            this.legacyReportingService.a(finding);
        }
        catch (f f2) {
            logger.info("Duplicate event detected for rule ID: insecure-socket-factory");
        }
    }

    private static boolean isSusceptibleJavaVersion() {
        String string = v.k();
        return string == null || string.contains("1.6");
    }
}

