/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.xss;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.r;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.model.n;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.j;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Parameter;
import com.contrastsecurity.agent.plugins.security.policy.rules.ParameterList;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.a;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.t.d;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.w.k;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Singleton
@DontObfuscate
final class ContrastFreemarkerDispatcherImpl
implements ContrastFreemarkerDispatcher {
    private final TraceController traceController;
    private final ApplicationManager applicationManager;
    private final AssessmentManager assessmentManager;
    private final com.contrastsecurity.agent.plugins.security.model.c codeEventFactory;
    private final ContrastDataFlowTriggerDispatcher triggerDispatcher;
    private final k stackCaptureFactory;
    private final c policyManager;
    private static Event RULE_EVENT;
    private static final String FAKE_TEMPLATENAME = "unknown.ftl";
    private static final String FAKE_SINK_CLASSNAME = "freemarker.core.Renderer";
    private static final String FAKE_SINK_FILENAME = "Renderer.java";
    private static final String FAKE_SINK_METHOD_NAME = "output";
    private static final String FAKE_TEMPLATE_METHOD_NAME = "print";
    private static final String FAKE_METHOD_DESC = "(Ljava/lang/String;)V";
    private static final MethodDescription CALLEE;
    private static final int FAKE_SINK_LINE = 10;
    private static final String RULE_NAME = "reflected-xss";
    private static final Logger logger;

    @Inject
    public ContrastFreemarkerDispatcherImpl(TraceController traceController, ApplicationManager applicationManager, AssessmentManager assessmentManager, com.contrastsecurity.agent.plugins.security.model.c c2, ContrastDataFlowTriggerDispatcher contrastDataFlowTriggerDispatcher, k k2, c c3) {
        this.traceController = traceController;
        this.applicationManager = applicationManager;
        this.assessmentManager = assessmentManager;
        this.codeEventFactory = Objects.requireNonNull(c2);
        this.triggerDispatcher = contrastDataFlowTriggerDispatcher;
        this.stackCaptureFactory = k2;
        this.policyManager = c3;
    }

    @ScopedSensor
    public void onVariableOutput(String string, Object object, Object object2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        ContrastFreemarkerDispatcherImpl contrastFreemarkerDispatcherImpl = this;
        String string2 = string;
        Object object3 = object;
        Object object4 = object2;
        try {
            try {
                contrastFreemarkerDispatcherImpl._onVariableOutput(string2, object3, object4);
            }
            catch (Exception exception) {
                logger.error("Problem checking for XSS in freemarker", exception);
            }
            contrastFreemarkerDispatcherImpl = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (contrastFreemarkerDispatcherImpl != null) {
            throw contrastFreemarkerDispatcherImpl;
        }
    }

    private void _onVariableOutput(String string, Object object, Object object2) {
        if (string != null && string.length() != 0 && object != null && object2 != null && this.traceController.isTracked(string)) {
            logger.debug("TraceDispatcher.isTracked returned true");
            try {
                Object object3 = this.getNonEscapingExpression(object);
                if (object3 != null) {
                    logger.debug("Expression not null");
                    this.reportXSS(string, object, object3, object2);
                }
            }
            catch (Exception exception) {
                logger.error("Problem checking for freemarker XSS", exception);
            }
        }
    }

    private Object getNonEscapingExpression(Object object) throws Exception {
        boolean bl2 = false;
        Field field = d.b(object, "escapedExpression");
        Object object2 = field.get(object);
        if (object2 != null) {
            Class<?> clazz = object2.getClass();
            String string = object2.toString();
            bl2 = string.contains("?url") || string.contains("?xhtml") || string.contains("?html") || string.contains("?xml") || string.contains("?json_string") || clazz.getName().contains("Encoding");
        }
        return bl2 ? null : object2;
    }

    private void reportXSS(String string, Object object, Object object2, Object object3) throws j {
        Trace trace = this.traceController.getTrace(string);
        if (trace == null) {
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.e();
        Rule rule = contrastPolicy.getRuleById(RULE_NAME);
        if (rule == null || !rule.isEnabled()) {
            return;
        }
        List<StackTraceElement> list = this.createStack(this.stackCaptureFactory.a(), object, object3);
        com.contrastsecurity.agent.w.j j2 = com.contrastsecurity.agent.w.n.a(list);
        n n2 = (n)((n)((n)((n)((n)this.codeEventFactory.b().a(CALLEE)).a(rule).e("P0")).a(new Object[]{string})).a(object)).a(j2);
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent != null) {
            n2.d(codeEvent);
        }
        TriggerEvent triggerEvent = n2.g();
        r r2 = new r();
        r2.a(true);
        r2.a(trace);
        r2.a(j2);
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        assessmentContext.setLastTriggerEvent(triggerEvent);
        a a2 = new a();
        a2.a(CALLEE);
        a2.a(triggerEvent);
        a2.a(r2);
        a2.a(this.makeEvent(rule, CALLEE));
        logger.debug("Tracing trigger");
        this.triggerDispatcher.traceTrigger(FAKE_TEMPLATE_METHOD_NAME, FAKE_METHOD_DESC, 1, object3, object3.getClass(), new Object[]{string}, (Class[])ObjectShare.SINGLE_STRING_ARRAY, null, Void.TYPE, RULE_NAME, (short)-1, (Object)a2);
    }

    private Event makeEvent(Rule rule, MethodDescription methodDescription) throws j {
        if (RULE_EVENT == null) {
            RULE_EVENT = new Event(rule, methodDescription.getSignature());
            RULE_EVENT.setExpressionType(null);
            RULE_EVENT.setObjectRequiresTracking(false);
            ParameterList parameterList = new ParameterList();
            parameterList.setMode(ParameterList.Mode.Or);
            parameterList.setParameters(new Parameter[]{this.makeFreemarkerParameter()});
            RULE_EVENT.setParameterList(parameterList);
        }
        return RULE_EVENT;
    }

    private Parameter makeFreemarkerParameter() {
        Parameter parameter = new Parameter(0, true);
        parameter.setDisallowedTags(new String[]{"http-token-limited-chars", "numeric-limited-chars", "custom-validated", "base64-encoded", "css-encoded", "ftl-encoded", "html-encoded", "js-encoded", "json-encoded", "ldap-encoded", "os-encoded", "sql-encoded", "url-encoded", "vbscript-encoded", "xml-encoded", "xpath-encoded", "xss-encoded"});
        return parameter;
    }

    private List<StackTraceElement> createStack(com.contrastsecurity.agent.w.j j2, Object object, Object object2) {
        int n2 = this.reflectLineNumber(object);
        String string = this.reflectTemplateName(object2);
        String string2 = this.generateTemplateClassName(string);
        List<Object> list = j2 == null ? Collections.emptyList() : j2.a();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(list.size() + 2);
        arrayList.add(new StackTraceElement(FAKE_SINK_CLASSNAME, FAKE_SINK_METHOD_NAME, FAKE_SINK_FILENAME, 10));
        arrayList.add(new StackTraceElement(string2, FAKE_TEMPLATE_METHOD_NAME, string, n2));
        arrayList.addAll(list);
        return arrayList;
    }

    private String generateTemplateClassName(String string) {
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        return string.substring(n2 + 1);
    }

    private String reflectTemplateName(Object object) {
        String string = FAKE_TEMPLATENAME;
        try {
            Class<?> clazz = object.getClass();
            Method method = d.f(clazz, "getTemplate");
            Object object2 = method.invoke(object, Empty.OBJ_ARRAY);
            Method method2 = d.f(object2.getClass(), "getName");
            string = (String)method2.invoke(object2, Empty.OBJ_ARRAY);
            if (string == null) {
                string = FAKE_TEMPLATENAME;
            }
        }
        catch (Exception exception) {
            logger.error("Problem reading template name", exception);
        }
        return string;
    }

    private int reflectLineNumber(Object object) {
        Class<?> clazz = object.getClass();
        int n2 = -1;
        try {
            while ((clazz = clazz.getSuperclass()) != null) {
                if (!clazz.getSimpleName().equals("TemplateObject")) continue;
                Field field = d.d(clazz, "beginLine");
                n2 = (Integer)field.get(object);
            }
        }
        catch (Exception exception) {
            logger.error("Problem generating line number", exception);
        }
        return n2;
    }

    static {
        CALLEE = new MethodDescription(FAKE_SINK_CLASSNAME, FAKE_TEMPLATE_METHOD_NAME, FAKE_METHOD_DESC, 0);
        logger = LoggerFactory.getLogger(ContrastFreemarkerDispatcherImpl.class);
    }
}

