/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.k;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSignatureDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTagTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.ObjectDTM;
import com.contrastsecurity.agent.messages.finding.trace.ParentObjectIdDTM;
import com.contrastsecurity.agent.messages.finding.trace.StackDTM;
import com.contrastsecurity.agent.services.ngreporting.n;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.w.j;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.binary.Base64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
public class CodeEvent {
    protected final EventTypeDTM eventTypeDTM;
    protected final EventActionDTM eventActionDTM;
    protected final long id;
    protected final Set<Long> parentIds;
    protected j stack;
    protected TagRanges tagRanges;
    protected final TagRanges displayTagRanges;
    protected final char[] objString;
    protected final char[][] parameterStrings;
    protected final char[] retString;
    protected final boolean objTracked;
    protected final boolean[] parameterTracked;
    protected final boolean retTracked;
    protected final int objHash;
    protected final int[] parameterHash;
    protected final int retHash;
    protected final char[] objId;
    protected final char[][] parameterIds;
    protected final char[] retId;
    protected final long timestamp;
    protected final String threadDesc;
    protected final MethodDescription method;
    protected final String sourceType;
    protected final String targetType;
    protected static final String TRACE_NEWLINE_INDENT = "\n\t\t\t\t\t\t\t";
    private static final int SHORT_STRING_MAX_TRACE_SIZE = 15;

    protected CodeEvent(a a2) {
        this.id = a2.e();
        this.parentIds = a2.f();
        this.timestamp = a2.g();
        this.threadDesc = a2.h();
        this.method = Objects.requireNonNull(a2.i());
        this.eventTypeDTM = a2.j();
        this.eventActionDTM = a2.k();
        this.objString = a2.n();
        this.parameterStrings = a2.s();
        this.retString = a2.x();
        this.objTracked = a2.m();
        this.parameterTracked = a2.r();
        this.retTracked = a2.w();
        this.objHash = a2.p();
        this.parameterHash = a2.u();
        this.retHash = a2.z();
        this.objId = Objects.requireNonNull(a2.o());
        this.parameterIds = Objects.requireNonNull(a2.t());
        this.retId = Objects.requireNonNull(a2.y());
        this.tagRanges = a2.A();
        this.displayTagRanges = a2.B();
        this.stack = a2.C();
        this.sourceType = a2.c();
        this.targetType = a2.d();
    }

    public void prepareForReporting(List<CodeEvent> list, int n2) {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public j getStack() {
        return this.stack;
    }

    public void setStack(j j2) {
        this.stack = j2;
    }

    public char[] getObj() {
        return this.objString;
    }

    public char[][] getParameters() {
        return this.parameterStrings;
    }

    public char[] getRet() {
        return this.retString;
    }

    public String getThreadDesc() {
        return this.threadDesc;
    }

    public MethodDescription getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method.getSignature());
        stringBuilder.append("\n         ");
        stringBuilder.append(this.getObj());
        stringBuilder.append(".");
        stringBuilder.append(this.method.getName());
        char[][] cArray = this.getParameters();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            stringBuilder.append(cArray[i2].toString());
            if (i2 == cArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(" => ");
        stringBuilder.append(this.getRet());
        stringBuilder.append(" ");
        stringBuilder.append(this.getTagRanges());
        return stringBuilder.toString();
    }

    public final EventDTM toDtm() throws n {
        this.ensureValid();
        return this.getCommonDtm();
    }

    public final EventDTM getCommonDtm() {
        return this.getCommonDtmBuilder().build();
    }

    protected EventDTM.Builder getCommonDtmBuilder() {
        List<EventTaintRangeDTM> list = this.buildTaintRangeDTMs();
        return EventDTM.builder().type(this.eventTypeDTM).action(this.eventActionDTM).time(this.timestamp).thread(com.contrastsecurity.agent.util.k.a(this.threadDesc)).objectId(this.id).parentObjectIds(this.buildParentIdDtms()).source(this.sourceType).target(this.targetType).signature(EventSignatureDTM.builder().setClassName(this.method.getDeclaringClassType()).setMethodName(this.method.getName()).setConstructor("<init>".equalsIgnoreCase(this.method.getName())).setArgTypes(Arrays.asList(this.method.getParameterTypeNames())).setReturnType(this.method.getReturnTypeName()).setFlags(this.method.getModifiers()).build()).taintRanges(list).object(new ObjectDTM(Base64.encodeBase64String(new String(this.objString).getBytes()), this.objHash, this.objTracked, this.objTracked ? list : null)).ret(new ObjectDTM(Base64.encodeBase64String(new String(this.retString).getBytes()), this.retHash, this.retTracked, this.retTracked ? list : null)).args(this.buildArgumentDTMs(list)).tags(EventDTM.Builder.buildTagsString(this.eventTypeDTM, this.buildEventTagTypeDTMs())).stack(this.buildStackDTM());
    }

    private List<EventTaintRangeDTM> buildTaintRangeDTMs() {
        List<EventTaintRangeDTM> list = this.displayTagRanges != null ? this.displayTagRanges.getDtm() : (this.tagRanges != null ? this.tagRanges.getDtm() : Collections.singletonList(new EventTaintRangeDTM(EventTagTypeDTM.UNTRUSTED, "")));
        return list;
    }

    private Set<ParentObjectIdDTM> buildParentIdDtms() {
        HashSet<ParentObjectIdDTM> hashSet;
        if (this.parentIds != null && !this.parentIds.isEmpty()) {
            hashSet = new HashSet<ParentObjectIdDTM>(this.parentIds.size());
            for (Long l2 : this.parentIds) {
                hashSet.add(new ParentObjectIdDTM(l2));
            }
        } else {
            hashSet = null;
        }
        return hashSet;
    }

    private List<ObjectDTM> buildArgumentDTMs(List<EventTaintRangeDTM> list) {
        boolean bl2 = !this.objTracked && !this.retTracked;
        ArrayList<ObjectDTM> arrayList = new ArrayList<ObjectDTM>(this.parameterStrings.length);
        for (int i2 = 0; i2 < this.parameterStrings.length; ++i2) {
            ObjectDTM objectDTM = new ObjectDTM(Base64.encodeBase64String(new String(this.parameterStrings[i2]).getBytes()), this.parameterHash[i2], this.parameterTracked[i2], bl2 && this.parameterTracked[i2] ? list : null);
            arrayList.add(objectDTM);
        }
        return arrayList;
    }

    private EventTagTypeDTM[] buildEventTagTypeDTMs() {
        EventTagTypeDTM[] eventTagTypeDTMArray = new EventTagTypeDTM[]{};
        Set<String> set = this.getTags();
        if (set != null && set.size() > 0) {
            ArrayList<EventTagTypeDTM> arrayList = new ArrayList<EventTagTypeDTM>(set.size());
            for (String string : set) {
                arrayList.add(EventTagTypeDTM.fromString(string));
            }
            eventTagTypeDTMArray = arrayList.toArray(eventTagTypeDTMArray);
        }
        return eventTagTypeDTMArray;
    }

    @C
    protected List<StackDTM> buildStackDTM() {
        ArrayList<StackDTM> arrayList = null;
        if (this.stack != null) {
            List<StackTraceElement> list = this.stack.a();
            arrayList = new ArrayList<StackDTM>(list.size());
            for (StackTraceElement stackTraceElement : list) {
                StackDTM stackDTM = StackDTM.of(stackTraceElement);
                arrayList.add(stackDTM);
            }
        }
        return arrayList;
    }

    @C
    public List<StackTraceElement> getStackWithoutContrastCode() {
        return this.stack.a();
    }

    @k
    public StringBuilder toShortString(StringBuilder stringBuilder) {
        int n2;
        String[] stringArray;
        stringBuilder.append("PLUG");
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("CALLEE: ").append(this.method.getReturnTypeName()).append(' ').append(this.method.getDeclaringClassType()).append('.').append(this.method.getName()).append('(');
        CodeEvent.joinWithSeparator(stringBuilder, this.method.getParameterTypeNames());
        stringBuilder.append(')');
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        if (this.stack != null) {
            stringArray = this.stack.a();
            for (n2 = 0; n2 < 15 && n2 < stringArray.size(); ++n2) {
                stringBuilder.append("CALLER: ").append(stringArray.get(n2)).append(TRACE_NEWLINE_INDENT);
            }
        }
        stringBuilder.append("OBJ:");
        CodeEvent.formatValueForShortString(stringBuilder, this.method.getDeclaringClassType(), this.objString, this.objHash, this.objTracked);
        stringBuilder.append(".");
        stringBuilder.append(this.method.getName());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("LENGTH: ").append(this.objString.length);
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("TAGS: ").append(this.getTagRanges());
        stringArray = this.method.getParameterTypeNames();
        for (n2 = 0; n2 < this.parameterStrings.length; ++n2) {
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("P-").append(n2).append(":");
            CodeEvent.formatValueForShortString(stringBuilder, stringArray[n2], this.parameterStrings[n2], this.parameterHash[n2], this.parameterTracked[n2]);
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("LENGTH: ").append(this.parameterStrings[n2].length);
        }
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("RET:");
        CodeEvent.formatValueForShortString(stringBuilder, this.method.getReturnTypeName(), this.retString, this.retHash, this.retTracked);
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("LENGTH: ").append(this.retString.length);
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("OBJ_ID:").append(this.objId);
        for (n2 = 0; n2 < this.parameterIds.length; ++n2) {
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("P-").append(n2).append("_ID:").append(this.parameterIds[n2]);
        }
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("RET_ID:").append(this.retId);
        return stringBuilder;
    }

    @k
    private static void formatValueForShortString(StringBuilder stringBuilder, String string, char[] cArray, int n2, boolean bl2) {
        stringBuilder.append(string).append('[').append(cArray).append(']');
        if (bl2) {
            stringBuilder.append('*').append(n2);
        }
    }

    @k
    private static void joinWithSeparator(StringBuilder stringBuilder, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(stringArray[i2]);
        }
    }

    @Deprecated
    @k
    BitSet getBitSet() {
        BitSet bitSet = new BitSet();
        List<TagRange> list = this.getUntrustedRanges();
        if (list != null) {
            for (TagRange tagRange : list) {
                bitSet.set(tagRange.getStart(), tagRange.getStop());
            }
        }
        return bitSet;
    }

    public String getMethodName() {
        return this.method.getDeclaringClassType() + "." + this.method.getName();
    }

    public TagRanges getTagRanges() {
        return this.tagRanges;
    }

    public TagRanges getDisplayTagRanges() {
        return this.displayTagRanges;
    }

    public void addTags(String[] stringArray, int n2) throws InvalidTagRangeException {
        if (n2 <= 0) {
            return;
        }
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>(this.tagRanges.size() + stringArray.length);
        arrayList.addAll(this.tagRanges.getTagRanges());
        for (String string : stringArray) {
            arrayList.add(new TagRange(0, n2, string));
        }
        this.tagRanges = new TagRanges(arrayList);
    }

    private List<TagRange> getUntrustedRanges() {
        return this.tagRanges != null ? this.tagRanges.getUntrustedRanges() : null;
    }

    public Set<String> getTags() {
        return this.tagRanges != null ? this.tagRanges.getTags() : null;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public int[] getParameterHashes() {
        return this.parameterHash;
    }

    public int getRetHash() {
        return this.retHash;
    }

    public long getId() {
        return this.id;
    }

    public Set<Long> getParentIds() {
        return this.parentIds;
    }

    public boolean[] getParamsTracked() {
        return this.parameterTracked;
    }

    public boolean isAnyParamTracked() {
        boolean bl2 = false;
        if (this.parameterTracked != null) {
            for (int i2 = 0; i2 < this.parameterTracked.length && !bl2; ++i2) {
                bl2 = this.parameterTracked[i2];
            }
        }
        return bl2;
    }

    public boolean isObjectTracked() {
        return this.objTracked;
    }

    public boolean isReturnTracked() {
        return this.retTracked;
    }

    protected void ensureValid() throws n {
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public EventTypeDTM getEventTypeDTM() {
        return this.eventTypeDTM;
    }

    public EventActionDTM getEventActionDTM() {
        return this.eventActionDTM;
    }

    public static interface a {
        public long e();

        public Set<Long> f();

        public long g();

        public String h();

        public MethodDescription i();

        public EventTypeDTM j();

        public EventActionDTM k();

        public boolean m();

        public char[] n();

        public char[] o();

        public int p();

        public boolean[] r();

        public char[][] s();

        public char[][] t();

        public int[] u();

        public boolean w();

        public char[] x();

        public char[] y();

        public int z();

        public TagRanges A();

        public TagRanges B();

        public j C();

        public String c();

        public String d();
    }
}

