/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace.snapshot;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.plugins.frameworks.Z;
import com.contrastsecurity.agent.plugins.frameworks.o;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.snapshot.CharSequenceSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.DataSnapshot;
import com.contrastsecurity.agent.trace.snapshot.DoubleArraySnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.MapSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.StringCacheSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.a;
import com.contrastsecurity.agent.trace.snapshot.b;
import com.contrastsecurity.agent.trace.snapshot.c;
import com.contrastsecurity.agent.trace.snapshot.e;
import com.contrastsecurity.agent.trace.snapshot.h;
import com.contrastsecurity.agent.trace.snapshot.i;
import com.contrastsecurity.agent.trace.snapshot.j;
import com.contrastsecurity.agent.trace.snapshot.k;
import com.contrastsecurity.agent.trace.snapshot.l;
import com.contrastsecurity.agent.trace.snapshot.m;
import com.contrastsecurity.agent.trace.snapshot.n;
import com.contrastsecurity.agent.trace.snapshot.q;
import com.contrastsecurity.agent.trace.snapshot.s;
import com.contrastsecurity.agent.trace.snapshot.u;
import com.contrastsecurity.agent.trace.snapshot.v;
import com.contrastsecurity.agent.trace.snapshot.w;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ObjectUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Singleton
@DontObfuscate
public final class ObjectSnapshotFactory {
    private final s contextCache;
    private final o frameworkManager;
    private final int maxContextSnapshotCacheSize;
    private final h defaultFactory;
    private final u<Object>[] factories;
    private static final m MAX_CHARACTERS = m.a(150);
    private static final n MAX_ITEMS = n.a(10);
    private static final DataSnapshot NULL_SNAPSHOT = new DataSnapshot(Empty.NULL, null);
    private static final String LM_CACHE = "AssessContextCache";
    private static final j IDENTITY_FACTORY = new j();
    private static final Logger logger = LoggerFactory.getLogger(ObjectSnapshotFactory.class);

    @Inject
    public ObjectSnapshotFactory(g g2, AssessmentManager assessmentManager, o o2) {
        this(g2, new a(assessmentManager), o2);
    }

    @C
    ObjectSnapshotFactory(g g2, s s2, o o2) {
        Objects.requireNonNull(g2);
        Objects.requireNonNull(s2);
        Objects.requireNonNull(o2);
        this.contextCache = s2;
        this.frameworkManager = o2;
        this.maxContextSnapshotCacheSize = g2.d(ConfigProperty.MAX_CONTEXT_SNAPSHOT_CACHE_SIZE);
        this.factories = ObjectSnapshotFactory.buildFactories(g2);
        this.defaultFactory = new h(MAX_CHARACTERS, g2);
    }

    public char[] snapshot(Object object) {
        char[] cArray;
        boolean bl2 = this.qualifiesForContextCache(object);
        char[] cArray2 = cArray = bl2 ? this.contextCache.a(object) : null;
        if (cArray != null) {
            this.logCacheHit(v.a, object);
            return cArray;
        }
        if (object != null) {
            this.logCacheMiss(v.a, object);
        }
        try {
            if (object != null) {
                for (u<Object> u2 : this.factories) {
                    if (!u2.supports(object)) continue;
                    cArray = u2.snapshot(object);
                    break;
                }
                if (cArray == null) {
                    cArray = this.snapshotWithFrameworkSupporters(object);
                }
                if (cArray == null) {
                    cArray = this.defaultFactory.snapshotAndTruncate(object);
                }
            } else {
                cArray = Empty.NULL;
            }
        }
        catch (Exception exception) {
            cArray = IDENTITY_FACTORY.snapshotAndTruncate(object);
        }
        if (bl2 && this.contextCache.a() < this.maxContextSnapshotCacheSize) {
            this.contextCache.a(object, cArray);
        }
        return cArray;
    }

    private void logCacheHit(v v2, Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}|{}|operation={}&value={}", new Object[]{LM_CACHE, c.a, v2, ObjectUtils.identityToString(object)});
        }
    }

    private void logCacheMiss(v v2, Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}|{}|operation={}&type={}&value={}", new Object[]{LM_CACHE, c.b, v2, object.getClass().getName(), ObjectUtils.identityToString(object)});
        }
    }

    private boolean qualifiesForContextCache(Object object) {
        return !(object instanceof String) && this.isProbablyImmutable(object);
    }

    public char[] snapshotAndTruncate(Object object) {
        char[] cArray;
        boolean bl2 = this.qualifiesForContextCache(object);
        char[] cArray2 = cArray = bl2 ? this.contextCache.b(object) : null;
        if (cArray != null) {
            this.logCacheHit(v.b, object);
            return cArray;
        }
        if (object != null) {
            this.logCacheMiss(v.b, object);
        }
        try {
            if (object != null) {
                for (u<Object> u2 : this.factories) {
                    if (!u2.supports(object)) continue;
                    cArray = u2.snapshotAndTruncate(object);
                    break;
                }
                if (cArray == null) {
                    cArray = this.snapshotAndTruncateWithFrameworkSupporters(object);
                }
                if (cArray == null) {
                    cArray = this.defaultFactory.snapshotAndTruncate(object);
                }
            } else {
                cArray = Empty.NULL;
            }
        }
        catch (Exception exception) {
            cArray = IDENTITY_FACTORY.snapshotAndTruncate(object);
        }
        if (bl2 && this.contextCache.a() < this.maxContextSnapshotCacheSize) {
            this.contextCache.b(object, cArray);
        }
        return cArray;
    }

    public DataSnapshot snapshotAndTruncate(Object object, TagRanges tagRanges) {
        DataSnapshot dataSnapshot;
        boolean bl2 = this.qualifiesForContextCache(object);
        DataSnapshot dataSnapshot2 = dataSnapshot = bl2 ? this.contextCache.c(object) : null;
        if (dataSnapshot != null) {
            this.logCacheHit(v.c, object);
            return dataSnapshot;
        }
        if (object != null) {
            this.logCacheMiss(v.c, object);
        }
        try {
            if (object != null) {
                for (u<Object> u2 : this.factories) {
                    if (!u2.supports(object)) continue;
                    dataSnapshot = u2.snapshotAndTruncate(object, tagRanges);
                    break;
                }
                if (dataSnapshot == null) {
                    dataSnapshot = this.snapshotAndTruncateWithFrameworkSupporters(object, tagRanges);
                }
                if (dataSnapshot == null) {
                    dataSnapshot = this.defaultFactory.snapshotAndTruncate(object, tagRanges);
                }
            } else {
                dataSnapshot = NULL_SNAPSHOT;
            }
        }
        catch (Exception exception) {
            dataSnapshot = IDENTITY_FACTORY.snapshotAndTruncate(object, tagRanges);
        }
        if (bl2 && dataSnapshot != null && this.contextCache.a() < this.maxContextSnapshotCacheSize) {
            this.contextCache.a(object, dataSnapshot);
        }
        return dataSnapshot;
    }

    @C
    boolean isProbablyImmutable(Object object) {
        if (object instanceof String || object instanceof Number || object instanceof File || object instanceof InputStream || object instanceof URI || object instanceof URL) {
            return true;
        }
        return !(object instanceof Collection) && !(object instanceof Map) && !(object instanceof CharSequence) && (object == null || !object.getClass().isArray());
    }

    private char[] snapshotWithFrameworkSupporters(Object object) {
        List<Z> list = this.frameworkManager.g();
        char[] cArray = null;
        for (int i2 = 0; cArray == null && i2 < list.size(); ++i2) {
            Z z2 = list.get(i2);
            cArray = z2.a(object);
        }
        return cArray;
    }

    private char[] snapshotAndTruncateWithFrameworkSupporters(Object object) {
        List<Z> list = this.frameworkManager.g();
        char[] cArray = null;
        for (int i2 = 0; cArray == null && i2 < list.size(); ++i2) {
            Z z2 = list.get(i2);
            cArray = z2.b(object);
        }
        return cArray;
    }

    private DataSnapshot snapshotAndTruncateWithFrameworkSupporters(Object object, TagRanges tagRanges) {
        List<Z> list = this.frameworkManager.g();
        DataSnapshot dataSnapshot = null;
        for (int i2 = 0; dataSnapshot == null && i2 < list.size(); ++i2) {
            Z z2 = list.get(i2);
            dataSnapshot = z2.a(object, tagRanges);
        }
        return dataSnapshot;
    }

    private static u<Object>[] buildFactories(g g2) {
        CharSequenceSnapshotFactory charSequenceSnapshotFactory = new CharSequenceSnapshotFactory(MAX_CHARACTERS);
        return new u[]{new StringCacheSnapshotFactory(g2, charSequenceSnapshotFactory), charSequenceSnapshotFactory, new e(MAX_CHARACTERS), new b(MAX_CHARACTERS, charSequenceSnapshotFactory), new k(MAX_CHARACTERS), new i(MAX_ITEMS), new l(MAX_CHARACTERS), new DoubleArraySnapshotFactory(MAX_ITEMS), new MapSnapshotFactory(), new w(MAX_CHARACTERS), new q(MAX_ITEMS)};
    }
}

