/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.config.y;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.telemetry.b;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.agent.x;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.time.DurationFormatUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

@DontObfuscate
public class PerfUtil {
    private static final boolean PROFILING_STARTUP = P.b(x.b(ConfigProperty.PROFILE_STARTUP.legacySystemPropertyName()));
    private static final String PREMAIN_DURATION_HEADER = "Premain Duration";
    private static final String REQUEST_COMPLETE_HEADER = "Uptime to First Request Complete";
    private static final String REQUEST_DURATION_HEADER = "First Request Duration";
    @C
    static final String STARTUP_STATS_HEADER_ROW = "Premain Duration (ms),Uptime to First Request Complete (ms),First Request Duration (ms)";
    @C
    static final String STARTUP_STATS_FILE_NAME = "startup-stats.csv";
    private static final Logger logger = LoggerFactory.getLogger(PerfUtil.class);

    private static boolean notProfilingStartup() {
        return !PROFILING_STARTUP && !logger.isDebugEnabled();
    }

    public static void printStartupTimingMessage(a a2, String string, N n2) {
        if (PerfUtil.notProfilingStartup()) {
            return;
        }
        String string2 = PerfUtil.createMessage(a2, string, n2.toString());
        PerfUtil.printStartupTimingMessage(string2);
    }

    public static void printStartupTimingMessage(a a2, String string, long l2) {
        if (PerfUtil.notProfilingStartup()) {
            return;
        }
        String string2 = PerfUtil.createMessage(a2, string, DurationFormatUtils.formatDurationHMS(l2));
        PerfUtil.printStartupTimingMessage(string2);
    }

    public static void printStartupTimingMessage(String string) {
        logger.debug(string);
        if (PROFILING_STARTUP) {
            G.a(string);
        }
    }

    private static String createMessage(a a2, String string, String string2) {
        return "[startup] " + StringUtils.repeat("\t", a2.ordinal()) + string + " " + string2;
    }

    public static i newStartupReportingFirstRequestEndListener(StartupTiming startupTiming, b b2, g g2) {
        return PerfUtil.newStartupReportingFirstRequestEndListener(PROFILING_STARTUP, startupTiming, b2, g2);
    }

    @C
    static i newStartupReportingFirstRequestEndListener(boolean bl2, StartupTiming startupTiming, b b2, g g2) {
        return l2 -> {
            PerfUtil.writeStartupStats(bl2, startupTiming, l2, g2);
            b2.a("uptime-first-request-complete", startupTiming.currentJvmUptimeMs());
            b2.a("first-request-duration", l2);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @C
    static void writeStartupStats(boolean bl2, StartupTiming startupTiming, long l2, g g2) {
        long l3 = startupTiming.currentJvmUptimeMs();
        PerfUtil.printStartupTimingMessage(a.f, PREMAIN_DURATION_HEADER, startupTiming.premainElapsedTimeMs());
        PerfUtil.printStartupTimingMessage(a.f, REQUEST_COMPLETE_HEADER, l3);
        PerfUtil.printStartupTimingMessage(a.f, REQUEST_DURATION_HEADER, l2);
        if (!bl2) {
            return;
        }
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(y.a(g2).d(), STARTUP_STATS_FILE_NAME);
            printWriter = new PrintWriter(file, "UTF-8");
            printWriter.append(STARTUP_STATS_HEADER_ROW).append("\n").append(Long.toString(startupTiming.premainElapsedTimeMs())).append(",").append(Long.toString(l3)).append(",").append(Long.toString(l2)).append("\n");
        }
        catch (IOException iOException) {
            try {
                G.b("Failed to write startup stats to " + (file != null ? file : STARTUP_STATS_FILE_NAME) + ".");
                iOException.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(printWriter);
                throw throwable;
            }
            IOUtils.closeQuietly(printWriter);
        }
        IOUtils.closeQuietly(printWriter);
    }

    public static enum a {
        a(true, null),
        b(true, "sub"),
        c(false, "subs"),
        d(false, "subss"),
        e(false, "subsss"),
        f(true, null);

        private final boolean g;
        private final String h;

        private a(boolean bl2, String string2) {
            this.g = bl2;
            this.h = string2;
        }

        public boolean a() {
            return this.g;
        }

        public String b() {
            return this.h;
        }
    }
}

