/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.weakmap;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.util.v;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

@DontObfuscate
public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    private static final long serialVersionUID = 7249069246763182397L;
    static final c DEFAULT_KEY_TYPE = c.b;
    static final c DEFAULT_VALUE_TYPE = c.a;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    boolean identityComparisons;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    private boolean trackTargets;
    Map<String, Long> hashTargets = new ConcurrentHashMap<String, Long>();

    private static int hash(int n2) {
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    final Segment<K, V> segmentFor(int n2) {
        return this.segments[n2 >>> this.segmentShift & this.segmentMask];
    }

    private int hashOf(Object object) {
        if (this.trackTargets) {
            String string = object.getClass().getName();
            Long l2 = this.hashTargets.get(string);
            if (l2 == null) {
                l2 = 0L;
            }
            this.hashTargets.put(string, l2 + 1L);
        }
        return v.a(object);
    }

    public void dumpStats() {
        if (this.trackTargets) {
            Set<String> set = this.hashTargets.keySet();
            for (String string : set) {
                System.out.println(string + "," + this.hashTargets.get(string));
            }
        }
    }

    public ConcurrentReferenceHashMap(int n2, float f2, int n3, c c2, c c3, EnumSet<b> enumSet) {
        int n4;
        int n5;
        int n6;
        if (!(f2 > 0.0f) || n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n3 > 65536) {
            n3 = 65536;
        }
        int n7 = 0;
        for (n6 = 1; n6 < n3; n6 <<= 1) {
            ++n7;
        }
        this.segmentShift = 32 - n7;
        this.segmentMask = n6 - 1;
        this.segments = Segment.newArray(n6);
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if ((n5 = n2 / n6) * n6 < n2) {
            ++n5;
        }
        for (n4 = 1; n4 < n5; n4 <<= 1) {
        }
        this.identityComparisons = enumSet != null && enumSet.contains((Object)b.a);
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = new Segment(n4, f2, c2, c3, this.identityComparisons);
        }
    }

    public ConcurrentReferenceHashMap(int n2, float f2, int n3) {
        this(n2, f2, n3, DEFAULT_KEY_TYPE, DEFAULT_VALUE_TYPE, null);
    }

    public ConcurrentReferenceHashMap(int n2, float f2) {
        this(n2, f2, 16);
    }

    public ConcurrentReferenceHashMap(int n2, c c2, c c3) {
        this(n2, 0.75f, 16, c2, c3, null);
    }

    public ConcurrentReferenceHashMap(c c2, c c3) {
        this(16, 0.75f, 16, c2, c3, null);
    }

    public ConcurrentReferenceHashMap(c c2, c c3, EnumSet<b> enumSet) {
        this(16, 0.75f, 16, c2, c3, enumSet);
    }

    public ConcurrentReferenceHashMap(int n2) {
        this(n2, 0.75f, 16);
    }

    public ConcurrentReferenceHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentReferenceHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        int n2;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n3 = 0;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            nArray[n2] = segmentArray[n2].modCount;
            n3 += nArray[n2];
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count == 0 && nArray[n2] == segmentArray[n2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n2;
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = 0L;
        long l3 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n2 = 0; n2 < 2; ++n2) {
            int n3;
            l3 = 0L;
            l2 = 0L;
            int n4 = 0;
            for (n3 = 0; n3 < segmentArray.length; ++n3) {
                l2 += (long)segmentArray[n3].count;
                nArray[n3] = segmentArray[n3].modCount;
                n4 += nArray[n3];
            }
            if (n4 != 0) {
                for (n3 = 0; n3 < segmentArray.length; ++n3) {
                    l3 += (long)segmentArray[n3].count;
                    if (nArray[n3] == segmentArray[n3].modCount) continue;
                    l3 = -1L;
                    break;
                }
            }
            if (l3 == l2) break;
        }
        if (l3 != l2) {
            l2 = 0L;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segmentArray[n2].lock();
            }
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l2 += (long)segmentArray[n2].count;
            }
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segmentArray[n2].unlock();
            }
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public V get(Object object) {
        int n2 = this.hashOf(object);
        return this.segmentFor(n2).get(object, n2);
    }

    @Override
    public boolean containsKey(Object object) {
        int n2 = this.hashOf(object);
        return this.segmentFor(n2).containsKey(object, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        int n2;
        boolean bl2;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl2 = false; bl2 < 2 != 0; bl2 += 1) {
            int n3;
            int n4;
            n2 = 0;
            int n5 = 0;
            for (n4 = 0; n4 < segmentArray.length; ++n4) {
                n3 = segmentArray[n4].count;
                nArray[n4] = segmentArray[n4].modCount;
                n5 += nArray[n4];
                if (!segmentArray[n4].containsValue(object)) continue;
                return true;
            }
            n4 = 1;
            if (n5 != 0) {
                for (n3 = 0; n3 < segmentArray.length; ++n3) {
                    int n6 = segmentArray[n3].count;
                    if (nArray[n3] == segmentArray[n3].modCount) continue;
                    n4 = 0;
                    break;
                }
            }
            if (n4 == 0) continue;
            return false;
        }
        for (bl2 = false; bl2 < segmentArray.length; bl2 += 1) {
            segmentArray[bl2].lock();
        }
        bl2 = false;
        try {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (!segmentArray[n2].containsValue(object)) continue;
                bl2 = true;
                break;
            }
        }
        finally {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segmentArray[n2].unlock();
            }
        }
        return bl2;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).put(k2, n2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).put(k2, n2, v2, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n2 = this.hashOf(object);
        return this.segmentFor(n2).remove(object, n2, null, false);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n2 = this.hashOf(object);
        if (object2 == null) {
            return false;
        }
        return this.segmentFor(n2).remove(object, n2, object2, false) != null;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        if (v2 == null || v3 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).replace(k2, n2, v2, v3);
    }

    @Override
    public V replace(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).replace(k2, n2, v2);
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].clear();
        }
    }

    public void purgeStaleEntries() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].removeStale();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Segment<K, V> segment = this.segments[i2];
            segment.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = segment.table;
                for (int i3 = 0; i3 < hashEntryArray.length; ++i3) {
                    HashEntry hashEntry = hashEntryArray[i3];
                    while (hashEntry != null) {
                        Object k2 = hashEntry.key();
                        if (k2 != null) {
                            objectOutputStream.writeObject(k2);
                            objectOutputStream.writeObject(hashEntry.value());
                        }
                        hashEntry = hashEntry.next;
                    }
                }
                continue;
            }
            finally {
                segment.unlock();
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].setTable(new HashEntry[1]);
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    @DontObfuscate
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v2 = ConcurrentReferenceHashMap.this.get(entry.getKey());
            return v2 != null && v2.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentReferenceHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    @DontObfuscate
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    @DontObfuscate
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentReferenceHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    @DontObfuscate
    final class EntryIterator
    extends HashIterator
    implements Iterator {
        EntryIterator() {
        }

        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key(), hashEntry.value());
        }
    }

    @DontObfuscate
    final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        private static final long serialVersionUID = -7900634345345313646L;

        WriteThroughEntry(K k2, V v2) {
            super(k2, v2);
        }

        @Override
        public V setValue(V v2) {
            if (v2 == null) {
                throw new NullPointerException();
            }
            Object v3 = super.setValue(v2);
            ConcurrentReferenceHashMap.this.put(this.getKey(), v2);
            return v3;
        }
    }

    @DontObfuscate
    static class SimpleEntry<K, V>
    implements Serializable,
    Map.Entry<K, V> {
        private static final long serialVersionUID = -8499721149061103585L;
        private final K key;
        private V value;

        SimpleEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return Objects.equals(object, object2);
        }
    }

    @DontObfuscate
    final class ValueIterator
    extends HashIterator
    implements Enumeration,
    Iterator {
        ValueIterator() {
        }

        public V next() {
            return super.nextEntry().value();
        }

        public V nextElement() {
            return super.nextEntry().value();
        }
    }

    @DontObfuscate
    final class KeyIterator
    extends HashIterator
    implements Enumeration,
    Iterator {
        KeyIterator() {
        }

        public K next() {
            return super.nextEntry().key();
        }

        public K nextElement() {
            return super.nextEntry().key();
        }
    }

    @DontObfuscate
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentReferenceHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = ConcurrentReferenceHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i2 = this.currentTable.length - 1; i2 >= 0; --i2) {
                    this.nextEntry = this.currentTable[i2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i2 - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReferenceHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    @DontObfuscate
    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;
        volatile transient ReferenceQueue<Object> refQueue;
        final c keyType;
        final c valueType;
        final boolean identityComparisons;

        Segment(int n2, float f2, c c2, c c3, boolean bl2) {
            this.loadFactor = f2;
            this.keyType = c2;
            this.valueType = c3;
            this.identityComparisons = bl2;
            this.setTable(HashEntry.newArray(n2));
        }

        static <K, V> Segment<K, V>[] newArray(int n2) {
            return new Segment[n2];
        }

        private boolean keyEq(Object object, Object object2) {
            return object == object2;
        }

        void setTable(HashEntry<K, V>[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
            this.refQueue = new ReferenceQueue();
        }

        HashEntry<K, V> getFirst(int n2) {
            HashEntry<K, V>[] hashEntryArray = this.table;
            return hashEntryArray[n2 & hashEntryArray.length - 1];
        }

        HashEntry<K, V> newHashEntry(K k2, int n2, HashEntry<K, V> hashEntry, V v2) {
            return new HashEntry<K, V>(k2, n2, hashEntry, v2, this.keyType, this.valueType, this.refQueue);
        }

        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                this.removeStale();
                V v2 = hashEntry.value();
                return v2;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, int n2) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (hashEntry != null) {
                    if (hashEntry.hash == n2 && this.keyEq(object, hashEntry.key())) {
                        Object object2 = hashEntry.valueRef;
                        if (object2 != null) {
                            return hashEntry.dereferenceValue(object2);
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        boolean containsKey(Object object, int n2) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (hashEntry != null) {
                    if (hashEntry.hash == n2 && this.keyEq(object, hashEntry.key())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry<K, V> hashEntry : this.table) {
                    while (hashEntry != null) {
                        Object object2 = hashEntry.valueRef;
                        V v2 = object2 == null ? this.readValueUnderLock(hashEntry) : hashEntry.dereferenceValue(object2);
                        if (object.equals(v2)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k2, int n2, V v2, V v3) {
            this.lock();
            try {
                this.removeStale();
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (!(hashEntry == null || hashEntry.hash == n2 && this.keyEq(k2, hashEntry.key()))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl2 = false;
                if (hashEntry != null && v2.equals(hashEntry.value())) {
                    bl2 = true;
                    hashEntry.setValue(v3, this.valueType, this.refQueue);
                }
                boolean bl3 = bl2;
                return bl3;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k2, int n2, V v2) {
            this.lock();
            try {
                this.removeStale();
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (!(hashEntry == null || hashEntry.hash == n2 && this.keyEq(k2, hashEntry.key()))) {
                    hashEntry = hashEntry.next;
                }
                V v3 = null;
                if (hashEntry != null) {
                    v3 = hashEntry.value();
                    hashEntry.setValue(v2, this.valueType, this.refQueue);
                }
                V v4 = v3;
                return v4;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k2, int n2, V v2, boolean bl2) {
            this.lock();
            try {
                V v3;
                HashEntry<K, V> hashEntry;
                int n3;
                this.removeStale();
                int n4 = this.count;
                if (n4++ > this.threshold && (n3 = this.rehash()) > 0) {
                    this.count = (n4 -= n3) - 1;
                }
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n5 = n2 & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n5];
                while (!(hashEntry2 == null || hashEntry2.hash == n2 && this.keyEq(k2, hashEntry2.key()))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    v3 = hashEntry2.value();
                    if (!bl2) {
                        hashEntry2.setValue(v2, this.valueType, this.refQueue);
                    }
                } else {
                    v3 = null;
                    ++this.modCount;
                    hashEntryArray[n5] = this.newHashEntry(k2, n2, hashEntry, v2);
                    this.count = n4;
                }
                V v4 = v3;
                return v4;
            }
            finally {
                this.unlock();
            }
        }

        int rehash() {
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n2 = hashEntryArray.length;
            if (n2 >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] hashEntryArray2 = HashEntry.newArray(n2 << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n3 = hashEntryArray2.length - 1;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                HashEntry<K, V> hashEntry = hashEntryArray[i2];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n5 = hashEntry.hash & n3;
                if (hashEntry2 == null) {
                    hashEntryArray2[n5] = hashEntry;
                    continue;
                }
                HashEntry<K, V> hashEntry3 = hashEntry;
                int n6 = n5;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    int n7 = hashEntry4.hash & n3;
                    if (n7 != n6) {
                        n6 = n7;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n6] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    Object k2 = hashEntry4.key();
                    if (k2 == null) {
                        ++n4;
                    } else {
                        int n8 = hashEntry4.hash & n3;
                        HashEntry hashEntry5 = hashEntryArray2[n8];
                        hashEntryArray2[n8] = this.newHashEntry(k2, hashEntry4.hash, hashEntry5, hashEntry4.value());
                    }
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
            return n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n2, Object object2, boolean bl2) {
            this.lock();
            try {
                V v2;
                HashEntry<K, V> hashEntry;
                if (!bl2) {
                    this.removeStale();
                }
                int n3 = this.count - 1;
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n4 = n2 & hashEntryArray.length - 1;
                HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n4];
                while (hashEntry2 != null && object != hashEntry2.keyRef && (bl2 || n2 != hashEntry2.hash || !this.keyEq(object, hashEntry2.key()))) {
                    hashEntry2 = hashEntry2.next;
                }
                V v3 = null;
                if (hashEntry2 != null) {
                    v2 = hashEntry2.value();
                    if (object2 == null || object2.equals(v2)) {
                        v3 = v2;
                        ++this.modCount;
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry<K, V> hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            K k2 = hashEntry4.key();
                            if (k2 == null) {
                                --n3;
                            } else {
                                hashEntry3 = this.newHashEntry(k2, hashEntry4.hash, hashEntry3, hashEntry4.value());
                            }
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n4] = hashEntry3;
                        this.count = n3;
                    }
                }
                v2 = v3;
                return v2;
            }
            finally {
                this.unlock();
            }
        }

        void removeStale() {
            a a2;
            while ((a2 = (a)((Object)this.refQueue.poll())) != null) {
                this.remove(a2.keyRef(), a2.keyHash(), null, true);
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    for (int i2 = 0; i2 < hashEntryArray.length; ++i2) {
                        hashEntryArray[i2] = null;
                    }
                    ++this.modCount;
                    this.refQueue = new ReferenceQueue();
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    @DontObfuscate
    static final class HashEntry<K, V> {
        final Object keyRef;
        final int hash;
        volatile Object valueRef;
        final HashEntry<K, V> next;

        HashEntry(K k2, int n2, HashEntry<K, V> hashEntry, V v2, c c2, c c3, ReferenceQueue<Object> referenceQueue) {
            this.hash = n2;
            this.next = hashEntry;
            this.keyRef = this.newKeyReference(k2, c2, referenceQueue);
            this.valueRef = this.newValueReference(v2, c3, referenceQueue);
        }

        Object newKeyReference(K k2, c c2, ReferenceQueue<Object> referenceQueue) {
            if (c2 == c.b) {
                return new WeakKeyReference<K>(k2, this.hash, referenceQueue);
            }
            if (c2 == c.c) {
                return new d<K>(k2, this.hash, referenceQueue);
            }
            return k2;
        }

        Object newValueReference(V v2, c c2, ReferenceQueue<Object> referenceQueue) {
            if (c2 == c.b) {
                return new f<V>(v2, this.keyRef, this.hash, referenceQueue);
            }
            if (c2 == c.c) {
                return new e<V>(v2, this.keyRef, this.hash, referenceQueue);
            }
            return v2;
        }

        K key() {
            if (this.keyRef instanceof a) {
                return (K)((Reference)this.keyRef).get();
            }
            return (K)this.keyRef;
        }

        V value() {
            return this.dereferenceValue(this.valueRef);
        }

        V dereferenceValue(Object object) {
            if (object instanceof a) {
                return (V)((Reference)object).get();
            }
            return (V)object;
        }

        void setValue(V v2, c c2, ReferenceQueue<Object> referenceQueue) {
            this.valueRef = this.newValueReference(v2, c2, referenceQueue);
        }

        static <K, V> HashEntry<K, V>[] newArray(int n2) {
            return new HashEntry[n2];
        }
    }

    static final class e<V>
    extends SoftReference<V>
    implements a {
        final Object a;
        final int b;

        e(V v2, Object object, int n2, ReferenceQueue<Object> referenceQueue) {
            super(v2, referenceQueue);
            this.a = object;
            this.b = n2;
        }

        @Override
        public int keyHash() {
            return this.b;
        }

        @Override
        public Object keyRef() {
            return this.a;
        }
    }

    static final class f<V>
    extends WeakReference<V>
    implements a {
        final Object a;
        final int b;

        f(V v2, Object object, int n2, ReferenceQueue<Object> referenceQueue) {
            super(v2, referenceQueue);
            this.a = object;
            this.b = n2;
        }

        @Override
        public int keyHash() {
            return this.b;
        }

        @Override
        public Object keyRef() {
            return this.a;
        }
    }

    static final class d<K>
    extends SoftReference<K>
    implements a {
        final int a;

        d(K k2, int n2, ReferenceQueue<Object> referenceQueue) {
            super(k2, referenceQueue);
            this.a = n2;
        }

        @Override
        public int keyHash() {
            return this.a;
        }

        @Override
        public Object keyRef() {
            return this;
        }
    }

    @DontObfuscate
    static final class WeakKeyReference<K>
    extends WeakReference<K>
    implements a {
        final int hash;

        WeakKeyReference(K k2, int n2, ReferenceQueue<Object> referenceQueue) {
            super(k2, referenceQueue);
            this.hash = n2;
        }

        @Override
        public int keyHash() {
            return this.hash;
        }

        @Override
        public Object keyRef() {
            return this;
        }
    }

    static interface a {
        public int keyHash();

        public Object keyRef();
    }

    public static enum b {
        a;

    }

    public static enum c {
        a,
        b,
        c;

    }
}

