/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.UnsafeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

final class ByteBufferWriter {
    private static final int MIN_CACHED_BUFFER_SIZE = 1024;
    private static final int MAX_CACHED_BUFFER_SIZE = 16384;
    private static final float BUFFER_REALLOCATION_THRESHOLD = 0.5f;
    private static final ThreadLocal<SoftReference<byte[]>> BUFFER = new ThreadLocal();
    private static final Class<?> FILE_OUTPUT_STREAM_CLASS = ByteBufferWriter.safeGetClass("java.io.FileOutputStream");
    private static final long CHANNEL_FIELD_OFFSET = ByteBufferWriter.getChannelFieldOffset(FILE_OUTPUT_STREAM_CLASS);

    private ByteBufferWriter() {
    }

    static void clearCachedBuffer() {
        BUFFER.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        int n2 = byteBuffer.position();
        try {
            if (byteBuffer.hasArray()) {
                outputStream.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            } else if (!ByteBufferWriter.writeToChannel(byteBuffer, outputStream)) {
                byte[] byArray = ByteBufferWriter.getOrCreateBuffer(byteBuffer.remaining());
                while (byteBuffer.hasRemaining()) {
                    int n3 = Math.min(byteBuffer.remaining(), byArray.length);
                    byteBuffer.get(byArray, 0, n3);
                    outputStream.write(byArray, 0, n3);
                }
            }
        }
        finally {
            byteBuffer.position(n2);
        }
    }

    private static byte[] getOrCreateBuffer(int n2) {
        n2 = Math.max(n2, 1024);
        byte[] byArray = ByteBufferWriter.getBuffer();
        if (byArray == null || ByteBufferWriter.needToReallocate(n2, byArray.length)) {
            byArray = new byte[n2];
            if (n2 <= 16384) {
                ByteBufferWriter.setBuffer(byArray);
            }
        }
        return byArray;
    }

    private static boolean needToReallocate(int n2, int n3) {
        return n3 < n2 && (float)n3 < (float)n2 * 0.5f;
    }

    private static byte[] getBuffer() {
        SoftReference<byte[]> softReference = BUFFER.get();
        return softReference == null ? null : softReference.get();
    }

    private static void setBuffer(byte[] byArray) {
        BUFFER.set(new SoftReference<byte[]>(byArray));
    }

    private static boolean writeToChannel(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (CHANNEL_FIELD_OFFSET >= 0L && FILE_OUTPUT_STREAM_CLASS.isInstance(outputStream)) {
            WritableByteChannel writableByteChannel = null;
            try {
                writableByteChannel = (WritableByteChannel)UnsafeUtil.getObject(outputStream, CHANNEL_FIELD_OFFSET);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (writableByteChannel != null) {
                writableByteChannel.write(byteBuffer);
                return true;
            }
        }
        return false;
    }

    private static Class<?> safeGetClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static long getChannelFieldOffset(Class<?> clazz) {
        try {
            if (clazz != null && UnsafeUtil.hasUnsafeArrayOperations()) {
                Field field = clazz.getDeclaredField("channel");
                return UnsafeUtil.objectFieldOffset(field);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }
}

