/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.AbstractMessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.Android;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteOutput;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedOutputStreamWriter;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.LazyFieldLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.Schema;
import com.contrastsecurity.thirdparty.com.google.protobuf.UnsafeUtil;
import com.contrastsecurity.thirdparty.com.google.protobuf.Utf8;
import com.contrastsecurity.thirdparty.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    CodedOutputStreamWriter wrapper;
    @Deprecated
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private boolean serializationDeterministic;

    static int computePreferredBufferSize(int n2) {
        if (n2 > 4096) {
            return 4096;
        }
        return n2;
    }

    public static CodedOutputStream newInstance(OutputStream outputStream) {
        return CodedOutputStream.newInstance(outputStream, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n2) {
        return new OutputStreamEncoder(outputStream, n2);
    }

    public static CodedOutputStream newInstance(byte[] byArray) {
        return CodedOutputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStream newInstance(byte[] byArray, int n2, int n3) {
        return new ArrayEncoder(byArray, n2, n3);
    }

    public static CodedOutputStream newInstance(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new HeapNioEncoder(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            return UnsafeDirectNioEncoder.isSupported() ? CodedOutputStream.newUnsafeInstance(byteBuffer) : CodedOutputStream.newSafeInstance(byteBuffer);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    static CodedOutputStream newUnsafeInstance(ByteBuffer byteBuffer) {
        return new UnsafeDirectNioEncoder(byteBuffer);
    }

    static CodedOutputStream newSafeInstance(ByteBuffer byteBuffer) {
        return new SafeDirectNioEncoder(byteBuffer);
    }

    public void useDeterministicSerialization() {
        this.serializationDeterministic = true;
    }

    boolean isSerializationDeterministic() {
        return this.serializationDeterministic;
    }

    @Deprecated
    public static CodedOutputStream newInstance(ByteBuffer byteBuffer, int n2) {
        return CodedOutputStream.newInstance(byteBuffer);
    }

    static CodedOutputStream newInstance(ByteOutput byteOutput, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        return new ByteOutputEncoder(byteOutput, n2);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    public final void writeSInt32(int n2, int n3) throws IOException {
        this.writeUInt32(n2, CodedOutputStream.encodeZigZag32(n3));
    }

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public final void writeSFixed32(int n2, int n3) throws IOException {
        this.writeFixed32(n2, n3);
    }

    public final void writeInt64(int n2, long l2) throws IOException {
        this.writeUInt64(n2, l2);
    }

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    public final void writeSInt64(int n2, long l2) throws IOException {
        this.writeUInt64(n2, CodedOutputStream.encodeZigZag64(l2));
    }

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    public final void writeSFixed64(int n2, long l2) throws IOException {
        this.writeFixed64(n2, l2);
    }

    public final void writeFloat(int n2, float f2) throws IOException {
        this.writeFixed32(n2, Float.floatToRawIntBits(f2));
    }

    public final void writeDouble(int n2, double d2) throws IOException {
        this.writeFixed64(n2, Double.doubleToRawLongBits(d2));
    }

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    public final void writeEnum(int n2, int n3) throws IOException {
        this.writeInt32(n2, n3);
    }

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract void writeByteBuffer(int var1, ByteBuffer var2) throws IOException;

    public final void writeRawByte(byte by2) throws IOException {
        this.write(by2);
    }

    public final void writeRawByte(int n2) throws IOException {
        this.write((byte)n2);
    }

    public final void writeRawBytes(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void writeRawBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.write(byArray, n2, n3);
    }

    public final void writeRawBytes(ByteString byteString) throws IOException {
        byteString.writeTo(this);
    }

    public abstract void writeRawBytes(ByteBuffer var1) throws IOException;

    public abstract void writeMessage(int var1, MessageLite var2) throws IOException;

    abstract void writeMessage(int var1, MessageLite var2, Schema var3) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    public final void writeSInt32NoTag(int n2) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(n2));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public final void writeSFixed32NoTag(int n2) throws IOException {
        this.writeFixed32NoTag(n2);
    }

    public final void writeInt64NoTag(long l2) throws IOException {
        this.writeUInt64NoTag(l2);
    }

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    public final void writeSInt64NoTag(long l2) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(l2));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    public final void writeSFixed64NoTag(long l2) throws IOException {
        this.writeFixed64NoTag(l2);
    }

    public final void writeFloatNoTag(float f2) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(f2));
    }

    public final void writeDoubleNoTag(double d2) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(d2));
    }

    public final void writeBoolNoTag(boolean bl2) throws IOException {
        this.write((byte)(bl2 ? 1 : 0));
    }

    public final void writeEnumNoTag(int n2) throws IOException {
        this.writeInt32NoTag(n2);
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    public final void writeByteArrayNoTag(byte[] byArray) throws IOException {
        this.writeByteArrayNoTag(byArray, 0, byArray.length);
    }

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    abstract void writeMessageNoTag(MessageLite var1, Schema var2) throws IOException;

    @Override
    public abstract void write(byte var1) throws IOException;

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(ByteBuffer var1) throws IOException;

    @Override
    public abstract void writeLazy(ByteBuffer var1) throws IOException;

    public static int computeInt32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeInt32SizeNoTag(n3);
    }

    public static int computeUInt32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeUInt32SizeNoTag(n3);
    }

    public static int computeSInt32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSInt32SizeNoTag(n3);
    }

    public static int computeFixed32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeFixed32SizeNoTag(n3);
    }

    public static int computeSFixed32Size(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSFixed32SizeNoTag(n3);
    }

    public static int computeInt64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeInt64SizeNoTag(l2);
    }

    public static int computeUInt64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeUInt64SizeNoTag(l2);
    }

    public static int computeSInt64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSInt64SizeNoTag(l2);
    }

    public static int computeFixed64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeFixed64SizeNoTag(l2);
    }

    public static int computeSFixed64Size(int n2, long l2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeSFixed64SizeNoTag(l2);
    }

    public static int computeFloatSize(int n2, float f2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeFloatSizeNoTag(f2);
    }

    public static int computeDoubleSize(int n2, double d2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeDoubleSizeNoTag(d2);
    }

    public static int computeBoolSize(int n2, boolean bl2) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeBoolSizeNoTag(bl2);
    }

    public static int computeEnumSize(int n2, int n3) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeEnumSizeNoTag(n3);
    }

    public static int computeStringSize(int n2, String string) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeStringSizeNoTag(string);
    }

    public static int computeBytesSize(int n2, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeByteArraySize(int n2, byte[] byArray) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeByteArraySizeNoTag(byArray);
    }

    public static int computeByteBufferSize(int n2, ByteBuffer byteBuffer) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeByteBufferSizeNoTag(byteBuffer);
    }

    public static int computeLazyFieldSize(int n2, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeLazyFieldSizeNoTag(lazyFieldLite);
    }

    public static int computeMessageSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    static int computeMessageSize(int n2, MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeMessageSizeNoTag(messageLite, schema);
    }

    public static int computeMessageSetExtensionSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n2) + CodedOutputStream.computeMessageSize(3, messageLite);
    }

    public static int computeRawMessageSetExtensionSize(int n2, ByteString byteString) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n2) + CodedOutputStream.computeBytesSize(3, byteString);
    }

    public static int computeLazyFieldMessageSetExtensionSize(int n2, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n2) + CodedOutputStream.computeLazyFieldSize(3, lazyFieldLite);
    }

    public static int computeTagSize(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(n2, 0));
    }

    public static int computeInt32SizeNoTag(int n2) {
        if (n2 >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(n2);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(n2));
    }

    public static int computeFixed32SizeNoTag(int n2) {
        return 4;
    }

    public static int computeSFixed32SizeNoTag(int n2) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeUInt64SizeNoTag(l2);
    }

    public static int computeUInt64SizeNoTag(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l2 < 0L) {
            return 10;
        }
        int n2 = 2;
        if ((l2 & 0xFFFFFFF800000000L) != 0L) {
            n2 += 4;
            l2 >>>= 28;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n2 += 2;
            l2 >>>= 14;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n2;
        }
        return n2;
    }

    public static int computeSInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(l2));
    }

    public static int computeFixed64SizeNoTag(long l2) {
        return 8;
    }

    public static int computeSFixed64SizeNoTag(long l2) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f2) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double d2) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean bl2) {
        return 1;
    }

    public static int computeEnumSizeNoTag(int n2) {
        return CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeStringSizeNoTag(String string) {
        int n2;
        try {
            n2 = Utf8.encodedLength(string);
        }
        catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
            byte[] byArray = string.getBytes(Internal.UTF_8);
            n2 = byArray.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(n2);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(lazyFieldLite.getSerializedSize());
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteString.size());
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byArray.length);
    }

    public static int computeByteBufferSizeNoTag(ByteBuffer byteBuffer) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteBuffer.capacity());
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(messageLite.getSerializedSize());
    }

    static int computeMessageSizeNoTag(MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(((AbstractMessageLite)messageLite).getSerializedSize(schema));
    }

    static int computeLengthDelimitedFieldSize(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(n2) + n2;
    }

    public static int encodeZigZag32(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    public static long encodeZigZag64(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int spaceLeft();

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public abstract int getTotalBytesWritten();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    final void inefficientWriteStringNoTag(String string, Utf8.UnpairedSurrogateException unpairedSurrogateException) throws IOException {
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", unpairedSurrogateException);
        byte[] byArray = string.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(byArray.length);
            this.writeLazy(byArray, 0, byArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfSpaceException(indexOutOfBoundsException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw outOfSpaceException;
        }
    }

    @Deprecated
    public final void writeGroup(int n2, MessageLite messageLite) throws IOException {
        this.writeTag(n2, 3);
        this.writeGroupNoTag(messageLite);
        this.writeTag(n2, 4);
    }

    @Deprecated
    final void writeGroup(int n2, MessageLite messageLite, Schema schema) throws IOException {
        this.writeTag(n2, 3);
        this.writeGroupNoTag(messageLite, schema);
        this.writeTag(n2, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite messageLite) throws IOException {
        messageLite.writeTo(this);
    }

    @Deprecated
    final void writeGroupNoTag(MessageLite messageLite, Schema schema) throws IOException {
        schema.writeTo(messageLite, this.wrapper);
    }

    @Deprecated
    public static int computeGroupSize(int n2, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n2) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    @Deprecated
    static int computeGroupSize(int n2, MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeTagSize(n2) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite, schema);
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    @Deprecated
    static int computeGroupSizeNoTag(MessageLite messageLite, Schema schema) {
        return ((AbstractMessageLite)messageLite).getSerializedSize(schema);
    }

    @Deprecated
    public final void writeRawVarint32(int n2) throws IOException {
        this.writeUInt32NoTag(n2);
    }

    @Deprecated
    public final void writeRawVarint64(long l2) throws IOException {
        this.writeUInt64NoTag(l2);
    }

    @Deprecated
    public static int computeRawVarint32Size(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(n2);
    }

    @Deprecated
    public static int computeRawVarint64Size(long l2) {
        return CodedOutputStream.computeUInt64SizeNoTag(l2);
    }

    @Deprecated
    public final void writeRawLittleEndian32(int n2) throws IOException {
        this.writeFixed32NoTag(n2);
    }

    @Deprecated
    public final void writeRawLittleEndian64(long l2) throws IOException {
        this.writeFixed64NoTag(l2);
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private final OutputStream out;

        OutputStreamEncoder(OutputStream outputStream, int n2) {
            super(n2);
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            this.out = outputStream;
        }

        @Override
        public void writeTag(int n2, int n3) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n2, n3));
        }

        @Override
        public void writeInt32(int n2, int n3) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n2, 0);
            this.bufferInt32NoTag(n3);
        }

        @Override
        public void writeUInt32(int n2, int n3) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n2, 0);
            this.bufferUInt32NoTag(n3);
        }

        @Override
        public void writeFixed32(int n2, int n3) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(n2, 5);
            this.bufferFixed32NoTag(n3);
        }

        @Override
        public void writeUInt64(int n2, long l2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n2, 0);
            this.bufferUInt64NoTag(l2);
        }

        @Override
        public void writeFixed64(int n2, long l2) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(n2, 1);
            this.bufferFixed64NoTag(l2);
        }

        @Override
        public void writeBool(int n2, boolean bl2) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(n2, 0);
            this.buffer((byte)(bl2 ? 1 : 0));
        }

        @Override
        public void writeString(int n2, String string) throws IOException {
            this.writeTag(n2, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) throws IOException {
            this.writeTag(n2, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray) throws IOException {
            this.writeByteArray(n2, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray, int n3, int n4) throws IOException {
            this.writeTag(n2, 2);
            this.writeByteArrayNoTag(byArray, n3, n4);
        }

        @Override
        public void writeByteBuffer(int n2, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n2, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n2, int n3) throws IOException {
            this.writeUInt32NoTag(n3);
            this.write(byArray, n2, n3);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeMessage(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n2, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n2, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by2) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(by2);
        }

        @Override
        public void writeInt32NoTag(int n2) throws IOException {
            if (n2 >= 0) {
                this.writeUInt32NoTag(n2);
            } else {
                this.writeUInt64NoTag(n2);
            }
        }

        @Override
        public void writeUInt32NoTag(int n2) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(n2);
        }

        @Override
        public void writeFixed32NoTag(int n2) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(n2);
        }

        @Override
        public void writeUInt64NoTag(long l2) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(l2);
        }

        @Override
        public void writeFixed64NoTag(long l2) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(l2);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            try {
                int n2 = string.length() * 3;
                int n3 = OutputStreamEncoder.computeUInt32SizeNoTag(n2);
                if (n3 + n2 > this.limit) {
                    byte[] byArray = new byte[n2];
                    int n4 = Utf8.encode(string, byArray, 0, n2);
                    this.writeUInt32NoTag(n4);
                    this.writeLazy(byArray, 0, n4);
                    return;
                }
                if (n3 + n2 > this.limit - this.position) {
                    this.doFlush();
                }
                int n5 = OutputStreamEncoder.computeUInt32SizeNoTag(string.length());
                int n6 = this.position;
                try {
                    int n7;
                    if (n5 == n3) {
                        this.position = n6 + n5;
                        int n8 = Utf8.encode(string, this.buffer, this.position, this.limit - this.position);
                        this.position = n6;
                        n7 = n8 - n6 - n5;
                        this.bufferUInt32NoTag(n7);
                        this.position = n8;
                    } else {
                        n7 = Utf8.encodedLength(string);
                        this.bufferUInt32NoTag(n7);
                        this.position = Utf8.encode(string, this.buffer, this.position, n7);
                    }
                    this.totalBytesWritten += n7;
                }
                catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                    this.totalBytesWritten -= this.position - n6;
                    this.position = n6;
                    throw unpairedSurrogateException;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new OutOfSpaceException(arrayIndexOutOfBoundsException);
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.limit - this.position >= n3) {
                System.arraycopy(byArray, n2, this.buffer, this.position, n3);
                this.position += n3;
                this.totalBytesWritten += n3;
            } else {
                int n4 = this.limit - this.position;
                System.arraycopy(byArray, n2, this.buffer, this.position, n4);
                n2 += n4;
                this.position = this.limit;
                this.totalBytesWritten += n4;
                this.doFlush();
                if ((n3 -= n4) <= this.limit) {
                    System.arraycopy(byArray, n2, this.buffer, 0, n3);
                    this.position = n3;
                } else {
                    this.out.write(byArray, n2, n3);
                }
                this.totalBytesWritten += n3;
            }
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) throws IOException {
            this.write(byArray, n2, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            int n2 = byteBuffer.remaining();
            if (this.limit - this.position >= n2) {
                byteBuffer.get(this.buffer, this.position, n2);
                this.position += n2;
                this.totalBytesWritten += n2;
            } else {
                int n3 = this.limit - this.position;
                byteBuffer.get(this.buffer, this.position, n3);
                n2 -= n3;
                this.position = this.limit;
                this.totalBytesWritten += n3;
                this.doFlush();
                while (n2 > this.limit) {
                    byteBuffer.get(this.buffer, 0, this.limit);
                    this.out.write(this.buffer, 0, this.limit);
                    n2 -= this.limit;
                    this.totalBytesWritten += this.limit;
                }
                byteBuffer.get(this.buffer, 0, n2);
                this.position = n2;
                this.totalBytesWritten += n2;
            }
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        private void flushIfNotAvailable(int n2) throws IOException {
            if (this.limit - this.position < n2) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static final class ByteOutputEncoder
    extends AbstractBufferedEncoder {
        private final ByteOutput out;

        ByteOutputEncoder(ByteOutput byteOutput, int n2) {
            super(n2);
            if (byteOutput == null) {
                throw new NullPointerException("out");
            }
            this.out = byteOutput;
        }

        @Override
        public void writeTag(int n2, int n3) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n2, n3));
        }

        @Override
        public void writeInt32(int n2, int n3) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n2, 0);
            this.bufferInt32NoTag(n3);
        }

        @Override
        public void writeUInt32(int n2, int n3) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n2, 0);
            this.bufferUInt32NoTag(n3);
        }

        @Override
        public void writeFixed32(int n2, int n3) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(n2, 5);
            this.bufferFixed32NoTag(n3);
        }

        @Override
        public void writeUInt64(int n2, long l2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n2, 0);
            this.bufferUInt64NoTag(l2);
        }

        @Override
        public void writeFixed64(int n2, long l2) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(n2, 1);
            this.bufferFixed64NoTag(l2);
        }

        @Override
        public void writeBool(int n2, boolean bl2) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(n2, 0);
            this.buffer((byte)(bl2 ? 1 : 0));
        }

        @Override
        public void writeString(int n2, String string) throws IOException {
            this.writeTag(n2, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) throws IOException {
            this.writeTag(n2, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray) throws IOException {
            this.writeByteArray(n2, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray, int n3, int n4) throws IOException {
            this.writeTag(n2, 2);
            this.writeByteArrayNoTag(byArray, n3, n4);
        }

        @Override
        public void writeByteBuffer(int n2, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n2, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n2, int n3) throws IOException {
            this.writeUInt32NoTag(n3);
            this.write(byArray, n2, n3);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeMessage(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n2, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n2, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by2) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(by2);
        }

        @Override
        public void writeInt32NoTag(int n2) throws IOException {
            if (n2 >= 0) {
                this.writeUInt32NoTag(n2);
            } else {
                this.writeUInt64NoTag(n2);
            }
        }

        @Override
        public void writeUInt32NoTag(int n2) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(n2);
        }

        @Override
        public void writeFixed32NoTag(int n2) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(n2);
        }

        @Override
        public void writeUInt64NoTag(long l2) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(l2);
        }

        @Override
        public void writeFixed64NoTag(long l2) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(l2);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            int n2 = string.length() * 3;
            int n3 = ByteOutputEncoder.computeUInt32SizeNoTag(n2);
            if (n3 + n2 > this.limit) {
                byte[] byArray = new byte[n2];
                int n4 = Utf8.encode(string, byArray, 0, n2);
                this.writeUInt32NoTag(n4);
                this.writeLazy(byArray, 0, n4);
                return;
            }
            if (n3 + n2 > this.limit - this.position) {
                this.doFlush();
            }
            int n5 = this.position;
            try {
                int n6 = ByteOutputEncoder.computeUInt32SizeNoTag(string.length());
                if (n6 == n3) {
                    this.position = n5 + n6;
                    int n7 = Utf8.encode(string, this.buffer, this.position, this.limit - this.position);
                    this.position = n5;
                    int n8 = n7 - n5 - n6;
                    this.bufferUInt32NoTag(n8);
                    this.position = n7;
                    this.totalBytesWritten += n8;
                } else {
                    int n9 = Utf8.encodedLength(string);
                    this.bufferUInt32NoTag(n9);
                    this.position = Utf8.encode(string, this.buffer, this.position, n9);
                    this.totalBytesWritten += n9;
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.totalBytesWritten -= this.position - n5;
                this.position = n5;
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.flush();
            this.out.write(byArray, n2, n3);
            this.totalBytesWritten += n3;
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) throws IOException {
            this.flush();
            this.out.writeLazy(byArray, n2, n3);
            this.totalBytesWritten += n3;
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            this.flush();
            int n2 = byteBuffer.remaining();
            this.out.write(byteBuffer);
            this.totalBytesWritten += n2;
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.flush();
            int n2 = byteBuffer.remaining();
            this.out.writeLazy(byteBuffer);
            this.totalBytesWritten += n2;
        }

        private void flushIfNotAvailable(int n2) throws IOException {
            if (this.limit - this.position < n2) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("bufferSize must be >= 0");
            }
            this.buffer = new byte[Math.max(n2, 20)];
            this.limit = this.buffer.length;
        }

        @Override
        public final int spaceLeft() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalBytesWritten;
        }

        final void buffer(byte by2) {
            this.buffer[this.position++] = by2;
            ++this.totalBytesWritten;
        }

        final void bufferTag(int n2, int n3) {
            this.bufferUInt32NoTag(WireFormat.makeTag(n2, n3));
        }

        final void bufferInt32NoTag(int n2) {
            if (n2 >= 0) {
                this.bufferUInt32NoTag(n2);
            } else {
                this.bufferUInt64NoTag(n2);
            }
        }

        final void bufferUInt32NoTag(int n2) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long l2 = this.position;
                while (true) {
                    if ((n2 & 0xFFFFFF80) == 0) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n2 & 0x7F | 0x80));
                    n2 >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n2);
                int n3 = (int)((long)this.position - l2);
                this.totalBytesWritten += n3;
            } else {
                while (true) {
                    if ((n2 & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n2;
                        ++this.totalBytesWritten;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
                    ++this.totalBytesWritten;
                    n2 >>>= 7;
                }
            }
        }

        final void bufferUInt64NoTag(long l2) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long l3 = this.position;
                while (true) {
                    if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)l2 & 0x7F | 0x80));
                    l2 >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)l2);
                int n2 = (int)((long)this.position - l3);
                this.totalBytesWritten += n2;
            } else {
                while (true) {
                    if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l2;
                        ++this.totalBytesWritten;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l2 & 0x7F | 0x80);
                    ++this.totalBytesWritten;
                    l2 >>>= 7;
                }
            }
        }

        final void bufferFixed32NoTag(int n2) {
            this.buffer[this.position++] = (byte)(n2 & 0xFF);
            this.buffer[this.position++] = (byte)(n2 >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(n2 >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(n2 >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long l2) {
            this.buffer[this.position++] = (byte)(l2 & 0xFFL);
            this.buffer[this.position++] = (byte)(l2 >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(l2 >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(l2 >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(l2 >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l2 >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l2 >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l2 >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }

    private static final class UnsafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final long address;
        private final long initialPosition;
        private final long limit;
        private final long oneVarintLimit;
        private long position;

        UnsafeDirectNioEncoder(ByteBuffer byteBuffer) {
            this.originalBuffer = byteBuffer;
            this.buffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.address = UnsafeUtil.addressOffset(byteBuffer);
            this.initialPosition = this.address + (long)byteBuffer.position();
            this.limit = this.address + (long)byteBuffer.limit();
            this.oneVarintLimit = this.limit - 10L;
            this.position = this.initialPosition;
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        public void writeTag(int n2, int n3) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n2, n3));
        }

        @Override
        public void writeInt32(int n2, int n3) throws IOException {
            this.writeTag(n2, 0);
            this.writeInt32NoTag(n3);
        }

        @Override
        public void writeUInt32(int n2, int n3) throws IOException {
            this.writeTag(n2, 0);
            this.writeUInt32NoTag(n3);
        }

        @Override
        public void writeFixed32(int n2, int n3) throws IOException {
            this.writeTag(n2, 5);
            this.writeFixed32NoTag(n3);
        }

        @Override
        public void writeUInt64(int n2, long l2) throws IOException {
            this.writeTag(n2, 0);
            this.writeUInt64NoTag(l2);
        }

        @Override
        public void writeFixed64(int n2, long l2) throws IOException {
            this.writeTag(n2, 1);
            this.writeFixed64NoTag(l2);
        }

        @Override
        public void writeBool(int n2, boolean bl2) throws IOException {
            this.writeTag(n2, 0);
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        public void writeString(int n2, String string) throws IOException {
            this.writeTag(n2, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) throws IOException {
            this.writeTag(n2, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray) throws IOException {
            this.writeByteArray(n2, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray, int n3, int n4) throws IOException {
            this.writeTag(n2, 2);
            this.writeByteArrayNoTag(byArray, n3, n4);
        }

        @Override
        public void writeByteBuffer(int n2, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n2, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeMessage(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n2, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n2, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by2) throws IOException {
            if (this.position >= this.limit) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
            }
            UnsafeUtil.putByte(this.position++, by2);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n2, int n3) throws IOException {
            this.writeUInt32NoTag(n3);
            this.write(byArray, n2, n3);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeInt32NoTag(int n2) throws IOException {
            if (n2 >= 0) {
                this.writeUInt32NoTag(n2);
            } else {
                this.writeUInt64NoTag(n2);
            }
        }

        @Override
        public void writeUInt32NoTag(int n2) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((n2 & 0xFFFFFF80) == 0) {
                        UnsafeUtil.putByte(this.position++, (byte)n2);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)(n2 & 0x7F | 0x80));
                    n2 >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((n2 & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.position++, (byte)n2);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)(n2 & 0x7F | 0x80));
                n2 >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        @Override
        public void writeFixed32NoTag(int n2) throws IOException {
            this.buffer.putInt(this.bufferPos(this.position), n2);
            this.position += 4L;
        }

        @Override
        public void writeUInt64NoTag(long l2) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.position++, (byte)l2);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)((int)l2 & 0x7F | 0x80));
                    l2 >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    UnsafeUtil.putByte(this.position++, (byte)l2);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)((int)l2 & 0x7F | 0x80));
                l2 >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        @Override
        public void writeFixed64NoTag(long l2) throws IOException {
            this.buffer.putLong(this.bufferPos(this.position), l2);
            this.position += 8L;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (byArray == null || n2 < 0 || n3 < 0 || byArray.length - n3 < n2 || this.limit - (long)n3 < this.position) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n3));
            }
            UnsafeUtil.copyMemory(byArray, n2, this.position, (long)n3);
            this.position += (long)n3;
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) throws IOException {
            this.write(byArray, n2, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            try {
                int n2 = byteBuffer.remaining();
                this.repositionBuffer(this.position);
                this.buffer.put(byteBuffer);
                this.position += (long)n2;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            long l2 = this.position;
            try {
                int n2 = string.length() * 3;
                int n3 = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(n2);
                int n4 = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(string.length());
                if (n4 == n3) {
                    int n5 = this.bufferPos(this.position) + n4;
                    this.buffer.position(n5);
                    Utf8.encodeUtf8(string, this.buffer);
                    int n6 = this.buffer.position() - n5;
                    this.writeUInt32NoTag(n6);
                    this.position += (long)n6;
                } else {
                    int n7 = Utf8.encodedLength(string);
                    this.writeUInt32NoTag(n7);
                    this.repositionBuffer(this.position);
                    Utf8.encodeUtf8(string, this.buffer);
                    this.position += (long)n7;
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.position = l2;
                this.repositionBuffer(this.position);
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OutOfSpaceException(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
            this.originalBuffer.position(this.bufferPos(this.position));
        }

        @Override
        public int spaceLeft() {
            return (int)(this.limit - this.position);
        }

        @Override
        public int getTotalBytesWritten() {
            return (int)(this.position - this.initialPosition);
        }

        private void repositionBuffer(long l2) {
            this.buffer.position(this.bufferPos(l2));
        }

        private int bufferPos(long l2) {
            return (int)(l2 - this.address);
        }
    }

    private static final class SafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final int initialPosition;

        SafeDirectNioEncoder(ByteBuffer byteBuffer) {
            this.originalBuffer = byteBuffer;
            this.buffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.initialPosition = byteBuffer.position();
        }

        @Override
        public void writeTag(int n2, int n3) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n2, n3));
        }

        @Override
        public void writeInt32(int n2, int n3) throws IOException {
            this.writeTag(n2, 0);
            this.writeInt32NoTag(n3);
        }

        @Override
        public void writeUInt32(int n2, int n3) throws IOException {
            this.writeTag(n2, 0);
            this.writeUInt32NoTag(n3);
        }

        @Override
        public void writeFixed32(int n2, int n3) throws IOException {
            this.writeTag(n2, 5);
            this.writeFixed32NoTag(n3);
        }

        @Override
        public void writeUInt64(int n2, long l2) throws IOException {
            this.writeTag(n2, 0);
            this.writeUInt64NoTag(l2);
        }

        @Override
        public void writeFixed64(int n2, long l2) throws IOException {
            this.writeTag(n2, 1);
            this.writeFixed64NoTag(l2);
        }

        @Override
        public void writeBool(int n2, boolean bl2) throws IOException {
            this.writeTag(n2, 0);
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        public void writeString(int n2, String string) throws IOException {
            this.writeTag(n2, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n2, ByteString byteString) throws IOException {
            this.writeTag(n2, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray) throws IOException {
            this.writeByteArray(n2, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n2, byte[] byArray, int n3, int n4) throws IOException {
            this.writeTag(n2, 2);
            this.writeByteArrayNoTag(byArray, n3, n4);
        }

        @Override
        public void writeByteBuffer(int n2, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n2, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeMessage(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n2, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n2, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by2) throws IOException {
            try {
                this.buffer.put(by2);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n2, int n3) throws IOException {
            this.writeUInt32NoTag(n3);
            this.write(byArray, n2, n3);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeInt32NoTag(int n2) throws IOException {
            if (n2 >= 0) {
                this.writeUInt32NoTag(n2);
            } else {
                this.writeUInt64NoTag(n2);
            }
        }

        @Override
        public void writeUInt32NoTag(int n2) throws IOException {
            try {
                while (true) {
                    if ((n2 & 0xFFFFFF80) == 0) {
                        this.buffer.put((byte)n2);
                        return;
                    }
                    this.buffer.put((byte)(n2 & 0x7F | 0x80));
                    n2 >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeFixed32NoTag(int n2) throws IOException {
            try {
                this.buffer.putInt(n2);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeUInt64NoTag(long l2) throws IOException {
            try {
                while (true) {
                    if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer.put((byte)l2);
                        return;
                    }
                    this.buffer.put((byte)((int)l2 & 0x7F | 0x80));
                    l2 >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeFixed64NoTag(long l2) throws IOException {
            try {
                this.buffer.putLong(l2);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            try {
                this.buffer.put(byArray, n2, n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeLazy(byte[] byArray, int n2, int n3) throws IOException {
            this.write(byArray, n2, n3);
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            try {
                this.buffer.put(byteBuffer);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            int n2 = this.buffer.position();
            try {
                int n3 = string.length() * 3;
                int n4 = SafeDirectNioEncoder.computeUInt32SizeNoTag(n3);
                int n5 = SafeDirectNioEncoder.computeUInt32SizeNoTag(string.length());
                if (n5 == n4) {
                    int n6 = this.buffer.position() + n5;
                    this.buffer.position(n6);
                    this.encode(string);
                    int n7 = this.buffer.position();
                    this.buffer.position(n2);
                    this.writeUInt32NoTag(n7 - n6);
                    this.buffer.position(n7);
                } else {
                    int n8 = Utf8.encodedLength(string);
                    this.writeUInt32NoTag(n8);
                    this.encode(string);
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.buffer.position(n2);
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OutOfSpaceException(illegalArgumentException);
            }
        }

        @Override
        public void flush() {
            this.originalBuffer.position(this.buffer.position());
        }

        @Override
        public int spaceLeft() {
            return this.buffer.remaining();
        }

        @Override
        public int getTotalBytesWritten() {
            return this.buffer.position() - this.initialPosition;
        }

        private void encode(String string) throws IOException {
            try {
                Utf8.encodeUtf8(string, this.buffer);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }
    }

    private static final class HeapNioEncoder
    extends ArrayEncoder {
        private final ByteBuffer byteBuffer;
        private int initialPosition;

        HeapNioEncoder(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.byteBuffer = byteBuffer;
            this.initialPosition = byteBuffer.position();
        }

        @Override
        public void flush() {
            this.byteBuffer.position(this.initialPosition + this.getTotalBytesWritten());
        }
    }

    private static class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        ArrayEncoder(byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n2 | n3 | byArray.length - (n2 + n3)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n2, n3));
            }
            this.buffer = byArray;
            this.offset = n2;
            this.position = n2;
            this.limit = n2 + n3;
        }

        @Override
        public final void writeTag(int n2, int n3) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n2, n3));
        }

        @Override
        public final void writeInt32(int n2, int n3) throws IOException {
            this.writeTag(n2, 0);
            this.writeInt32NoTag(n3);
        }

        @Override
        public final void writeUInt32(int n2, int n3) throws IOException {
            this.writeTag(n2, 0);
            this.writeUInt32NoTag(n3);
        }

        @Override
        public final void writeFixed32(int n2, int n3) throws IOException {
            this.writeTag(n2, 5);
            this.writeFixed32NoTag(n3);
        }

        @Override
        public final void writeUInt64(int n2, long l2) throws IOException {
            this.writeTag(n2, 0);
            this.writeUInt64NoTag(l2);
        }

        @Override
        public final void writeFixed64(int n2, long l2) throws IOException {
            this.writeTag(n2, 1);
            this.writeFixed64NoTag(l2);
        }

        @Override
        public final void writeBool(int n2, boolean bl2) throws IOException {
            this.writeTag(n2, 0);
            this.write((byte)(bl2 ? 1 : 0));
        }

        @Override
        public final void writeString(int n2, String string) throws IOException {
            this.writeTag(n2, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public final void writeBytes(int n2, ByteString byteString) throws IOException {
            this.writeTag(n2, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public final void writeByteArray(int n2, byte[] byArray) throws IOException {
            this.writeByteArray(n2, byArray, 0, byArray.length);
        }

        @Override
        public final void writeByteArray(int n2, byte[] byArray, int n3, int n4) throws IOException {
            this.writeTag(n2, 2);
            this.writeByteArrayNoTag(byArray, n3, n4);
        }

        @Override
        public final void writeByteBuffer(int n2, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n2, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public final void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public final void writeByteArrayNoTag(byte[] byArray, int n2, int n3) throws IOException {
            this.writeUInt32NoTag(n3);
            this.write(byArray, n2, n3);
        }

        @Override
        public final void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public final void writeMessage(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(n2, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        final void writeMessage(int n2, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n2, 2);
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public final void writeMessageSetExtension(int n2, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeRawMessageSetExtension(int n2, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n2);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        final void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public final void write(byte by2) throws IOException {
            try {
                this.buffer[this.position++] = by2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeInt32NoTag(int n2) throws IOException {
            if (n2 >= 0) {
                this.writeUInt32NoTag(n2);
            } else {
                this.writeUInt64NoTag(n2);
            }
        }

        @Override
        public final void writeUInt32NoTag(int n2) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && !Android.isOnAndroidDevice() && this.spaceLeft() >= 5) {
                if ((n2 & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n2);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n2 | 0x80));
                if (((n2 >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n2);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n2 | 0x80));
                if (((n2 >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n2);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n2 | 0x80));
                if (((n2 >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n2);
                    return;
                }
            } else {
                try {
                    while (true) {
                        if ((n2 & 0xFFFFFF80) == 0) {
                            this.buffer[this.position++] = (byte)n2;
                            return;
                        }
                        this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
                        n2 >>>= 7;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
                }
            }
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n2 | 0x80));
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n2 >>>= 7));
        }

        @Override
        public final void writeFixed32NoTag(int n2) throws IOException {
            try {
                this.buffer[this.position++] = (byte)(n2 & 0xFF);
                this.buffer[this.position++] = (byte)(n2 >> 8 & 0xFF);
                this.buffer[this.position++] = (byte)(n2 >> 16 & 0xFF);
                this.buffer[this.position++] = (byte)(n2 >> 24 & 0xFF);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeUInt64NoTag(long l2) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && this.spaceLeft() >= 10) {
                while (true) {
                    if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)l2);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)l2 & 0x7F | 0x80));
                    l2 >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l2;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l2 & 0x7F | 0x80);
                    l2 >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeFixed64NoTag(long l2) throws IOException {
            try {
                this.buffer[this.position++] = (byte)((int)l2 & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 8) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 16) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 24) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 32) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 40) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 48) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l2 >> 56) & 0xFF);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n2, int n3) throws IOException {
            try {
                System.arraycopy(byArray, n2, this.buffer, this.position, n3);
                this.position += n3;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n3), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeLazy(byte[] byArray, int n2, int n3) throws IOException {
            this.write(byArray, n2, n3);
        }

        @Override
        public final void write(ByteBuffer byteBuffer) throws IOException {
            int n2 = byteBuffer.remaining();
            try {
                byteBuffer.get(this.buffer, this.position, n2);
                this.position += n2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public final void writeStringNoTag(String string) throws IOException {
            int n2 = this.position;
            try {
                int n3 = string.length() * 3;
                int n4 = ArrayEncoder.computeUInt32SizeNoTag(n3);
                int n5 = ArrayEncoder.computeUInt32SizeNoTag(string.length());
                if (n5 == n4) {
                    this.position = n2 + n5;
                    int n6 = Utf8.encode(string, this.buffer, this.position, this.spaceLeft());
                    this.position = n2;
                    int n7 = n6 - n2 - n5;
                    this.writeUInt32NoTag(n7);
                    this.position = n6;
                } else {
                    int n8 = Utf8.encodedLength(string);
                    this.writeUInt32NoTag(n8);
                    this.position = Utf8.encode(string, this.buffer, this.position, this.spaceLeft());
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.position = n2;
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.position - this.offset;
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;
        private static final String MESSAGE = "CodedOutputStream was writing to a flat byte array and ran out of space.";

        OutOfSpaceException() {
            super(MESSAGE);
        }

        OutOfSpaceException(String string) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + string);
        }

        OutOfSpaceException(Throwable throwable) {
            super(MESSAGE, throwable);
        }

        OutOfSpaceException(String string, Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + string, throwable);
        }
    }
}

