/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.Descriptors;
import com.contrastsecurity.thirdparty.com.google.protobuf.FieldInfo;
import com.contrastsecurity.thirdparty.com.google.protobuf.FieldType;
import com.contrastsecurity.thirdparty.com.google.protobuf.GeneratedMessageV3;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.Message;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageInfo;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageInfoFactory;
import com.contrastsecurity.thirdparty.com.google.protobuf.OneofInfo;
import com.contrastsecurity.thirdparty.com.google.protobuf.ProtoSyntax;
import com.contrastsecurity.thirdparty.com.google.protobuf.SchemaUtil;
import com.contrastsecurity.thirdparty.com.google.protobuf.StructuralMessageInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

final class DescriptorMessageInfoFactory
implements MessageInfoFactory {
    private static final String GET_DEFAULT_INSTANCE_METHOD_NAME = "getDefaultInstance";
    private static final DescriptorMessageInfoFactory instance = new DescriptorMessageInfoFactory();
    private static final Set<String> specialFieldNames = new HashSet<String>(Arrays.asList("cached_size", "serialized_size", "class"));
    private static IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = new IsInitializedCheckAnalyzer();

    private DescriptorMessageInfoFactory() {
    }

    public static DescriptorMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> clazz) {
        return GeneratedMessageV3.class.isAssignableFrom(clazz);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> clazz) {
        if (!GeneratedMessageV3.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unsupported message type: " + clazz.getName());
        }
        return DescriptorMessageInfoFactory.convert(clazz, DescriptorMessageInfoFactory.descriptorForType(clazz));
    }

    private static Message getDefaultInstance(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod(GET_DEFAULT_INSTANCE_METHOD_NAME, new Class[0]);
            return (Message)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to get default instance for message class " + clazz.getName(), exception);
        }
    }

    private static Descriptors.Descriptor descriptorForType(Class<?> clazz) {
        return DescriptorMessageInfoFactory.getDefaultInstance(clazz).getDescriptorForType();
    }

    private static MessageInfo convert(Class<?> clazz, Descriptors.Descriptor descriptor) {
        switch (descriptor.getFile().getSyntax()) {
            case PROTO2: {
                return DescriptorMessageInfoFactory.convertProto2(clazz, descriptor);
            }
            case PROTO3: {
                return DescriptorMessageInfoFactory.convertProto3(clazz, descriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported syntax: " + (Object)((Object)descriptor.getFile().getSyntax()));
    }

    private static boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
        return isInitializedCheckAnalyzer.needsIsInitializedCheck(descriptor);
    }

    private static StructuralMessageInfo convertProto2(Class<?> clazz, Descriptors.Descriptor descriptor) {
        List<Descriptors.FieldDescriptor> list = descriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(list.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(clazz));
        builder.withSyntax(ProtoSyntax.PROTO2);
        builder.withMessageSetWireFormat(descriptor.getOptions().getMessageSetWireFormat());
        OneofState oneofState = new OneofState();
        int n2 = 0;
        int n3 = 1;
        Field field = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            final Descriptors.FieldDescriptor fieldDescriptor = list.get(i2);
            boolean bl2 = fieldDescriptor.getFile().getOptions().getJavaStringCheckUtf8();
            Internal.EnumVerifier enumVerifier = null;
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                enumVerifier = new Internal.EnumVerifier(){

                    @Override
                    public boolean isInRange(int n2) {
                        return fieldDescriptor.getEnumType().findValueByNumber(n2) != null;
                    }
                };
            }
            if (fieldDescriptor.getContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(clazz, fieldDescriptor, oneofState, bl2, enumVerifier));
            } else {
                Field field2 = DescriptorMessageInfoFactory.field(clazz, fieldDescriptor);
                int n4 = fieldDescriptor.getNumber();
                FieldType fieldType = DescriptorMessageInfoFactory.getFieldType(fieldDescriptor);
                if (fieldDescriptor.isMapField()) {
                    final Descriptors.FieldDescriptor fieldDescriptor2 = fieldDescriptor.getMessageType().findFieldByNumber(2);
                    if (fieldDescriptor2.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        enumVerifier = new Internal.EnumVerifier(){

                            @Override
                            public boolean isInRange(int n2) {
                                return fieldDescriptor2.getEnumType().findValueByNumber(n2) != null;
                            }
                        };
                    }
                    builder.withField(FieldInfo.forMapField(field2, n4, SchemaUtil.getMapDefaultEntry(clazz, fieldDescriptor.getName()), enumVerifier));
                    continue;
                }
                if (fieldDescriptor.isRepeated()) {
                    if (enumVerifier != null) {
                        if (fieldDescriptor.isPacked()) {
                            builder.withField(FieldInfo.forPackedFieldWithEnumVerifier(field2, n4, fieldType, enumVerifier, DescriptorMessageInfoFactory.cachedSizeField(clazz, fieldDescriptor)));
                            continue;
                        }
                        builder.withField(FieldInfo.forFieldWithEnumVerifier(field2, n4, fieldType, enumVerifier));
                        continue;
                    }
                    if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        builder.withField(FieldInfo.forRepeatedMessageField(field2, n4, fieldType, DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(clazz, fieldDescriptor)));
                        continue;
                    }
                    if (fieldDescriptor.isPacked()) {
                        builder.withField(FieldInfo.forPackedField(field2, n4, fieldType, DescriptorMessageInfoFactory.cachedSizeField(clazz, fieldDescriptor)));
                        continue;
                    }
                    builder.withField(FieldInfo.forField(field2, n4, fieldType, bl2));
                    continue;
                }
                if (field == null) {
                    field = DescriptorMessageInfoFactory.bitField(clazz, n2);
                }
                if (fieldDescriptor.isRequired()) {
                    builder.withField(FieldInfo.forProto2RequiredField(field2, n4, fieldType, field, n3, bl2, enumVerifier));
                } else {
                    builder.withField(FieldInfo.forProto2OptionalField(field2, n4, fieldType, field, n3, bl2, enumVerifier));
                }
            }
            if ((n3 <<= 1) != 0) continue;
            field = null;
            n3 = 1;
            ++n2;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            Descriptors.FieldDescriptor fieldDescriptor = list.get(i3);
            if (!fieldDescriptor.isRequired() && (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !DescriptorMessageInfoFactory.needsIsInitializedCheck(fieldDescriptor.getMessageType()))) continue;
            arrayList.add(fieldDescriptor.getNumber());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            nArray[i4] = (Integer)arrayList.get(i4);
        }
        builder.withCheckInitialized(nArray);
        return builder.build();
    }

    private static StructuralMessageInfo convertProto3(Class<?> clazz, Descriptors.Descriptor descriptor) {
        List<Descriptors.FieldDescriptor> list = descriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(list.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(clazz));
        builder.withSyntax(ProtoSyntax.PROTO3);
        OneofState oneofState = new OneofState();
        boolean bl2 = true;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Descriptors.FieldDescriptor fieldDescriptor = list.get(i2);
            if (fieldDescriptor.getContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(clazz, fieldDescriptor, oneofState, bl2, null));
                continue;
            }
            if (fieldDescriptor.isMapField()) {
                builder.withField(FieldInfo.forMapField(DescriptorMessageInfoFactory.field(clazz, fieldDescriptor), fieldDescriptor.getNumber(), SchemaUtil.getMapDefaultEntry(clazz, fieldDescriptor.getName()), null));
                continue;
            }
            if (fieldDescriptor.isRepeated() && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                builder.withField(FieldInfo.forRepeatedMessageField(DescriptorMessageInfoFactory.field(clazz, fieldDescriptor), fieldDescriptor.getNumber(), DescriptorMessageInfoFactory.getFieldType(fieldDescriptor), DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(clazz, fieldDescriptor)));
                continue;
            }
            if (fieldDescriptor.isPacked()) {
                builder.withField(FieldInfo.forPackedField(DescriptorMessageInfoFactory.field(clazz, fieldDescriptor), fieldDescriptor.getNumber(), DescriptorMessageInfoFactory.getFieldType(fieldDescriptor), DescriptorMessageInfoFactory.cachedSizeField(clazz, fieldDescriptor)));
                continue;
            }
            builder.withField(FieldInfo.forField(DescriptorMessageInfoFactory.field(clazz, fieldDescriptor), fieldDescriptor.getNumber(), DescriptorMessageInfoFactory.getFieldType(fieldDescriptor), bl2));
        }
        return builder.build();
    }

    private static FieldInfo buildOneofMember(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor, OneofState oneofState, boolean bl2, Internal.EnumVerifier enumVerifier) {
        OneofInfo oneofInfo = oneofState.getOneof(clazz, fieldDescriptor.getContainingOneof());
        FieldType fieldType = DescriptorMessageInfoFactory.getFieldType(fieldDescriptor);
        Class<?> clazz2 = DescriptorMessageInfoFactory.getOneofStoredType(clazz, fieldDescriptor, fieldType);
        return FieldInfo.forOneofMemberField(fieldDescriptor.getNumber(), fieldType, oneofInfo, clazz2, bl2, enumVerifier);
    }

    private static Class<?> getOneofStoredType(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor, FieldType fieldType) {
        switch (fieldType.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case ENUM: 
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case MESSAGE: {
                return DescriptorMessageInfoFactory.getOneofStoredTypeForMessage(clazz, fieldDescriptor);
            }
        }
        throw new IllegalArgumentException("Invalid type for oneof: " + (Object)((Object)fieldType));
    }

    private static FieldType getFieldType(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.BOOL;
                }
                return fieldDescriptor.isPacked() ? FieldType.BOOL_LIST_PACKED : FieldType.BOOL_LIST;
            }
            case BYTES: {
                return fieldDescriptor.isRepeated() ? FieldType.BYTES_LIST : FieldType.BYTES;
            }
            case DOUBLE: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.DOUBLE;
                }
                return fieldDescriptor.isPacked() ? FieldType.DOUBLE_LIST_PACKED : FieldType.DOUBLE_LIST;
            }
            case ENUM: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.ENUM;
                }
                return fieldDescriptor.isPacked() ? FieldType.ENUM_LIST_PACKED : FieldType.ENUM_LIST;
            }
            case FIXED32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.FIXED32;
                }
                return fieldDescriptor.isPacked() ? FieldType.FIXED32_LIST_PACKED : FieldType.FIXED32_LIST;
            }
            case FIXED64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.FIXED64;
                }
                return fieldDescriptor.isPacked() ? FieldType.FIXED64_LIST_PACKED : FieldType.FIXED64_LIST;
            }
            case FLOAT: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.FLOAT;
                }
                return fieldDescriptor.isPacked() ? FieldType.FLOAT_LIST_PACKED : FieldType.FLOAT_LIST;
            }
            case GROUP: {
                return fieldDescriptor.isRepeated() ? FieldType.GROUP_LIST : FieldType.GROUP;
            }
            case INT32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.INT32;
                }
                return fieldDescriptor.isPacked() ? FieldType.INT32_LIST_PACKED : FieldType.INT32_LIST;
            }
            case INT64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.INT64;
                }
                return fieldDescriptor.isPacked() ? FieldType.INT64_LIST_PACKED : FieldType.INT64_LIST;
            }
            case MESSAGE: {
                if (fieldDescriptor.isMapField()) {
                    return FieldType.MAP;
                }
                return fieldDescriptor.isRepeated() ? FieldType.MESSAGE_LIST : FieldType.MESSAGE;
            }
            case SFIXED32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SFIXED32;
                }
                return fieldDescriptor.isPacked() ? FieldType.SFIXED32_LIST_PACKED : FieldType.SFIXED32_LIST;
            }
            case SFIXED64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SFIXED64;
                }
                return fieldDescriptor.isPacked() ? FieldType.SFIXED64_LIST_PACKED : FieldType.SFIXED64_LIST;
            }
            case SINT32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SINT32;
                }
                return fieldDescriptor.isPacked() ? FieldType.SINT32_LIST_PACKED : FieldType.SINT32_LIST;
            }
            case SINT64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.SINT64;
                }
                return fieldDescriptor.isPacked() ? FieldType.SINT64_LIST_PACKED : FieldType.SINT64_LIST;
            }
            case STRING: {
                return fieldDescriptor.isRepeated() ? FieldType.STRING_LIST : FieldType.STRING;
            }
            case UINT32: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.UINT32;
                }
                return fieldDescriptor.isPacked() ? FieldType.UINT32_LIST_PACKED : FieldType.UINT32_LIST;
            }
            case UINT64: {
                if (!fieldDescriptor.isRepeated()) {
                    return FieldType.UINT64;
                }
                return fieldDescriptor.isPacked() ? FieldType.UINT64_LIST_PACKED : FieldType.UINT64_LIST;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fieldDescriptor.getType()));
    }

    private static Field bitField(Class<?> clazz, int n2) {
        return DescriptorMessageInfoFactory.field(clazz, "bitField" + n2 + "_");
    }

    private static Field field(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        return DescriptorMessageInfoFactory.field(clazz, DescriptorMessageInfoFactory.getFieldName(fieldDescriptor));
    }

    private static Field cachedSizeField(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        return DescriptorMessageInfoFactory.field(clazz, DescriptorMessageInfoFactory.getCachedSizeFieldName(fieldDescriptor));
    }

    private static Field field(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to find field " + string + " in message class " + clazz.getName());
        }
    }

    static String getFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fieldDescriptor.getMessageType().getName() : fieldDescriptor.getName();
        String string2 = specialFieldNames.contains(string) ? "__" : "_";
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(string) + string2;
    }

    private static String getCachedSizeFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(fieldDescriptor.getName()) + "MemoizedSerializedSize";
    }

    private static String snakeCaseToCamelCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '_') {
                bl2 = true;
                continue;
            }
            if (Character.isDigit(c2)) {
                stringBuilder.append(c2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuilder.append(Character.toUpperCase(c2));
                bl2 = false;
                continue;
            }
            if (i2 == 0) {
                stringBuilder.append(Character.toLowerCase(c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static Class<?> getOneofStoredTypeForMessage(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        try {
            String string = fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fieldDescriptor.getMessageType().getName() : fieldDescriptor.getName();
            Method method = clazz.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(string), new Class[0]);
            return method.getReturnType();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Class<?> getTypeForRepeatedMessageField(Class<?> clazz, Descriptors.FieldDescriptor fieldDescriptor) {
        try {
            String string = fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fieldDescriptor.getMessageType().getName() : fieldDescriptor.getName();
            Method method = clazz.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(string), Integer.TYPE);
            return method.getReturnType();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String getterForField(String string) {
        String string2 = DescriptorMessageInfoFactory.snakeCaseToCamelCase(string);
        StringBuilder stringBuilder = new StringBuilder("get");
        stringBuilder.append(Character.toUpperCase(string2.charAt(0)));
        stringBuilder.append(string2.substring(1, string2.length()));
        return stringBuilder.toString();
    }

    private static final class OneofState {
        private OneofInfo[] oneofs = new OneofInfo[2];

        private OneofState() {
        }

        OneofInfo getOneof(Class<?> clazz, Descriptors.OneofDescriptor oneofDescriptor) {
            OneofInfo oneofInfo;
            int n2 = oneofDescriptor.getIndex();
            if (n2 >= this.oneofs.length) {
                this.oneofs = Arrays.copyOf(this.oneofs, n2 * 2);
            }
            if ((oneofInfo = this.oneofs[n2]) == null) {
                this.oneofs[n2] = oneofInfo = OneofState.newInfo(clazz, oneofDescriptor);
            }
            return oneofInfo;
        }

        private static OneofInfo newInfo(Class<?> clazz, Descriptors.OneofDescriptor oneofDescriptor) {
            String string = DescriptorMessageInfoFactory.snakeCaseToCamelCase(oneofDescriptor.getName());
            String string2 = string + "_";
            String string3 = string + "Case_";
            return new OneofInfo(oneofDescriptor.getIndex(), DescriptorMessageInfoFactory.field(clazz, string3), DescriptorMessageInfoFactory.field(clazz, string2));
        }
    }

    static class IsInitializedCheckAnalyzer {
        private final Map<Descriptors.Descriptor, Boolean> resultCache = new ConcurrentHashMap<Descriptors.Descriptor, Boolean>();
        private int index = 0;
        private final Stack<Node> stack = new Stack();
        private final Map<Descriptors.Descriptor, Node> nodeCache = new HashMap<Descriptors.Descriptor, Node>();

        IsInitializedCheckAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
            Boolean bl2 = this.resultCache.get(descriptor);
            if (bl2 != null) {
                return bl2;
            }
            IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = this;
            synchronized (isInitializedCheckAnalyzer) {
                bl2 = this.resultCache.get(descriptor);
                if (bl2 != null) {
                    return bl2;
                }
                return this.dfs((Descriptors.Descriptor)descriptor).component.needsIsInitializedCheck;
            }
        }

        private Node dfs(Descriptors.Descriptor descriptor) {
            Node node = new Node(descriptor, this.index++);
            this.stack.push(node);
            this.nodeCache.put(descriptor, node);
            for (Descriptors.FieldDescriptor object : descriptor.getFields()) {
                if (object.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                Node node2 = this.nodeCache.get(object.getMessageType());
                if (node2 == null) {
                    node2 = this.dfs(object.getMessageType());
                    node.lowLink = Math.min(node.lowLink, node2.lowLink);
                    continue;
                }
                if (node2.component != null) continue;
                node.lowLink = Math.min(node.lowLink, node2.lowLink);
            }
            if (node.index == node.lowLink) {
                Node node3;
                StronglyConnectedComponent stronglyConnectedComponent = new StronglyConnectedComponent();
                do {
                    node3 = this.stack.pop();
                    node3.component = stronglyConnectedComponent;
                    stronglyConnectedComponent.messages.add(node3.descriptor);
                } while (node3 != node);
                this.analyze(stronglyConnectedComponent);
            }
            return node;
        }

        private void analyze(StronglyConnectedComponent stronglyConnectedComponent) {
            boolean bl2 = false;
            block0: for (Descriptors.Descriptor descriptor : stronglyConnectedComponent.messages) {
                if (descriptor.isExtendable()) {
                    bl2 = true;
                    break;
                }
                for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                    if (fieldDescriptor.isRequired()) {
                        bl2 = true;
                        break block0;
                    }
                    if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                    Node node = this.nodeCache.get(fieldDescriptor.getMessageType());
                    if (node.component == stronglyConnectedComponent || !node.component.needsIsInitializedCheck) continue;
                    bl2 = true;
                    break block0;
                }
            }
            stronglyConnectedComponent.needsIsInitializedCheck = bl2;
            for (Descriptors.Descriptor descriptor : stronglyConnectedComponent.messages) {
                this.resultCache.put(descriptor, stronglyConnectedComponent.needsIsInitializedCheck);
            }
        }

        private static class StronglyConnectedComponent {
            final List<Descriptors.Descriptor> messages = new ArrayList<Descriptors.Descriptor>();
            boolean needsIsInitializedCheck = false;

            private StronglyConnectedComponent() {
            }
        }

        private static class Node {
            final Descriptors.Descriptor descriptor;
            final int index;
            int lowLink;
            StronglyConnectedComponent component;

            Node(Descriptors.Descriptor descriptor, int n2) {
                this.descriptor = descriptor;
                this.index = n2;
                this.lowLink = n2;
                this.component = null;
            }
        }
    }
}

