/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.Utf8;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public final class Internal {
    static final Charset US_ASCII = Charset.forName("US-ASCII");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
    public static final CodedInputStream EMPTY_CODED_INPUT_STREAM = CodedInputStream.newInstance(EMPTY_BYTE_ARRAY);

    private Internal() {
    }

    static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    static <T> T checkNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException(string);
        }
        return t2;
    }

    public static String stringDefaultValue(String string) {
        return new String(string.getBytes(ISO_8859_1), UTF_8);
    }

    public static ByteString bytesDefaultValue(String string) {
        return ByteString.copyFrom(string.getBytes(ISO_8859_1));
    }

    public static byte[] byteArrayDefaultValue(String string) {
        return string.getBytes(ISO_8859_1);
    }

    public static ByteBuffer byteBufferDefaultValue(String string) {
        return ByteBuffer.wrap(Internal.byteArrayDefaultValue(string));
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.clear();
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer2.capacity());
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.clear();
        return byteBuffer3;
    }

    public static boolean isValidUtf8(ByteString byteString) {
        return byteString.isValidUtf8();
    }

    public static boolean isValidUtf8(byte[] byArray) {
        return Utf8.isValidUtf8(byArray);
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes(UTF_8);
    }

    public static String toStringUtf8(byte[] byArray) {
        return new String(byArray, UTF_8);
    }

    public static int hashLong(long l2) {
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int hashBoolean(boolean bl2) {
        return bl2 ? 1231 : 1237;
    }

    public static int hashEnum(EnumLite enumLite) {
        return enumLite.getNumber();
    }

    public static int hashEnumList(List<? extends EnumLite> list) {
        int n2 = 1;
        for (EnumLite enumLite : list) {
            n2 = 31 * n2 + Internal.hashEnum(enumLite);
        }
        return n2;
    }

    public static boolean equals(List<byte[]> list, List<byte[]> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (Arrays.equals(list.get(i2), list2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(List<byte[]> list) {
        int n2 = 1;
        for (byte[] byArray : list) {
            n2 = 31 * n2 + Internal.hashCode(byArray);
        }
        return n2;
    }

    public static int hashCode(byte[] byArray) {
        return Internal.hashCode(byArray, 0, byArray.length);
    }

    static int hashCode(byte[] byArray, int n2, int n3) {
        int n4 = Internal.partialHash(n3, byArray, n2, n3);
        return n4 == 0 ? 1 : n4;
    }

    static int partialHash(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            n2 = n2 * 31 + byArray[i2];
        }
        return n2;
    }

    public static boolean equalsByteBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.capacity() != byteBuffer2.capacity()) {
            return false;
        }
        return byteBuffer.duplicate().clear().equals(byteBuffer2.duplicate().clear());
    }

    public static boolean equalsByteBuffer(List<ByteBuffer> list, List<ByteBuffer> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (Internal.equalsByteBuffer(list.get(i2), list2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeByteBuffer(List<ByteBuffer> list) {
        int n2 = 1;
        for (ByteBuffer byteBuffer : list) {
            n2 = 31 * n2 + Internal.hashCodeByteBuffer(byteBuffer);
        }
        return n2;
    }

    public static int hashCodeByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n2 = Internal.partialHash(byteBuffer.capacity(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            return n2 == 0 ? 1 : n2;
        }
        int n3 = byteBuffer.capacity() > 4096 ? 4096 : byteBuffer.capacity();
        byte[] byArray = new byte[n3];
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.clear();
        int n4 = byteBuffer.capacity();
        while (byteBuffer2.remaining() > 0) {
            int n5 = byteBuffer2.remaining() <= n3 ? byteBuffer2.remaining() : n3;
            byteBuffer2.get(byArray, 0, n5);
            n4 = Internal.partialHash(n4, byArray, 0, n5);
        }
        return n4 == 0 ? 1 : n4;
    }

    public static <T extends MessageLite> T getDefaultInstance(Class<T> clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            return (T)((MessageLite)method.invoke((Object)method, new Object[0]));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get default instance for " + clazz, exception);
        }
    }

    static Object mergeMessage(Object object, Object object2) {
        return ((MessageLite)object).toBuilder().mergeFrom((MessageLite)object2).buildPartial();
    }

    public static interface FloatList
    extends ProtobufList<Float> {
        public float getFloat(int var1);

        public void addFloat(float var1);

        public float setFloat(int var1, float var2);

        public FloatList mutableCopyWithCapacity(int var1);
    }

    public static interface DoubleList
    extends ProtobufList<Double> {
        public double getDouble(int var1);

        public void addDouble(double var1);

        public double setDouble(int var1, double var2);

        public DoubleList mutableCopyWithCapacity(int var1);
    }

    public static interface LongList
    extends ProtobufList<Long> {
        public long getLong(int var1);

        public void addLong(long var1);

        public long setLong(int var1, long var2);

        public LongList mutableCopyWithCapacity(int var1);
    }

    public static interface BooleanList
    extends ProtobufList<Boolean> {
        public boolean getBoolean(int var1);

        public void addBoolean(boolean var1);

        public boolean setBoolean(int var1, boolean var2);

        public BooleanList mutableCopyWithCapacity(int var1);
    }

    public static interface IntList
    extends ProtobufList<Integer> {
        public int getInt(int var1);

        public void addInt(int var1);

        public int setInt(int var1, int var2);

        public IntList mutableCopyWithCapacity(int var1);
    }

    public static interface ProtobufList<E>
    extends List<E>,
    RandomAccess {
        public void makeImmutable();

        public boolean isModifiable();

        public ProtobufList<E> mutableCopyWithCapacity(int var1);
    }

    public static class MapAdapter<K, V, RealValue>
    extends AbstractMap<K, V> {
        private final Map<K, RealValue> realMap;
        private final Converter<RealValue, V> valueConverter;

        public static <T extends EnumLite> Converter<Integer, T> newEnumConverter(final EnumLiteMap<T> enumLiteMap, final T t2) {
            return new Converter<Integer, T>(){

                @Override
                public T doForward(Integer n2) {
                    Object t22 = enumLiteMap.findValueByNumber(n2);
                    return t22 == null ? t2 : t22;
                }

                @Override
                public Integer doBackward(T t22) {
                    return t22.getNumber();
                }
            };
        }

        public MapAdapter(Map<K, RealValue> map, Converter<RealValue, V> converter) {
            this.realMap = map;
            this.valueConverter = converter;
        }

        @Override
        public V get(Object object) {
            RealValue RealValue = this.realMap.get(object);
            if (RealValue == null) {
                return null;
            }
            return this.valueConverter.doForward(RealValue);
        }

        @Override
        public V put(K k2, V v2) {
            RealValue RealValue = this.realMap.put(k2, this.valueConverter.doBackward(v2));
            if (RealValue == null) {
                return null;
            }
            return this.valueConverter.doForward(RealValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new SetAdapter(this.realMap.entrySet());
        }

        private class EntryAdapter
        implements Map.Entry<K, V> {
            private final Map.Entry<K, RealValue> realEntry;

            public EntryAdapter(Map.Entry<K, RealValue> entry) {
                this.realEntry = entry;
            }

            @Override
            public K getKey() {
                return this.realEntry.getKey();
            }

            @Override
            public V getValue() {
                return MapAdapter.this.valueConverter.doForward(this.realEntry.getValue());
            }

            @Override
            public V setValue(V v2) {
                Object RealValue = this.realEntry.setValue(MapAdapter.this.valueConverter.doBackward(v2));
                if (RealValue == null) {
                    return null;
                }
                return MapAdapter.this.valueConverter.doForward(RealValue);
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return this.getKey().equals(entry.getKey()) && this.getValue().equals(this.getValue());
            }

            @Override
            public int hashCode() {
                return this.realEntry.hashCode();
            }
        }

        private class IteratorAdapter
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, RealValue>> realIterator;

            public IteratorAdapter(Iterator<Map.Entry<K, RealValue>> iterator) {
                this.realIterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.realIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return new EntryAdapter(this.realIterator.next());
            }

            @Override
            public void remove() {
                this.realIterator.remove();
            }
        }

        private class SetAdapter
        extends AbstractSet<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, RealValue>> realSet;

            public SetAdapter(Set<Map.Entry<K, RealValue>> set) {
                this.realSet = set;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new IteratorAdapter(this.realSet.iterator());
            }

            @Override
            public int size() {
                return this.realSet.size();
            }
        }

        public static interface Converter<A, B> {
            public B doForward(A var1);

            public A doBackward(B var1);
        }
    }

    public static class ListAdapter<F, T>
    extends AbstractList<T> {
        private final List<F> fromList;
        private final Converter<F, T> converter;

        public ListAdapter(List<F> list, Converter<F, T> converter) {
            this.fromList = list;
            this.converter = converter;
        }

        @Override
        public T get(int n2) {
            return this.converter.convert(this.fromList.get(n2));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        public static interface Converter<F, T> {
            public T convert(F var1);
        }
    }

    public static interface EnumVerifier {
        public boolean isInRange(int var1);
    }

    public static interface EnumLiteMap<T extends EnumLite> {
        public T findValueByNumber(int var1);
    }

    public static interface EnumLite {
        public int getNumber();
    }
}

