/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Command;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQChannel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQContentHeader;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.CommandAssembler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AMQCommand
implements Command {
    public static final int EMPTY_FRAME_SIZE = 8;
    private final CommandAssembler assembler;

    public AMQCommand() {
        this(null, null, null);
    }

    public AMQCommand(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method) {
        this(method, null, null);
    }

    public AMQCommand(com.contrastsecurity.thirdparty.com.rabbitmq.client.Method method, AMQContentHeader aMQContentHeader, byte[] byArray) {
        this.assembler = new CommandAssembler((Method)method, aMQContentHeader, byArray);
    }

    @Override
    public Method getMethod() {
        return this.assembler.getMethod();
    }

    @Override
    public AMQContentHeader getContentHeader() {
        return this.assembler.getContentHeader();
    }

    @Override
    public byte[] getContentBody() {
        return this.assembler.getContentBody();
    }

    public boolean handleFrame(Frame frame) throws IOException {
        return this.assembler.handleFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQChannel aMQChannel) throws IOException {
        int n2 = aMQChannel.getChannelNumber();
        AMQConnection aMQConnection = aMQChannel.getConnection();
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            Method method = this.assembler.getMethod();
            if (method.hasContent()) {
                int n3;
                byte[] byArray = this.assembler.getContentBody();
                Frame frame = this.assembler.getContentHeader().toFrame(n2, byArray.length);
                int n4 = aMQConnection.getFrameMax();
                boolean bl2 = n4 > 0;
                int n5 = n3 = bl2 ? n4 - 8 : byArray.length;
                if (bl2 && frame.size() > n4) {
                    String string = String.format("Content headers exceeded max frame size: %d > %d", frame.size(), n4);
                    throw new IllegalArgumentException(string);
                }
                aMQConnection.writeFrame(method.toFrame(n2));
                aMQConnection.writeFrame(frame);
                for (int i2 = 0; i2 < byArray.length; i2 += n3) {
                    int n6 = byArray.length - i2;
                    int n7 = n6 < n3 ? n6 : n3;
                    Frame frame2 = Frame.fromBodyFragment(n2, byArray, i2, n7);
                    aMQConnection.writeFrame(frame2);
                }
            } else {
                aMQConnection.writeFrame(method.toFrame(n2));
            }
        }
        aMQConnection.flush();
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean bl2) {
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            return "" + '{' + this.assembler.getMethod() + ", " + this.assembler.getContentHeader() + ", " + AMQCommand.contentBodyStringBuilder(this.assembler.getContentBody(), bl2) + '}';
        }
    }

    private static StringBuilder contentBodyStringBuilder(byte[] byArray, boolean bl2) {
        try {
            if (bl2) {
                return new StringBuilder().append(byArray.length).append(" bytes of payload");
            }
            return new StringBuilder().append('\"').append(new String(byArray, "UTF-8")).append('\"');
        }
        catch (Exception exception) {
            return new StringBuilder().append('|').append(byArray.length).append('|');
        }
    }

    public static void checkPreconditions() {
        AMQCommand.checkEmptyFrameSize();
    }

    private static void checkEmptyFrameSize() {
        Frame frame = new Frame(3, 0, new byte[0]);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            frame.writeTo(new DataOutputStream(byteArrayOutputStream));
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"IOException while checking EMPTY_FRAME_SIZE");
        }
        int n2 = byteArrayOutputStream.toByteArray().length;
        if (8 != n2) {
            throw new AssertionError((Object)("Internal error: expected EMPTY_FRAME_SIZE(8) is not equal to computed value: " + n2));
        }
    }
}

