/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Address;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionPostProcessor;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.SocketConfigurator;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AbstractFrameHandlerFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.SocketFrameHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;

public class SocketFrameHandlerFactory
extends AbstractFrameHandlerFactory {
    private final SocketFactory factory;
    private final ExecutorService shutdownExecutor;

    public SocketFrameHandlerFactory(int n2, SocketFactory socketFactory, SocketConfigurator socketConfigurator, boolean bl2) {
        this(n2, socketFactory, socketConfigurator, bl2, null);
    }

    public SocketFrameHandlerFactory(int n2, SocketFactory socketFactory, SocketConfigurator socketConfigurator, boolean bl2, ExecutorService executorService) {
        this(n2, socketFactory, socketConfigurator, bl2, executorService, null);
    }

    public SocketFrameHandlerFactory(int n2, SocketFactory socketFactory, SocketConfigurator socketConfigurator, boolean bl2, ExecutorService executorService, ConnectionPostProcessor connectionPostProcessor) {
        super(n2, socketConfigurator, bl2, connectionPostProcessor);
        this.factory = socketFactory;
        this.shutdownExecutor = executorService;
    }

    @Override
    public FrameHandler create(Address address) throws IOException {
        String string = address.getHost();
        int n2 = ConnectionFactory.portOrDefault(address.getPort(), this.ssl);
        Socket socket = null;
        try {
            socket = this.factory.createSocket();
            this.configurator.configure(socket);
            socket.connect(new InetSocketAddress(string, n2), this.connectionTimeout);
            this.connectionPostProcessor.postProcess(new ConnectionContext(socket, address, this.ssl, null));
            return this.create(socket);
        }
        catch (IOException iOException) {
            SocketFrameHandlerFactory.quietTrySocketClose(socket);
            throw iOException;
        }
    }

    public FrameHandler create(Socket socket) throws IOException {
        return new SocketFrameHandler(socket, this.shutdownExecutor);
    }

    private static void quietTrySocketClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

