/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.LongString;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MalformedFrameException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.LongStringHelper;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.TruncatedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueReader {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private final DataInputStream in;

    private static long unsignedExtend(int n2) {
        long l2 = n2;
        return l2 & 0xFFFFFFFFL;
    }

    public ValueReader(DataInputStream dataInputStream) {
        this.in = dataInputStream;
    }

    private static String readShortstr(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
        dataInputStream.readFully(byArray);
        return new String(byArray, "utf-8");
    }

    public final String readShortstr() throws IOException {
        return ValueReader.readShortstr(this.in);
    }

    private static byte[] readBytes(DataInputStream dataInputStream) throws IOException {
        long l2 = ValueReader.unsignedExtend(dataInputStream.readInt());
        if (l2 < Integer.MAX_VALUE) {
            byte[] byArray = new byte[(int)l2];
            dataInputStream.readFully(byArray);
            return byArray;
        }
        throw new UnsupportedOperationException("Very long byte vectors and strings not currently supported");
    }

    private static LongString readLongstr(DataInputStream dataInputStream) throws IOException {
        return LongStringHelper.asLongString(ValueReader.readBytes(dataInputStream));
    }

    public final LongString readLongstr() throws IOException {
        return ValueReader.readLongstr(this.in);
    }

    public final int readShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final int readLong() throws IOException {
        return this.in.readInt();
    }

    public final long readLonglong() throws IOException {
        return this.in.readLong();
    }

    private static Map<String, Object> readTable(DataInputStream dataInputStream) throws IOException {
        long l2 = ValueReader.unsignedExtend(dataInputStream.readInt());
        if (l2 == 0L) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        DataInputStream dataInputStream2 = new DataInputStream(new TruncatedInputStream(dataInputStream, l2));
        while (dataInputStream2.available() > 0) {
            String string = ValueReader.readShortstr(dataInputStream2);
            Object object = ValueReader.readFieldValue(dataInputStream2);
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private static Object readFieldValue(DataInputStream dataInputStream) throws IOException {
        Object object = null;
        switch (dataInputStream.readUnsignedByte()) {
            case 83: {
                object = ValueReader.readLongstr(dataInputStream);
                break;
            }
            case 73: {
                object = dataInputStream.readInt();
                break;
            }
            case 68: {
                int n2 = dataInputStream.readUnsignedByte();
                byte[] byArray = new byte[4];
                dataInputStream.readFully(byArray);
                object = new BigDecimal(new BigInteger(byArray), n2);
                break;
            }
            case 84: {
                object = ValueReader.readTimestamp(dataInputStream);
                break;
            }
            case 70: {
                object = ValueReader.readTable(dataInputStream);
                break;
            }
            case 65: {
                object = ValueReader.readArray(dataInputStream);
                break;
            }
            case 98: {
                object = dataInputStream.readByte();
                break;
            }
            case 100: {
                object = dataInputStream.readDouble();
                break;
            }
            case 102: {
                object = Float.valueOf(dataInputStream.readFloat());
                break;
            }
            case 108: {
                object = dataInputStream.readLong();
                break;
            }
            case 115: {
                object = dataInputStream.readShort();
                break;
            }
            case 116: {
                object = dataInputStream.readBoolean();
                break;
            }
            case 120: {
                object = ValueReader.readBytes(dataInputStream);
                break;
            }
            case 86: {
                object = null;
                break;
            }
            default: {
                throw new MalformedFrameException("Unrecognised type in table");
            }
        }
        return object;
    }

    private static List<Object> readArray(DataInputStream dataInputStream) throws IOException {
        long l2 = ValueReader.unsignedExtend(dataInputStream.readInt());
        DataInputStream dataInputStream2 = new DataInputStream(new TruncatedInputStream(dataInputStream, l2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (dataInputStream2.available() > 0) {
            Object object = ValueReader.readFieldValue(dataInputStream2);
            arrayList.add(object);
        }
        return arrayList;
    }

    public final Map<String, Object> readTable() throws IOException {
        return ValueReader.readTable(this.in);
    }

    public final int readOctet() throws IOException {
        return this.in.readUnsignedByte();
    }

    private static Date readTimestamp(DataInputStream dataInputStream) throws IOException {
        return new Date(dataInputStream.readLong() * 1000L);
    }

    public final Date readTimestamp() throws IOException {
        return ValueReader.readTimestamp(this.in);
    }
}

