/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.MalformedFrameException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FrameBuilder {
    private static final int PAYLOAD_OFFSET = 7;
    protected final ReadableByteChannel channel;
    protected final ByteBuffer applicationBuffer;
    private final int[] frameBuffer = new int[3];
    private int frameType;
    private int frameChannel;
    private byte[] framePayload;
    private int bytesRead = 0;

    public FrameBuilder(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        this.channel = readableByteChannel;
        this.applicationBuffer = byteBuffer;
    }

    public Frame readFrame() throws IOException {
        while (this.somethingToRead()) {
            int n2;
            if (this.bytesRead == 0) {
                this.frameType = this.readFromBuffer();
                if (this.frameType == 65) {
                    this.handleProtocolVersionMismatch();
                }
            } else if (this.bytesRead == 1) {
                this.frameBuffer[0] = this.readFromBuffer();
            } else if (this.bytesRead == 2) {
                this.frameChannel = (this.frameBuffer[0] << 8) + (this.readFromBuffer() << 0);
            } else if (this.bytesRead == 3) {
                this.frameBuffer[0] = this.readFromBuffer();
            } else if (this.bytesRead == 4) {
                this.frameBuffer[1] = this.readFromBuffer();
            } else if (this.bytesRead == 5) {
                this.frameBuffer[2] = this.readFromBuffer();
            } else if (this.bytesRead == 6) {
                n2 = (this.frameBuffer[0] << 24) + (this.frameBuffer[1] << 16) + (this.frameBuffer[2] << 8) + (this.readFromBuffer() << 0);
                this.framePayload = new byte[n2];
            } else if (this.bytesRead >= 7 && this.bytesRead < this.framePayload.length + 7) {
                this.framePayload[this.bytesRead - 7] = (byte)this.readFromBuffer();
            } else {
                if (this.bytesRead == this.framePayload.length + 7) {
                    n2 = this.readFromBuffer();
                    if (n2 != 206) {
                        throw new MalformedFrameException("Bad frame end marker: " + n2);
                    }
                    this.bytesRead = 0;
                    return new Frame(this.frameType, this.frameChannel, this.framePayload);
                }
                throw new IllegalStateException("Number of read bytes incorrect: " + this.bytesRead);
            }
            ++this.bytesRead;
        }
        return null;
    }

    protected boolean somethingToRead() throws IOException {
        if (!this.applicationBuffer.hasRemaining()) {
            this.applicationBuffer.clear();
            int n2 = NioHelper.read(this.channel, this.applicationBuffer);
            this.applicationBuffer.flip();
            return n2 > 0;
        }
        return true;
    }

    private int readFromBuffer() {
        return this.applicationBuffer.get() & 0xFF;
    }

    private void handleProtocolVersionMismatch() throws IOException {
        MalformedFrameException malformedFrameException;
        int n2;
        byte[] byArray = new byte[]{77, 81, 80};
        for (n2 = 0; this.somethingToRead() && n2 < 3; ++n2) {
            int n3 = this.readFromBuffer();
            if (n3 == byArray[n2]) continue;
            throw new MalformedFrameException("Invalid AMQP protocol header from server: expected character " + byArray[n2] + ", got " + n3);
        }
        if (n2 != 3) {
            throw new MalformedFrameException("Invalid AMQP protocol header from server: read only " + (n2 + 1) + " byte(s) instead of 4");
        }
        int[] nArray = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!this.somethingToRead()) {
                throw new MalformedFrameException("Invalid AMQP protocol header from server");
            }
            nArray[i2] = this.readFromBuffer();
        }
        if (nArray[0] == 1 && nArray[1] == 1 && nArray[2] == 8 && nArray[3] == 0) {
            malformedFrameException = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server is 0-8");
        } else {
            String string = "";
            for (int i3 = 0; i3 < 4; ++i3) {
                if (i3 != 0) {
                    string = string + ",";
                }
                string = string + nArray[i3];
            }
            malformedFrameException = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server sent signature " + string);
        }
        throw malformedFrameException;
    }
}

