/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Address;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.AddressResolver;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.BlockedListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Connection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ExceptionHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ListAddressResolver;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.MissedHeartbeatException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.NoOpMetricsCollector;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.RecoverableConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.RecoveryListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.TopologyRecoveryException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ConnectionParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ErrorOnWriteListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandlerFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.NetworkConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.ConsumerRecoveryListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.QueueRecoveryListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedBinding;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedEntity;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedExchangeBinding;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedNamedEntity;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedQueueBinding;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnectionFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecoveryAwareChannelN;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecoveryCanBeginListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RetryResult;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.TopologyRecoveryFilter;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.Utility;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class AutorecoveringConnection
implements RecoverableConnection,
NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutorecoveringConnection.class);
    private final RecoveryAwareAMQConnectionFactory cf;
    private final Map<Integer, AutorecoveringChannel> channels;
    private final ConnectionParams params;
    private volatile RecoveryAwareAMQConnection delegate;
    private final List<ShutdownListener> shutdownHooks = Collections.synchronizedList(new ArrayList());
    private final List<RecoveryListener> recoveryListeners = Collections.synchronizedList(new ArrayList());
    private final List<BlockedListener> blockedListeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, RecordedQueue> recordedQueues = Collections.synchronizedMap(new LinkedHashMap());
    private final List<RecordedBinding> recordedBindings = Collections.synchronizedList(new ArrayList());
    private final Map<String, RecordedExchange> recordedExchanges = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, RecordedConsumer> consumers = Collections.synchronizedMap(new LinkedHashMap());
    private final List<ConsumerRecoveryListener> consumerRecoveryListeners = Collections.synchronizedList(new ArrayList());
    private final List<QueueRecoveryListener> queueRecoveryListeners = Collections.synchronizedList(new ArrayList());
    private final TopologyRecoveryFilter topologyRecoveryFilter;
    private volatile boolean manuallyClosed = false;
    private final Object recoveryLock = new Object();
    private final RetryHandler retryHandler;

    public AutorecoveringConnection(ConnectionParams connectionParams, FrameHandlerFactory frameHandlerFactory, List<Address> list) {
        this(connectionParams, frameHandlerFactory, new ListAddressResolver(list));
    }

    public AutorecoveringConnection(ConnectionParams connectionParams, FrameHandlerFactory frameHandlerFactory, AddressResolver addressResolver) {
        this(connectionParams, frameHandlerFactory, addressResolver, new NoOpMetricsCollector());
    }

    public AutorecoveringConnection(ConnectionParams connectionParams, FrameHandlerFactory frameHandlerFactory, AddressResolver addressResolver, MetricsCollector metricsCollector) {
        this.cf = new RecoveryAwareAMQConnectionFactory(connectionParams, frameHandlerFactory, addressResolver, metricsCollector);
        this.params = connectionParams;
        this.setupErrorOnWriteListenerForPotentialRecovery();
        this.channels = new ConcurrentHashMap<Integer, AutorecoveringChannel>();
        this.topologyRecoveryFilter = connectionParams.getTopologyRecoveryFilter() == null ? this.letAllPassFilter() : connectionParams.getTopologyRecoveryFilter();
        this.retryHandler = connectionParams.getTopologyRecoveryRetryHandler();
    }

    private void setupErrorOnWriteListenerForPotentialRecovery() {
        final ThreadFactory threadFactory = this.params.getThreadFactory();
        final ReentrantLock reentrantLock = new ReentrantLock();
        this.params.setErrorOnWriteListener(new ErrorOnWriteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(final Connection connection, final IOException iOException) throws IOException {
                if (reentrantLock.tryLock()) {
                    try {
                        Thread thread = threadFactory.newThread(new Runnable(){

                            @Override
                            public void run() {
                                AMQConnection aMQConnection = (AMQConnection)connection;
                                aMQConnection.handleIoError(iOException);
                            }
                        });
                        thread.setName("RabbitMQ Error On Write Thread");
                        thread.start();
                    }
                    finally {
                        reentrantLock.unlock();
                    }
                }
                throw iOException;
            }
        });
    }

    private TopologyRecoveryFilter letAllPassFilter() {
        return new TopologyRecoveryFilter(){

            @Override
            public boolean filterExchange(RecordedExchange recordedExchange) {
                return true;
            }

            @Override
            public boolean filterQueue(RecordedQueue recordedQueue) {
                return true;
            }

            @Override
            public boolean filterBinding(RecordedBinding recordedBinding) {
                return true;
            }

            @Override
            public boolean filterConsumer(RecordedConsumer recordedConsumer) {
                return true;
            }
        };
    }

    public void init() throws IOException, TimeoutException {
        this.delegate = this.cf.newConnection();
        this.addAutomaticRecoveryListener(this.delegate);
    }

    @Override
    public Channel createChannel() throws IOException {
        RecoveryAwareChannelN recoveryAwareChannelN = (RecoveryAwareChannelN)this.delegate.createChannel();
        if (recoveryAwareChannelN == null) {
            return null;
        }
        return this.wrapChannel(recoveryAwareChannelN);
    }

    @Override
    public Channel createChannel(int n2) throws IOException {
        return this.delegate.createChannel(n2);
    }

    private Channel wrapChannel(RecoveryAwareChannelN recoveryAwareChannelN) {
        if (recoveryAwareChannelN == null) {
            return null;
        }
        AutorecoveringChannel autorecoveringChannel = new AutorecoveringChannel(this, recoveryAwareChannelN);
        this.registerChannel(autorecoveringChannel);
        return autorecoveringChannel;
    }

    void registerChannel(AutorecoveringChannel autorecoveringChannel) {
        this.channels.put(autorecoveringChannel.getChannelNumber(), autorecoveringChannel);
    }

    void unregisterChannel(AutorecoveringChannel autorecoveringChannel) {
        this.channels.remove(autorecoveringChannel.getChannelNumber());
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this.delegate.getServerProperties();
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return this.delegate.getClientProperties();
    }

    @Override
    public String getClientProvidedName() {
        return this.delegate.getClientProvidedName();
    }

    @Override
    public int getFrameMax() {
        return this.delegate.getFrameMax();
    }

    @Override
    public int getHeartbeat() {
        return this.delegate.getHeartbeat();
    }

    @Override
    public int getChannelMax() {
        return this.delegate.getChannelMax();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int n2) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int n2, String string, int n3) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(n2, string, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int n2, String string, int n3) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(n2, string, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int n2, String string) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(n2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int n2) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(n2);
    }

    public AMQConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    @Override
    public void addBlockedListener(BlockedListener blockedListener) {
        this.blockedListeners.add(blockedListener);
        this.delegate.addBlockedListener(blockedListener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener blockedListener) {
        this.blockedListeners.remove(blockedListener);
        return this.delegate.removeBlockedListener(blockedListener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
        this.delegate.clearBlockedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int n2, String string) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(n2, string);
    }

    @Override
    public void addShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownHooks.add(shutdownListener);
        this.delegate.addShutdownListener(shutdownListener);
    }

    @Override
    public void removeShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownHooks.remove(shutdownListener);
        this.delegate.removeShutdownListener(shutdownListener);
    }

    @Override
    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    @Override
    public void addRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListeners.add(recoveryListener);
    }

    @Override
    public void removeRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListeners.remove(recoveryListener);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAutomaticRecoveryListener(final RecoveryAwareAMQConnection recoveryAwareAMQConnection) {
        final AutorecoveringConnection autorecoveringConnection = this;
        RecoveryCanBeginListener recoveryCanBeginListener = new RecoveryCanBeginListener(){

            @Override
            public void recoveryCanBegin(ShutdownSignalException shutdownSignalException) {
                try {
                    if (AutorecoveringConnection.this.shouldTriggerConnectionRecovery(shutdownSignalException)) {
                        autorecoveringConnection.beginAutomaticRecovery();
                    }
                }
                catch (Exception exception) {
                    recoveryAwareAMQConnection.getExceptionHandler().handleConnectionRecoveryException(autorecoveringConnection, exception);
                }
            }
        };
        AutorecoveringConnection autorecoveringConnection2 = this;
        synchronized (autorecoveringConnection2) {
            recoveryAwareAMQConnection.addRecoveryCanBeginListener(recoveryCanBeginListener);
        }
    }

    protected boolean shouldTriggerConnectionRecovery(ShutdownSignalException shutdownSignalException) {
        return !shutdownSignalException.isInitiatedByApplication() || shutdownSignalException.getCause() instanceof MissedHeartbeatException;
    }

    public void addQueueRecoveryListener(QueueRecoveryListener queueRecoveryListener) {
        this.queueRecoveryListeners.add(queueRecoveryListener);
    }

    public void removeQueueRecoveryListener(QueueRecoveryListener queueRecoveryListener) {
        this.queueRecoveryListeners.remove(queueRecoveryListener);
    }

    public void addConsumerRecoveryListener(ConsumerRecoveryListener consumerRecoveryListener) {
        this.consumerRecoveryListeners.add(consumerRecoveryListener);
    }

    public void removeConsumerRecoveryListener(ConsumerRecoveryListener consumerRecoveryListener) {
        this.consumerRecoveryListeners.remove(consumerRecoveryListener);
    }

    private synchronized void beginAutomaticRecovery() throws InterruptedException {
        Thread.sleep(this.params.getRecoveryDelayHandler().getDelay(0));
        this.notifyRecoveryListenersStarted();
        RecoveryAwareAMQConnection recoveryAwareAMQConnection = this.recoverConnection();
        if (recoveryAwareAMQConnection == null) {
            return;
        }
        LOGGER.debug("Connection {} has recovered", (Object)recoveryAwareAMQConnection);
        this.addAutomaticRecoveryListener(recoveryAwareAMQConnection);
        this.recoverShutdownListeners(recoveryAwareAMQConnection);
        this.recoverBlockedListeners(recoveryAwareAMQConnection);
        this.recoverChannels(recoveryAwareAMQConnection);
        this.delegate = recoveryAwareAMQConnection;
        if (this.params.isTopologyRecoveryEnabled()) {
            this.recoverTopology(this.params.getTopologyRecoveryExecutor());
        }
        this.notifyRecoveryListenersComplete();
    }

    private void recoverShutdownListeners(RecoveryAwareAMQConnection recoveryAwareAMQConnection) {
        for (ShutdownListener shutdownListener : Utility.copy(this.shutdownHooks)) {
            recoveryAwareAMQConnection.addShutdownListener(shutdownListener);
        }
    }

    private void recoverBlockedListeners(RecoveryAwareAMQConnection recoveryAwareAMQConnection) {
        for (BlockedListener blockedListener : Utility.copy(this.blockedListeners)) {
            recoveryAwareAMQConnection.addBlockedListener(blockedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryAwareAMQConnection recoverConnection() throws InterruptedException {
        int n2 = 0;
        while (!this.manuallyClosed) {
            try {
                ++n2;
                RecoveryAwareAMQConnection recoveryAwareAMQConnection = this.cf.newConnection();
                Object object = this.recoveryLock;
                synchronized (object) {
                    if (!this.manuallyClosed) {
                        return recoveryAwareAMQConnection;
                    }
                }
                recoveryAwareAMQConnection.abort();
                return null;
            }
            catch (Exception exception) {
                Thread.sleep(this.params.getRecoveryDelayHandler().getDelay(n2));
                this.getExceptionHandler().handleConnectionRecoveryException(this, exception);
            }
        }
        return null;
    }

    private void recoverChannels(RecoveryAwareAMQConnection recoveryAwareAMQConnection) {
        for (AutorecoveringChannel autorecoveringChannel : this.channels.values()) {
            try {
                autorecoveringChannel.automaticallyRecover(this, recoveryAwareAMQConnection);
                LOGGER.debug("Channel {} has recovered", (Object)autorecoveringChannel);
            }
            catch (Throwable throwable) {
                recoveryAwareAMQConnection.getExceptionHandler().handleChannelRecoveryException(autorecoveringChannel, throwable);
            }
        }
    }

    void recoverChannel(AutorecoveringChannel autorecoveringChannel) throws IOException {
        autorecoveringChannel.automaticallyRecover(this, this.delegate);
    }

    private void notifyRecoveryListenersComplete() {
        for (RecoveryListener recoveryListener : Utility.copy(this.recoveryListeners)) {
            recoveryListener.handleRecovery(this);
        }
    }

    private void notifyRecoveryListenersStarted() {
        for (RecoveryListener recoveryListener : Utility.copy(this.recoveryListeners)) {
            recoveryListener.handleRecoveryStarted(this);
        }
    }

    private void recoverTopology(ExecutorService executorService) {
        if (executorService == null) {
            for (RecordedExchange object : Utility.copy(this.recordedExchanges).values()) {
                this.recoverExchange(object, true);
            }
            for (Map.Entry entry : Utility.copy(this.recordedQueues).entrySet()) {
                this.recoverQueue((String)entry.getKey(), (RecordedQueue)entry.getValue(), true);
            }
            for (RecordedBinding recordedBinding : Utility.copy(this.recordedBindings)) {
                this.recoverBinding(recordedBinding, true);
            }
            for (Map.Entry entry : Utility.copy(this.consumers).entrySet()) {
                this.recoverConsumer((String)entry.getKey(), (RecordedConsumer)entry.getValue(), true);
            }
        } else {
            try {
                this.recoverEntitiesAsynchronously(executorService, Utility.copy(this.recordedExchanges).values());
                this.recoverEntitiesAsynchronously(executorService, Utility.copy(this.recordedQueues).values());
                this.recoverEntitiesAsynchronously(executorService, Utility.copy(this.recordedBindings));
                this.recoverEntitiesAsynchronously(executorService, Utility.copy(this.consumers).values());
            }
            catch (Exception exception) {
                String string = "Caught an exception while recovering toplogy: " + exception.getMessage();
                TopologyRecoveryException topologyRecoveryException = new TopologyRecoveryException(string, exception);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, null, topologyRecoveryException);
            }
        }
    }

    private void recoverExchange(RecordedExchange recordedExchange, boolean bl2) {
        try {
            if (this.topologyRecoveryFilter.filterExchange(recordedExchange)) {
                if (bl2) {
                    final RecordedExchange recordedExchange2 = recordedExchange;
                    recordedExchange = (RecordedExchange)this.wrapRetryIfNecessary(recordedExchange, new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            recordedExchange2.recover();
                            return null;
                        }
                    }).getRecordedEntity();
                } else {
                    recordedExchange.recover();
                }
                LOGGER.debug("{} has recovered", (Object)recordedExchange);
            }
        }
        catch (Exception exception) {
            String string = "Caught an exception while recovering exchange " + recordedExchange.getName() + ": " + exception.getMessage();
            TopologyRecoveryException topologyRecoveryException = new TopologyRecoveryException(string, exception);
            this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, recordedExchange.getDelegateChannel(), topologyRecoveryException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverQueue(String string, RecordedQueue recordedQueue, boolean bl2) {
        block10: {
            try {
                Object object;
                if (!this.topologyRecoveryFilter.filterQueue(recordedQueue)) break block10;
                LOGGER.debug("Recovering {}", (Object)recordedQueue);
                if (bl2) {
                    object = recordedQueue;
                    recordedQueue = (RecordedQueue)this.wrapRetryIfNecessary(recordedQueue, new Callable<Void>((RecordedQueue)object){
                        final /* synthetic */ RecordedQueue val$entity;
                        {
                            this.val$entity = recordedQueue;
                        }

                        @Override
                        public Void call() throws Exception {
                            this.val$entity.recover();
                            return null;
                        }
                    }).getRecordedEntity();
                } else {
                    recordedQueue.recover();
                }
                object = recordedQueue.getName();
                if (!string.equals(object)) {
                    Map<String, RecordedQueue> map = this.recordedQueues;
                    synchronized (map) {
                        this.propagateQueueNameChangeToBindings(string, (String)object);
                        this.propagateQueueNameChangeToConsumers(string, (String)object);
                        if (recordedQueue.isServerNamed()) {
                            this.deleteRecordedQueue(string);
                        }
                        this.recordedQueues.put((String)object, recordedQueue);
                    }
                }
                for (QueueRecoveryListener queueRecoveryListener : Utility.copy(this.queueRecoveryListeners)) {
                    queueRecoveryListener.queueRecovered(string, (String)object);
                }
                LOGGER.debug("{} has recovered", (Object)recordedQueue);
            }
            catch (Exception exception) {
                String string2 = "Caught an exception while recovering queue " + string + ": " + exception.getMessage();
                TopologyRecoveryException topologyRecoveryException = new TopologyRecoveryException(string2, exception);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, recordedQueue.getDelegateChannel(), topologyRecoveryException);
            }
        }
    }

    private void recoverBinding(RecordedBinding recordedBinding, boolean bl2) {
        try {
            if (this.topologyRecoveryFilter.filterBinding(recordedBinding)) {
                if (bl2) {
                    final RecordedBinding recordedBinding2 = recordedBinding;
                    recordedBinding = (RecordedBinding)this.wrapRetryIfNecessary(recordedBinding, new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            recordedBinding2.recover();
                            return null;
                        }
                    }).getRecordedEntity();
                } else {
                    recordedBinding.recover();
                }
                LOGGER.debug("{} has recovered", (Object)recordedBinding);
            }
        }
        catch (Exception exception) {
            String string = "Caught an exception while recovering binding between " + recordedBinding.getSource() + " and " + recordedBinding.getDestination() + ": " + exception.getMessage();
            TopologyRecoveryException topologyRecoveryException = new TopologyRecoveryException(string, exception);
            this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, recordedBinding.getDelegateChannel(), topologyRecoveryException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverConsumer(String string, RecordedConsumer recordedConsumer, boolean bl2) {
        block9: {
            try {
                Map<String, RecordedConsumer> map;
                if (!this.topologyRecoveryFilter.filterConsumer(recordedConsumer)) break block9;
                LOGGER.debug("Recovering {}", (Object)recordedConsumer);
                String string2 = null;
                if (bl2) {
                    map = recordedConsumer;
                    RetryResult object = this.wrapRetryIfNecessary(recordedConsumer, new Callable<String>((RecordedConsumer)((Object)map)){
                        final /* synthetic */ RecordedConsumer val$entity;
                        {
                            this.val$entity = recordedConsumer;
                        }

                        @Override
                        public String call() throws Exception {
                            return this.val$entity.recover();
                        }
                    });
                    recordedConsumer = (RecordedConsumer)object.getRecordedEntity();
                    string2 = (String)object.getResult();
                } else {
                    string2 = recordedConsumer.recover();
                }
                if (string != null && !string.equals(string2)) {
                    map = this.consumers;
                    synchronized (map) {
                        this.consumers.remove(string);
                        this.consumers.put(string2, recordedConsumer);
                    }
                    recordedConsumer.getChannel().updateConsumerTag(string, string2);
                }
                for (ConsumerRecoveryListener consumerRecoveryListener : Utility.copy(this.consumerRecoveryListeners)) {
                    consumerRecoveryListener.consumerRecovered(string, string2);
                }
                LOGGER.debug("{} has recovered", (Object)recordedConsumer);
            }
            catch (Exception exception) {
                String string3 = "Caught an exception while recovering consumer " + string + ": " + exception.getMessage();
                TopologyRecoveryException topologyRecoveryException = new TopologyRecoveryException(string3, exception);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, recordedConsumer.getDelegateChannel(), topologyRecoveryException);
            }
        }
    }

    private <T> RetryResult wrapRetryIfNecessary(RecordedEntity recordedEntity, Callable<T> callable) throws Exception {
        if (this.retryHandler == null) {
            T t2 = callable.call();
            return new RetryResult(recordedEntity, t2);
        }
        try {
            T t3 = callable.call();
            return new RetryResult(recordedEntity, t3);
        }
        catch (Exception exception) {
            RetryResult retryResult;
            RetryContext retryContext = new RetryContext(recordedEntity, exception, this);
            if (recordedEntity instanceof RecordedQueue) {
                retryResult = this.retryHandler.retryQueueRecovery(retryContext);
            } else if (recordedEntity instanceof RecordedExchange) {
                retryResult = this.retryHandler.retryExchangeRecovery(retryContext);
            } else if (recordedEntity instanceof RecordedBinding) {
                retryResult = this.retryHandler.retryBindingRecovery(retryContext);
            } else if (recordedEntity instanceof RecordedConsumer) {
                retryResult = this.retryHandler.retryConsumerRecovery(retryContext);
            } else {
                throw new IllegalArgumentException("Unknown type of recorded entity: " + recordedEntity);
            }
            return retryResult;
        }
    }

    private void propagateQueueNameChangeToBindings(String string, String string2) {
        for (RecordedBinding recordedBinding : Utility.copy(this.recordedBindings)) {
            if (!recordedBinding.getDestination().equals(string)) continue;
            recordedBinding.setDestination(string2);
        }
    }

    private void propagateQueueNameChangeToConsumers(String string, String string2) {
        for (RecordedConsumer recordedConsumer : Utility.copy(this.consumers).values()) {
            if (!recordedConsumer.getQueue().equals(string)) continue;
            recordedConsumer.setQueue(string2);
        }
    }

    private void recoverEntitiesAsynchronously(ExecutorService executorService, Collection<? extends RecordedEntity> collection) throws InterruptedException {
        List<Future<Object>> list = executorService.invokeAll(this.groupEntitiesByChannel(collection));
        for (Future<Object> future : list) {
            if (!future.isDone()) {
                LOGGER.warn("Recovery task should be done {}", (Object)future);
                continue;
            }
            try {
                future.get(1L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                LOGGER.warn("Recovery task is done but returned an exception", exception);
            }
        }
    }

    private <E extends RecordedEntity> List<Callable<Object>> groupEntitiesByChannel(Collection<E> collection) {
        LinkedHashMap<Object, ArrayList<Object>> linkedHashMap = new LinkedHashMap<Object, ArrayList<Object>>();
        for (Object object : collection) {
            Object object2 = ((RecordedEntity)object).getChannel();
            ArrayList<Object> arrayList = (ArrayList<Object>)linkedHashMap.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                linkedHashMap.put(object2, arrayList);
            }
            arrayList.add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : linkedHashMap.values()) {
            arrayList.add(Executors.callable(new Runnable((List)object2){
                final /* synthetic */ List val$entityList;
                {
                    this.val$entityList = list;
                }

                @Override
                public void run() {
                    for (RecordedEntity recordedEntity : this.val$entityList) {
                        RecordedEntity recordedEntity2;
                        if (recordedEntity instanceof RecordedExchange) {
                            AutorecoveringConnection.this.recoverExchange((RecordedExchange)recordedEntity, true);
                            continue;
                        }
                        if (recordedEntity instanceof RecordedQueue) {
                            recordedEntity2 = (RecordedQueue)recordedEntity;
                            AutorecoveringConnection.this.recoverQueue(((RecordedNamedEntity)recordedEntity2).getName(), (RecordedQueue)recordedEntity2, true);
                            continue;
                        }
                        if (recordedEntity instanceof RecordedBinding) {
                            AutorecoveringConnection.this.recoverBinding((RecordedBinding)recordedEntity, true);
                            continue;
                        }
                        if (!(recordedEntity instanceof RecordedConsumer)) continue;
                        recordedEntity2 = (RecordedConsumer)recordedEntity;
                        AutorecoveringConnection.this.recoverConsumer(((RecordedConsumer)recordedEntity2).getConsumerTag(), (RecordedConsumer)recordedEntity2, true);
                    }
                }
            }));
        }
        return arrayList;
    }

    void recordQueueBinding(AutorecoveringChannel autorecoveringChannel, String string, String string2, String string3, Map<String, Object> map) {
        RecordedBinding recordedBinding = new RecordedQueueBinding(autorecoveringChannel).source(string2).destination(string).routingKey(string3).arguments(map);
        this.recordedBindings.remove(recordedBinding);
        this.recordedBindings.add(recordedBinding);
    }

    boolean deleteRecordedQueueBinding(AutorecoveringChannel autorecoveringChannel, String string, String string2, String string3, Map<String, Object> map) {
        RecordedBinding recordedBinding = new RecordedQueueBinding(autorecoveringChannel).source(string2).destination(string).routingKey(string3).arguments(map);
        return this.recordedBindings.remove(recordedBinding);
    }

    void recordExchangeBinding(AutorecoveringChannel autorecoveringChannel, String string, String string2, String string3, Map<String, Object> map) {
        RecordedBinding recordedBinding = new RecordedExchangeBinding(autorecoveringChannel).source(string2).destination(string).routingKey(string3).arguments(map);
        this.recordedBindings.remove(recordedBinding);
        this.recordedBindings.add(recordedBinding);
    }

    boolean deleteRecordedExchangeBinding(AutorecoveringChannel autorecoveringChannel, String string, String string2, String string3, Map<String, Object> map) {
        RecordedBinding recordedBinding = new RecordedExchangeBinding(autorecoveringChannel).source(string2).destination(string).routingKey(string3).arguments(map);
        return this.recordedBindings.remove(recordedBinding);
    }

    void recordQueue(AMQP.Queue.DeclareOk declareOk, RecordedQueue recordedQueue) {
        this.recordedQueues.put(declareOk.getQueue(), recordedQueue);
    }

    void recordQueue(String string, RecordedQueue recordedQueue) {
        this.recordedQueues.put(string, recordedQueue);
    }

    void deleteRecordedQueue(String string) {
        this.recordedQueues.remove(string);
        Set<RecordedBinding> set = this.removeBindingsWithDestination(string);
        for (RecordedBinding recordedBinding : set) {
            this.maybeDeleteRecordedAutoDeleteExchange(recordedBinding.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeQueueFromRecovery(String string, boolean bl2) {
        if (bl2) {
            Map<String, RecordedConsumer> map = this.consumers;
            synchronized (map) {
                Map<String, RecordedQueue> map2 = this.recordedQueues;
                synchronized (map2) {
                    if (!this.hasMoreConsumersOnQueue(this.consumers.values(), string)) {
                        this.deleteRecordedQueue(string);
                    }
                }
            }
        }
        this.deleteRecordedQueue(string);
    }

    void recordExchange(String string, RecordedExchange recordedExchange) {
        this.recordedExchanges.put(string, recordedExchange);
    }

    void deleteRecordedExchange(String string) {
        this.recordedExchanges.remove(string);
        Set<RecordedBinding> set = this.removeBindingsWithDestination(string);
        for (RecordedBinding recordedBinding : set) {
            this.maybeDeleteRecordedAutoDeleteExchange(recordedBinding.getSource());
        }
    }

    void recordConsumer(String string, RecordedConsumer recordedConsumer) {
        this.consumers.put(string, recordedConsumer);
    }

    RecordedConsumer deleteRecordedConsumer(String string) {
        return this.consumers.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDeleteRecordedAutoDeleteQueue(String string) {
        Map<String, RecordedConsumer> map = this.consumers;
        synchronized (map) {
            Map<String, RecordedQueue> map2 = this.recordedQueues;
            synchronized (map2) {
                RecordedQueue recordedQueue;
                if (!this.hasMoreConsumersOnQueue(this.consumers.values(), string) && (recordedQueue = this.recordedQueues.get(string)) != null && recordedQueue.isAutoDelete()) {
                    this.deleteRecordedQueue(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDeleteRecordedAutoDeleteExchange(String string) {
        Map<String, RecordedConsumer> map = this.consumers;
        synchronized (map) {
            Map<String, RecordedExchange> map2 = this.recordedExchanges;
            synchronized (map2) {
                RecordedExchange recordedExchange;
                if (!this.hasMoreDestinationsBoundToExchange(Utility.copy(this.recordedBindings), string) && (recordedExchange = this.recordedExchanges.get(string)) != null && recordedExchange.isAutoDelete()) {
                    this.deleteRecordedExchange(string);
                }
            }
        }
    }

    boolean hasMoreDestinationsBoundToExchange(List<RecordedBinding> list, String string) {
        boolean bl2 = false;
        for (RecordedBinding recordedBinding : list) {
            if (!string.equals(recordedBinding.getSource())) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    boolean hasMoreConsumersOnQueue(Collection<RecordedConsumer> collection, String string) {
        boolean bl2 = false;
        for (RecordedConsumer recordedConsumer : collection) {
            if (!string.equals(recordedConsumer.getQueue())) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<RecordedBinding> removeBindingsWithDestination(String string) {
        HashSet<RecordedBinding> hashSet = new HashSet<RecordedBinding>();
        List<RecordedBinding> list = this.recordedBindings;
        synchronized (list) {
            Iterator<RecordedBinding> iterator = this.recordedBindings.iterator();
            while (iterator.hasNext()) {
                RecordedBinding recordedBinding = iterator.next();
                if (!recordedBinding.getDestination().equals(string)) continue;
                iterator.remove();
                hashSet.add(recordedBinding);
            }
        }
        return hashSet;
    }

    public Map<String, RecordedQueue> getRecordedQueues() {
        return this.recordedQueues;
    }

    public Map<String, RecordedExchange> getRecordedExchanges() {
        return this.recordedExchanges;
    }

    public List<RecordedBinding> getRecordedBindings() {
        return this.recordedBindings;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public void setId(String string) {
        this.delegate.setId(string);
    }
}

