/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.BulkheadConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.BulkheadFullException;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.BulkheadImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class BulkheadExecutor<R>
extends PolicyExecutor<R> {
    private final BulkheadImpl<R> bulkhead;
    private final Duration maxWaitTime;

    public BulkheadExecutor(BulkheadImpl<R> bulkheadImpl, int n2) {
        super(bulkheadImpl, n2);
        this.bulkhead = bulkheadImpl;
        this.maxWaitTime = ((BulkheadConfig)bulkheadImpl.getConfig()).getMaxWaitTime();
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        try {
            return this.bulkhead.tryAcquirePermit(this.maxWaitTime) ? null : ExecutionResult.exception(new BulkheadFullException(this.bulkhead));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return ExecutionResult.exception(interruptedException);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture<Void> completableFuture2 = this.bulkhead.acquirePermitAsync();
        completableFuture2.whenComplete((void_, throwable) -> completableFuture.complete(ExecutionResult.none()));
        if (!completableFuture.isDone()) {
            try {
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(() -> {
                    completableFuture.complete(ExecutionResult.exception(new BulkheadFullException(this.bulkhead)));
                    completableFuture2.cancel(true);
                    return null;
                }, this.maxWaitTime.toNanos(), TimeUnit.NANOSECONDS);
                failsafeFuture.setCancelFn(this, (bl2, executionResult) -> {
                    completableFuture.complete((ExecutionResult)executionResult);
                    completableFuture2.cancel((boolean)bl2);
                    scheduledFuture.cancel((boolean)bl2);
                });
            }
            catch (Throwable throwable2) {
                completableFuture.completeExceptionally(throwable2);
            }
        }
        return completableFuture;
    }

    @Override
    public void onSuccess(ExecutionResult<R> executionResult) {
        this.bulkhead.releasePermit();
    }

    @Override
    protected ExecutionResult<R> onFailure(ExecutionContext<R> executionContext, ExecutionResult<R> executionResult) {
        this.bulkhead.releasePermit();
        return executionResult;
    }
}

