/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.FallbackConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.EventHandler;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.FallbackImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.AsyncExecutionInternal;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class FallbackExecutor<R>
extends PolicyExecutor<R> {
    private final FallbackImpl<R> fallback;
    private final FallbackConfig<R> config;
    private final EventHandler<R> failedAttemptHandler;

    public FallbackExecutor(FallbackImpl<R> fallbackImpl, int n2) {
        super(fallbackImpl, n2);
        this.fallback = fallbackImpl;
        this.config = fallbackImpl.getConfig();
        this.failedAttemptHandler = EventHandler.ofExecutionAttempted(this.config.getFailedAttemptListener());
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> function, Scheduler scheduler) {
        return syncExecutionInternal -> {
            ExecutionResult<R> executionResult = (ExecutionResult<R>)function.apply((SyncExecutionInternal<R>)syncExecutionInternal);
            if (syncExecutionInternal.isCancelled(this)) {
                return executionResult;
            }
            if (this.isFailure(executionResult)) {
                if (this.failedAttemptHandler != null) {
                    this.failedAttemptHandler.handle(executionResult, (ExecutionContext<R>)syncExecutionInternal);
                }
                try {
                    executionResult = this.fallback == FallbackImpl.NONE ? executionResult.withNonResult() : executionResult.withResult(this.fallback.apply(executionResult.getResult(), executionResult.getException(), syncExecutionInternal));
                }
                catch (Throwable throwable) {
                    executionResult = ExecutionResult.exception(throwable);
                }
            }
            return this.postExecute(syncExecutionInternal, executionResult);
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        return asyncExecutionInternal -> ((CompletableFuture)function.apply((AsyncExecutionInternal<R>)asyncExecutionInternal)).thenCompose(executionResult2 -> {
            if (executionResult2 == null || failsafeFuture.isDone()) {
                return ExecutionResult.nullFuture();
            }
            if (asyncExecutionInternal.isCancelled(this)) {
                return CompletableFuture.completedFuture(executionResult2);
            }
            if (!this.isFailure(executionResult2)) {
                return this.postExecuteAsync(asyncExecutionInternal, executionResult2, scheduler, failsafeFuture);
            }
            if (this.failedAttemptHandler != null) {
                this.failedAttemptHandler.handle((ExecutionResult<R>)executionResult2, (ExecutionContext<R>)asyncExecutionInternal);
            }
            CompletableFuture completableFuture = new CompletableFuture();
            Callable<Object> callable = () -> {
                try {
                    CompletableFuture<R> completableFuture2 = this.fallback.applyStage(executionResult2.getResult(), executionResult2.getException(), asyncExecutionInternal);
                    completableFuture2.whenComplete((object, throwable) -> {
                        if (throwable instanceof CompletionException) {
                            throwable = throwable.getCause();
                        }
                        Object executionResult2 = throwable == null ? executionResult2.withResult(object) : ExecutionResult.exception(throwable);
                        completableFuture.complete(executionResult2);
                    });
                }
                catch (Throwable throwable2) {
                    completableFuture.complete(ExecutionResult.exception(throwable2));
                }
                return null;
            };
            try {
                if (!this.config.isAsync()) {
                    callable.call();
                } else {
                    ScheduledFuture<?> scheduledFuture = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                    failsafeFuture.setCancelFn(this, (bl2, executionResult) -> {
                        scheduledFuture.cancel((boolean)bl2);
                        completableFuture.complete(executionResult);
                    });
                }
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
            return completableFuture.thenCompose(executionResult -> this.postExecuteAsync(asyncExecutionInternal, executionResult, scheduler, failsafeFuture));
        });
    }
}

