/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.RateLimitExceededException;
import com.contrastsecurity.thirdparty.dev.failsafe.RateLimiterConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.RateLimiterImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RateLimiterExecutor<R>
extends PolicyExecutor<R> {
    private final RateLimiterImpl<R> rateLimiter;
    private final Duration maxWaitTime;

    public RateLimiterExecutor(RateLimiterImpl<R> rateLimiterImpl, int n2) {
        super(rateLimiterImpl, n2);
        this.rateLimiter = rateLimiterImpl;
        this.maxWaitTime = ((RateLimiterConfig)rateLimiterImpl.getConfig()).getMaxWaitTime();
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        try {
            return this.rateLimiter.tryAcquirePermit(this.maxWaitTime) ? null : ExecutionResult.exception(new RateLimitExceededException(this.rateLimiter));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return ExecutionResult.exception(interruptedException);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        CompletableFuture completableFuture = new CompletableFuture();
        long l2 = this.rateLimiter.reservePermits(1, this.maxWaitTime);
        if (l2 == -1L) {
            completableFuture.complete(ExecutionResult.exception(new RateLimitExceededException(this.rateLimiter)));
        } else {
            try {
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(() -> {
                    completableFuture.complete(ExecutionResult.none());
                    return null;
                }, l2, TimeUnit.NANOSECONDS);
                failsafeFuture.setCancelFn(this, (bl2, executionResult) -> {
                    completableFuture.complete((ExecutionResult)executionResult);
                    scheduledFuture.cancel((boolean)bl2);
                });
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        }
        return completableFuture;
    }
}

