/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.RateLimiter;
import com.contrastsecurity.thirdparty.dev.failsafe.RateLimiterConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.BurstyRateLimiterStats;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.RateLimiterExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.RateLimiterStats;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.SmoothRateLimiterStats;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Durations;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class RateLimiterImpl<R>
implements RateLimiter<R> {
    private final RateLimiterConfig<R> config;
    private final RateLimiterStats stats;

    public RateLimiterImpl(RateLimiterConfig<R> rateLimiterConfig) {
        this(rateLimiterConfig, new RateLimiterStats.Stopwatch());
    }

    RateLimiterImpl(RateLimiterConfig<R> rateLimiterConfig, RateLimiterStats.Stopwatch stopwatch) {
        this.config = rateLimiterConfig;
        this.stats = rateLimiterConfig.getMaxRate() != null ? new SmoothRateLimiterStats(rateLimiterConfig, stopwatch) : new BurstyRateLimiterStats(rateLimiterConfig, stopwatch);
    }

    @Override
    public RateLimiterConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public void acquirePermits(int n2) throws InterruptedException {
        long l2 = this.reservePermits(n2).toNanos();
        if (l2 > 0L) {
            TimeUnit.NANOSECONDS.sleep(l2);
        }
    }

    @Override
    public Duration reservePermits(int n2) {
        Assert.isTrue(n2 > 0, "permits must be > 0", new Object[0]);
        return Duration.ofNanos(this.stats.acquirePermits(n2, null));
    }

    @Override
    public boolean tryAcquirePermits(int n2) {
        return this.reservePermits(n2, Duration.ZERO) == 0L;
    }

    @Override
    public boolean tryAcquirePermits(int n2, Duration duration) throws InterruptedException {
        long l2 = this.reservePermits(n2, duration);
        if (l2 == -1L) {
            return false;
        }
        if (l2 > 0L) {
            TimeUnit.NANOSECONDS.sleep(l2);
        }
        return true;
    }

    @Override
    public Duration tryReservePermits(int n2, Duration duration) {
        return Duration.ofNanos(this.reservePermits(n2, duration));
    }

    @Override
    public PolicyExecutor<R> toExecutor(int n2) {
        return new RateLimiterExecutor(this, n2);
    }

    long reservePermits(int n2, Duration duration) {
        Assert.isTrue(n2 > 0, "permits must be > 0", new Object[0]);
        Assert.notNull(duration, "maxWaitTime");
        return this.stats.acquirePermits(n2, Durations.ofSafeNanos(duration));
    }
}

