/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.Timeout;
import com.contrastsecurity.thirdparty.dev.failsafe.TimeoutConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.TimeoutExceededException;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.TimeoutImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.AsyncExecutionInternal;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionInternal;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class TimeoutExecutor<R>
extends PolicyExecutor<R> {
    private final Timeout<R> policy;
    private final TimeoutConfig<R> config;

    public TimeoutExecutor(TimeoutImpl<R> timeoutImpl, int n2) {
        super(timeoutImpl, n2);
        this.policy = timeoutImpl;
        this.config = timeoutImpl.getConfig();
    }

    @Override
    public boolean isFailure(ExecutionResult<R> executionResult) {
        return !executionResult.isNonResult() && executionResult.getException() instanceof TimeoutExceededException;
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> function, Scheduler scheduler) {
        return syncExecutionInternal -> {
            ScheduledFuture<?> scheduledFuture;
            AtomicReference atomicReference = new AtomicReference();
            try {
                scheduledFuture = Scheduler.DEFAULT.schedule(() -> {
                    ExecutionResult executionResult = ExecutionResult.exception(new TimeoutExceededException(this.policy));
                    if (atomicReference.compareAndSet(null, executionResult)) {
                        Object object = syncExecutionInternal.getLock();
                        synchronized (object) {
                            ExecutionInternal executionInternal = syncExecutionInternal.getLatest();
                            executionInternal.record(executionResult);
                            executionInternal.cancel(this);
                            if (this.config.canInterrupt()) {
                                syncExecutionInternal.interrupt();
                            }
                        }
                    }
                    return null;
                }, this.config.getTimeout().toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (Throwable throwable) {
                return this.postExecute(syncExecutionInternal, ExecutionResult.exception(throwable));
            }
            if (atomicReference.compareAndSet(null, function.apply((SyncExecutionInternal<R>)syncExecutionInternal))) {
                scheduledFuture.cancel(false);
            }
            return this.postExecute(syncExecutionInternal, (ExecutionResult)atomicReference.get());
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        return asyncExecutionInternal -> {
            AtomicReference atomicReference = new AtomicReference();
            AtomicReference atomicReference2 = new AtomicReference();
            CompletableFuture completableFuture = new CompletableFuture();
            FailsafeFuture failsafeFuture2 = failsafeFuture;
            synchronized (failsafeFuture2) {
                if (!failsafeFuture.isDone() && !asyncExecutionInternal.isRecorded()) {
                    try {
                        ScheduledFuture<?> scheduledFuture = Scheduler.DEFAULT.schedule(() -> {
                            ExecutionResult executionResult = ExecutionResult.exception(new TimeoutExceededException(this.policy));
                            if (atomicReference.compareAndSet(null, executionResult)) {
                                Object object = asyncExecutionInternal.getLock();
                                synchronized (object) {
                                    ExecutionInternal executionInternal = asyncExecutionInternal.getLatest();
                                    executionInternal.record(executionResult);
                                    executionInternal.cancel(this);
                                    failsafeFuture.cancelDependencies(this, this.config.canInterrupt(), executionResult);
                                }
                            }
                            return null;
                        }, this.config.getTimeout().toNanos(), TimeUnit.NANOSECONDS);
                        atomicReference2.set(scheduledFuture);
                        failsafeFuture.setCancelFn(this, (bl2, executionResult) -> {
                            scheduledFuture.cancel((boolean)bl2);
                            atomicReference.compareAndSet(null, executionResult);
                        });
                    }
                    catch (Throwable throwable2) {
                        completableFuture.completeExceptionally(throwable2);
                        return completableFuture;
                    }
                }
            }
            ((CompletableFuture)function.apply((AsyncExecutionInternal<R>)asyncExecutionInternal)).whenComplete((executionResult, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return;
                }
                if (!atomicReference.compareAndSet(null, executionResult)) {
                    executionResult = (ExecutionResult)atomicReference.get();
                }
                if (executionResult != null) {
                    Future future = (Future)atomicReference2.get();
                    if (future != null && !future.isDone()) {
                        future.cancel(false);
                    }
                    this.postExecuteAsync(asyncExecutionInternal, executionResult, scheduler, failsafeFuture);
                }
                completableFuture.complete(executionResult);
            });
            return completableFuture;
        };
    }
}

