/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal.util;

import java.util.concurrent.CompletableFuture;

public final class FutureLinkedList {
    Node head;
    Node tail;

    public synchronized CompletableFuture<Void> add() {
        Node node = new Node();
        node.future = new CompletableFuture();
        node.future.whenComplete((void_, throwable) -> this.remove(node));
        if (this.head == null) {
            this.head = this.tail = node;
        } else {
            this.tail.next = node;
            node.previous = this.tail;
            this.tail = node;
        }
        return node.future;
    }

    public synchronized CompletableFuture<Void> pollFirst() {
        Node node = this.head;
        if (this.head != null) {
            this.head = this.head.next;
            if (this.head != null) {
                this.head.previous = null;
            }
        }
        return node == null ? null : node.future;
    }

    private synchronized void remove(Node node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        }
        if (this.head == node) {
            this.head = node.next;
        }
        if (this.tail == node) {
            this.tail = node.previous;
        }
    }

    static class Node {
        Node previous;
        Node next;
        CompletableFuture<Void> future;

        Node() {
        }
    }
}

