/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Automaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Datatypes;
import com.contrastsecurity.thirdparty.dk.brics.automaton.RegExp;
import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import com.contrastsecurity.thirdparty.dk.brics.automaton.StatePair;
import com.contrastsecurity.thirdparty.dk.brics.automaton.StringUnionOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class BasicAutomata {
    private BasicAutomata() {
    }

    public static Automaton makeEmpty() {
        Automaton automaton = new Automaton();
        automaton.initial = new State();
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeEmptyString() {
        Automaton automaton = new Automaton();
        automaton.singleton = "";
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeAnyString() {
        State state;
        Automaton automaton = new Automaton();
        automaton.initial = state = new State();
        state.accept = true;
        state.transitions.add(new Transition('\u0000', '\uffff', state));
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeCharRange('\u0000', '\uffff');
    }

    public static Automaton makeChar(char c2) {
        Automaton automaton = new Automaton();
        automaton.singleton = Character.toString(c2);
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeCharRange(char c2, char c3) {
        if (c2 == c3) {
            return BasicAutomata.makeChar(c2);
        }
        Automaton automaton = new Automaton();
        State state = new State();
        State state2 = new State();
        automaton.initial = state;
        state2.accept = true;
        if (c2 <= c3) {
            state.transitions.add(new Transition(c2, c3, state2));
        }
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeCharSet(String string) {
        if (string.length() == 1) {
            return BasicAutomata.makeChar(string.charAt(0));
        }
        Automaton automaton = new Automaton();
        State state = new State();
        State state2 = new State();
        automaton.initial = state;
        state2.accept = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            state.transitions.add(new Transition(string.charAt(i2), state2));
        }
        automaton.deterministic = true;
        automaton.reduce();
        return automaton;
    }

    private static State anyOfRightLength(String string, int n2) {
        State state = new State();
        if (string.length() == n2) {
            state.setAccept(true);
        } else {
            state.addTransition(new Transition('0', '9', BasicAutomata.anyOfRightLength(string, n2 + 1)));
        }
        return state;
    }

    private static State atLeast(String string, int n2, Collection<State> collection, boolean bl2) {
        State state = new State();
        if (string.length() == n2) {
            state.setAccept(true);
        } else {
            if (bl2) {
                collection.add(state);
            }
            char c2 = string.charAt(n2);
            state.addTransition(new Transition(c2, BasicAutomata.atLeast(string, n2 + 1, collection, bl2 && c2 == '0')));
            if (c2 < '9') {
                state.addTransition(new Transition((char)(c2 + '\u0001'), '9', BasicAutomata.anyOfRightLength(string, n2 + 1)));
            }
        }
        return state;
    }

    private static State atMost(String string, int n2) {
        State state = new State();
        if (string.length() == n2) {
            state.setAccept(true);
        } else {
            char c2 = string.charAt(n2);
            state.addTransition(new Transition(c2, BasicAutomata.atMost(string, (char)n2 + '\u0001')));
            if (c2 > '0') {
                state.addTransition(new Transition('0', (char)(c2 - '\u0001'), BasicAutomata.anyOfRightLength(string, n2 + 1)));
            }
        }
        return state;
    }

    private static State between(String string, String string2, int n2, Collection<State> collection, boolean bl2) {
        State state = new State();
        if (string.length() == n2) {
            state.setAccept(true);
        } else {
            char c2;
            char c3;
            if (bl2) {
                collection.add(state);
            }
            if ((c3 = string.charAt(n2)) == (c2 = string2.charAt(n2))) {
                state.addTransition(new Transition(c3, BasicAutomata.between(string, string2, n2 + 1, collection, bl2 && c3 == '0')));
            } else {
                state.addTransition(new Transition(c3, BasicAutomata.atLeast(string, n2 + 1, collection, bl2 && c3 == '0')));
                state.addTransition(new Transition(c2, BasicAutomata.atMost(string2, n2 + 1)));
                if (c3 + '\u0001' < c2) {
                    state.addTransition(new Transition((char)(c3 + '\u0001'), (char)(c2 - '\u0001'), BasicAutomata.anyOfRightLength(string, n2 + 1)));
                }
            }
        }
        return state;
    }

    public static Automaton makeInterval(int n2, int n3, int n4) throws IllegalArgumentException {
        Automaton automaton = new Automaton();
        String string = Integer.toString(n2);
        String string2 = Integer.toString(n3);
        if (n2 > n3 || n4 > 0 && string2.length() > n4) {
            throw new IllegalArgumentException();
        }
        int n5 = n4 > 0 ? n4 : string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = string.length(); i2 < n5; ++i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        string = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i3 = string2.length(); i3 < n5; ++i3) {
            stringBuilder2.append('0');
        }
        stringBuilder2.append(string2);
        string2 = stringBuilder2.toString();
        ArrayList<State> arrayList = new ArrayList<State>();
        automaton.initial = BasicAutomata.between(string, string2, 0, arrayList, n4 <= 0);
        if (n4 <= 0) {
            ArrayList<StatePair> arrayList2 = new ArrayList<StatePair>();
            for (State state : arrayList) {
                if (automaton.initial == state) continue;
                arrayList2.add(new StatePair(automaton.initial, state));
            }
            automaton.addEpsilons(arrayList2);
            automaton.initial.addTransition(new Transition('0', automaton.initial));
            automaton.deterministic = false;
        } else {
            automaton.deterministic = true;
        }
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton makeString(String string) {
        Automaton automaton = new Automaton();
        automaton.singleton = string;
        automaton.deterministic = true;
        return automaton;
    }

    public static Automaton makeStringUnion(CharSequence ... charSequenceArray) {
        if (charSequenceArray.length == 0) {
            return BasicAutomata.makeEmpty();
        }
        Arrays.sort(charSequenceArray, StringUnionOperations.LEXICOGRAPHIC_ORDER);
        Automaton automaton = new Automaton();
        automaton.setInitialState(StringUnionOperations.build(charSequenceArray));
        automaton.setDeterministic(true);
        automaton.reduce();
        automaton.recomputeHashCode();
        return automaton;
    }

    public static Automaton makeMaxInteger(String string) {
        int n2;
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == '0'; ++n2) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0*(0|");
        if (n2 < string.length()) {
            stringBuilder.append("[0-9]{1,").append(string.length() - n2 - 1).append("}|");
        }
        BasicAutomata.maxInteger(string.substring(n2), 0, stringBuilder);
        stringBuilder.append(")");
        return Automaton.minimize(new RegExp(stringBuilder.toString()).toAutomaton());
    }

    private static void maxInteger(String string, int n2, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        if (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '0') {
                stringBuilder.append("[0-").append((char)(c2 - '\u0001')).append("][0-9]{").append(string.length() - n2 - 1).append("}|");
            }
            stringBuilder.append(c2);
            BasicAutomata.maxInteger(string, n2 + 1, stringBuilder);
        }
        stringBuilder.append(')');
    }

    public static Automaton makeMinInteger(String string) {
        int n2 = 0;
        while (n2 + 1 < string.length() && string.charAt(n2) == '0') {
            ++n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0*");
        BasicAutomata.minInteger(string.substring(n2), 0, stringBuilder);
        stringBuilder.append("[0-9]*");
        return Automaton.minimize(new RegExp(stringBuilder.toString()).toAutomaton());
    }

    private static void minInteger(String string, int n2, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        if (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '9') {
                stringBuilder.append("[").append((char)(c2 + '\u0001')).append("-9][0-9]{").append(string.length() - n2 - 1).append("}|");
            }
            stringBuilder.append(c2);
            BasicAutomata.minInteger(string, n2 + 1, stringBuilder);
        }
        stringBuilder.append(')');
    }

    public static Automaton makeTotalDigits(int n2) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?0*([0-9]{0," + n2 + "}|((([0-9]\\.*){0," + n2 + "})&@\\.@)0*)[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeFractionDigits(int n2) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?[0-9]+(\\.[0-9]{0," + n2 + "}0*)?[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeIntegerValue(String string) {
        int n2;
        boolean bl2 = false;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '-') {
                bl2 = true;
            }
            if (c2 >= '1' && c2 <= '9') break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(n2));
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0");
        }
        Automaton automaton = bl2 ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton automaton2 = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(automaton2.concatenate(automaton.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(stringBuilder.toString()))).concatenate(automaton2));
    }

    public static Automaton makeDecimalValue(String string) {
        int n2;
        boolean bl2 = false;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '-') {
                bl2 = true;
            }
            if (c2 >= '1' && c2 <= '9' || c2 == '.') break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n3 = string.indexOf(46, n2);
        if (n3 == -1) {
            stringBuilder.append(string.substring(n2));
        } else {
            char c3;
            stringBuilder.append(string.substring(n2, n3));
            for (n2 = string.length() - 1; n2 > n3 && ((c3 = string.charAt(n2)) < '1' || c3 > '9'); --n2) {
            }
            stringBuilder2.append(string.substring(n3 + 1, n2 + 1));
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0");
        }
        Automaton automaton = bl2 ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton automaton2 = stringBuilder2.length() == 0 ? Automaton.makeChar('.').concatenate(Automaton.makeChar('0').repeat(1)).optional() : Automaton.makeChar('.').concatenate(Automaton.makeString(stringBuilder2.toString())).concatenate(Automaton.makeChar('0').repeat());
        Automaton automaton3 = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(automaton3.concatenate(automaton.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(stringBuilder.toString())).concatenate(automaton2)).concatenate(automaton3));
    }

    public static Automaton makeStringMatcher(String string) {
        Automaton automaton = new Automaton();
        State[] stateArray = new State[string.length() + 1];
        stateArray[0] = automaton.initial;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            stateArray[i2 + 1] = new State();
        }
        State state = stateArray[string.length()];
        state.accept = true;
        state.transitions.add(new Transition('\u0000', '\uffff', state));
        for (int i3 = 0; i3 < string.length(); ++i3) {
            int n2;
            char c2;
            HashSet<Character> hashSet = new HashSet<Character>();
            char c3 = string.charAt(i3);
            stateArray[i3].transitions.add(new Transition(c3, stateArray[i3 + 1]));
            hashSet.add(Character.valueOf(c3));
            for (int i4 = i3; i4 >= 1; --i4) {
                c2 = string.charAt(i4 - 1);
                if (hashSet.contains(Character.valueOf(c2)) || !string.substring(0, i4 - 1).equals(string.substring(i3 - i4 + 1, i3))) continue;
                stateArray[i3].transitions.add(new Transition(c2, stateArray[i4]));
                hashSet.add(Character.valueOf(c2));
            }
            char[] cArray = new char[hashSet.size()];
            c2 = '\u0000';
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                n2 = ((Character)iterator.next()).charValue();
                cArray[c2++] = n2;
            }
            Arrays.sort(cArray);
            int n3 = 0;
            n2 = 0;
            while (n3 <= 65535) {
                while (n2 < cArray.length && cArray[n2] == n3) {
                    ++n2;
                    ++n3;
                }
                if (n3 > 65535) continue;
                int n4 = 65535;
                if (n2 < cArray.length) {
                    n4 = cArray[n2] - '\u0001';
                    ++n2;
                }
                stateArray[i3].transitions.add(new Transition((char)n3, (char)n4, stateArray[0]));
                n3 = n4 + 2;
            }
        }
        automaton.deterministic = true;
        return automaton;
    }
}

