/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Automaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.AutomatonMatcher;
import com.contrastsecurity.thirdparty.dk.brics.automaton.RunAutomatonElements;
import com.contrastsecurity.thirdparty.dk.brics.automaton.SpecialOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;

public class RunAutomaton
implements Serializable {
    static final long serialVersionUID = 20001L;
    int size;
    boolean[] accept;
    int initial;
    int[] transitions;
    char[] points;
    int[] classmap;
    private int options;
    private int maxClassPos;
    private int maxClassValue;
    public static final int OPT_FOR_PERF = 1;
    public static final int OPT_FOR_MEM = 2;
    public static final int OPT_FOR_BALANCE = 3;

    public RunAutomaton(RunAutomatonElements runAutomatonElements) {
        this.size = runAutomatonElements.size;
        this.initial = runAutomatonElements.initialState;
        this.accept = runAutomatonElements.accept;
        this.transitions = runAutomatonElements.transitions;
        this.points = runAutomatonElements.points;
        this.classmap = runAutomatonElements.classmap;
        this.options = runAutomatonElements.options;
        this.maxClassValue = runAutomatonElements.maxClassValue;
        this.maxClassPos = runAutomatonElements.maxClassPos;
    }

    void setAlphabet() {
        if (this.options == 1) {
            this.setAlphabetFullRange();
        } else if (this.options == 3) {
            this.setAlphabetBalanced();
        }
    }

    private void setAlphabetBalanced() {
        int n2 = 0;
        char[] cArray = this.points;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = cArray[i2];
            if (n4 <= n2) continue;
            n2 = n4;
        }
        this.classmap = new int[n2 + 1];
        int n5 = 0;
        for (n3 = 0; n3 <= n2; ++n3) {
            if (n5 + 1 >= this.points.length || n3 == this.points[n5 + 1]) {
                // empty if block
            }
            this.classmap[n3] = ++n5;
        }
        this.maxClassPos = n2;
        this.maxClassValue = n5;
    }

    private void setAlphabetFullRange() {
        this.classmap = new int[65536];
        int n2 = 0;
        for (char c2 = '\u0000'; c2 <= '\uffff'; ++c2) {
            if (n2 + 1 >= this.points.length || c2 == this.points[n2 + 1]) {
                // empty if block
            }
            this.classmap[c2] = ++n2;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("initial state: ").append(this.initial).append("\n");
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuilder.append("state ").append(i2);
            if (this.accept[i2]) {
                stringBuilder.append(" [accept]:\n");
            } else {
                stringBuilder.append(" [reject]:\n");
            }
            for (int i3 = 0; i3 < this.points.length; ++i3) {
                int n2 = this.transitions[i2 * this.points.length + i3];
                if (n2 == -1) continue;
                char c2 = this.points[i3];
                char c3 = i3 + 1 < this.points.length ? (char)((char)(this.points[i3 + 1] - '\u0001')) : (char)'\uffff';
                stringBuilder.append(" ");
                Transition.appendCharString(c2, stringBuilder);
                if (c2 != c3) {
                    stringBuilder.append("-");
                    Transition.appendCharString(c3, stringBuilder);
                }
                stringBuilder.append(" -> ").append(n2).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isAccept(int n2) {
        return this.accept[n2];
    }

    public int getInitialState() {
        return this.initial;
    }

    public char[] getCharIntervals() {
        return (char[])this.points.clone();
    }

    int getCharClass(char c2) {
        return SpecialOperations.findIndex(c2, this.points);
    }

    public boolean[] getAccept() {
        return this.accept;
    }

    public int[] getTransitions() {
        return this.transitions;
    }

    public char[] getPoints() {
        return this.points;
    }

    public int[] getClassMap() {
        return this.classmap;
    }

    private RunAutomaton() {
    }

    public RunAutomaton(Automaton automaton) {
        this(automaton, true, null);
    }

    public static RunAutomaton load(URL uRL) throws IOException, ClassCastException, ClassNotFoundException {
        return RunAutomaton.load(uRL.openStream());
    }

    public static RunAutomaton load(InputStream inputStream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (RunAutomaton)objectInputStream.readObject();
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public RunAutomaton(Automaton automaton, boolean bl2) {
        this(automaton, bl2, null);
    }

    public RunAutomaton(Automaton automaton, int n2) {
        this(automaton, n2, null);
    }

    protected RunAutomaton(Automaton automaton, boolean bl2, Integer n2) {
        this(automaton, bl2 ? 1 : 2, n2);
    }

    protected RunAutomaton(Automaton automaton, int n2, Integer n3) {
        if (n2 == 0) {
            throw new IllegalStateException("Flags must be set");
        }
        automaton.determinize();
        this.points = automaton.getStartPoints();
        Set<State> set = automaton.getStates();
        Automaton.setStateNumbers(set);
        this.initial = automaton.initial.number;
        this.size = set.size();
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        boolean bl2 = n3 != null;
        int n4 = bl2 ? n3 : 0;
        for (int i2 = 0; i2 < this.size * this.points.length; ++i2) {
            this.transitions[i2] = -1;
        }
        for (State state : set) {
            int n5 = state.number;
            this.accept[n5] = state.accept;
            for (int i3 = 0; i3 < this.points.length; ++i3) {
                State state2 = state.step(this.points[i3]);
                if (state2 == null) continue;
                this.transitions[n5 * this.points.length + i3] = this.transition(state2, bl2, n4);
            }
        }
        this.options = n2;
        if (n2 == 3 || n2 == 1) {
            this.setAlphabet();
        }
    }

    private int transition(State state, boolean bl2, int n2) {
        return bl2 && state.number != -1 && state.accept ? n2 : state.number;
    }

    public int step(int n2, char c2) {
        if (this.options == 1) {
            return this.transitions[n2 * this.points.length + this.classmap[c2 - '\u0000']];
        }
        if (this.options == 2) {
            return this.transitions[n2 * this.points.length + this.getCharClass(c2)];
        }
        return this.transitions[n2 * this.points.length + this.getCharClassBalanced(c2)];
    }

    private int getCharClassBalanced(char c2) {
        if (c2 > this.maxClassPos) {
            return this.maxClassValue;
        }
        return this.classmap[c2];
    }

    public boolean run(String string) {
        int n2 = this.initial;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if ((n2 = this.step(n2, string.charAt(i2))) != -1) continue;
            return false;
        }
        return this.accept[n2];
    }

    public int run(String string, int n2) {
        int n3 = this.initial;
        int n4 = string.length();
        int n5 = -1;
        int n6 = 0;
        while (n2 <= n4) {
            if (this.accept[n3]) {
                n5 = n6;
            }
            if (n2 == n4 || (n3 = this.step(n3, string.charAt(n2))) == -1) break;
            ++n2;
            ++n6;
        }
        return n5;
    }

    public AutomatonMatcher newMatcher(CharSequence charSequence) {
        return new AutomatonMatcher(charSequence, this);
    }

    public AutomatonMatcher newMatcher(CharSequence charSequence, int n2, int n3) {
        return new AutomatonMatcher(charSequence.subSequence(n2, n3), this);
    }

    public RunAutomatonElements elements() {
        return new RunAutomatonElements.Builder().size(this.size).initialState(this.initial).accept(this.accept).transitions(this.transitions).points(this.points).classMap(this.classmap).options(this.options).maxClassPos(this.maxClassPos).maxClassValue(this.maxClassValue).build();
    }
}

