/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.NamedThreadFactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class HighCardinalityTagsDetector
implements AutoCloseable {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(HighCardinalityTagsDetector.class);
    private static final WarnThenDebugLogger WARN_THEN_DEBUG_LOGGER = new WarnThenDebugLogger(HighCardinalityTagsDetector.class);
    private static final Duration DEFAULT_DELAY = Duration.ofMinutes(5L);
    private final MeterRegistry registry;
    private final long threshold;
    private final Consumer<String> meterNameConsumer;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Duration delay;

    public HighCardinalityTagsDetector(MeterRegistry meterRegistry) {
        this(meterRegistry, HighCardinalityTagsDetector.calculateThreshold(), DEFAULT_DELAY);
    }

    public HighCardinalityTagsDetector(MeterRegistry meterRegistry, long l2, Duration duration) {
        this(meterRegistry, l2, duration, null);
    }

    public HighCardinalityTagsDetector(MeterRegistry meterRegistry, long l2, Duration duration, @Nullable Consumer<String> consumer) {
        this.registry = meterRegistry;
        this.threshold = l2;
        this.delay = duration;
        this.meterNameConsumer = consumer != null ? consumer : this::logWarning;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("high-cardinality-tags-detector"));
    }

    public void start() {
        LOGGER.info(String.format("Starting %s with threshold: %d and delay: %s", this.getClass().getSimpleName(), this.threshold, this.delay));
        this.scheduledExecutorService.scheduleWithFixedDelay(this::detectHighCardinalityTags, 0L, this.delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        LOGGER.info("Stopping " + this.getClass().getSimpleName());
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private void detectHighCardinalityTags() {
        try {
            this.findFirst().ifPresent(this.meterNameConsumer);
        }
        catch (Exception exception) {
            LOGGER.warn("Something went wrong during high cardinality tag detection", exception);
        }
    }

    public Optional<String> findFirst() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Meter meter : this.registry.getMeters()) {
            String string = meter.getId().getName();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, 1L);
                continue;
            }
            Long l2 = (Long)hashMap.get(string);
            if (l2 < this.threshold) {
                hashMap.put(string, l2 + 1L);
                continue;
            }
            return Optional.of(string);
        }
        return Optional.empty();
    }

    private void logWarning(String string) {
        WARN_THEN_DEBUG_LOGGER.log(() -> String.format("It seems %s has high cardinality tags (threshold: %d meters).\nCheck your configuration for the instrumentation of %s to find and fix the cause of the high cardinality (see: https://micrometer.io/docs/concepts#_tag_values).\nIf the cardinality is expected and acceptable, raise the threshold for this %s.", string, this.threshold, string, this.getClass().getSimpleName()));
    }

    private static long calculateThreshold() {
        long l2 = Runtime.getRuntime().maxMemory() / 1024L / 1024L / 10L;
        return Math.max(1000L, Math.min(l2 * 2000L, 2000000L));
    }
}

