/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public abstract class AbstractMetricCollectingInterceptor {
    private static final String TAG_SERVICE_NAME = "service";
    private static final String TAG_METHOD_NAME = "method";
    private static final String TAG_METHOD_TYPE = "methodType";
    private static final String TAG_STATUS_CODE = "statusCode";
    private final Map<MethodDescriptor<?, ?>, MetricSet> metricsForMethods = new ConcurrentHashMap();
    protected final MeterRegistry registry;
    protected final UnaryOperator<Counter.Builder> counterCustomizer;
    protected final UnaryOperator<Timer.Builder> timerCustomizer;
    protected final Status.Code[] eagerInitializedCodes;

    protected static Counter.Builder prepareCounterFor(MethodDescriptor<?, ?> methodDescriptor, String string, String string2) {
        return Counter.builder(string).description(string2).baseUnit("messages").tag(TAG_SERVICE_NAME, methodDescriptor.getServiceName()).tag(TAG_METHOD_NAME, methodDescriptor.getBareMethodName()).tag(TAG_METHOD_TYPE, methodDescriptor.getType().name());
    }

    protected static Timer.Builder prepareTimerFor(MethodDescriptor<?, ?> methodDescriptor, String string, String string2) {
        return Timer.builder(string).description(string2).tag(TAG_SERVICE_NAME, methodDescriptor.getServiceName()).tag(TAG_METHOD_NAME, methodDescriptor.getBareMethodName()).tag(TAG_METHOD_TYPE, methodDescriptor.getType().name());
    }

    protected AbstractMetricCollectingInterceptor(MeterRegistry meterRegistry) {
        this(meterRegistry, UnaryOperator.identity(), UnaryOperator.identity(), Status.Code.OK);
    }

    protected AbstractMetricCollectingInterceptor(MeterRegistry meterRegistry, UnaryOperator<Counter.Builder> unaryOperator, UnaryOperator<Timer.Builder> unaryOperator2, Status.Code ... codeArray) {
        this.registry = meterRegistry;
        this.counterCustomizer = unaryOperator;
        this.timerCustomizer = unaryOperator2;
        this.eagerInitializedCodes = codeArray;
    }

    public void preregisterService(ServiceDescriptor serviceDescriptor) {
        for (MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
            this.preregisterMethod(methodDescriptor);
        }
    }

    public void preregisterMethod(MethodDescriptor<?, ?> methodDescriptor) {
        this.metricsFor(methodDescriptor);
    }

    protected final MetricSet metricsFor(MethodDescriptor<?, ?> methodDescriptor) {
        return this.metricsForMethods.computeIfAbsent(methodDescriptor, this::newMetricsFor);
    }

    protected MetricSet newMetricsFor(MethodDescriptor<?, ?> methodDescriptor) {
        return new MetricSet(this.newRequestCounterFor(methodDescriptor), this.newResponseCounterFor(methodDescriptor), this.newTimerFunction(methodDescriptor));
    }

    protected abstract Counter newRequestCounterFor(MethodDescriptor<?, ?> var1);

    protected abstract Counter newResponseCounterFor(MethodDescriptor<?, ?> var1);

    protected Function<Status.Code, Timer> asTimerFunction(Supplier<Timer.Builder> supplier) {
        EnumMap enumMap = new EnumMap(Status.Code.class);
        Function<Status.Code, Timer> function = code -> ((Timer.Builder)supplier.get()).tag(TAG_STATUS_CODE, code.name()).register(this.registry);
        Function<Status.Code, Timer> function2 = code -> (Timer)enumMap.computeIfAbsent((Status.Code)code, function);
        for (Status.Code code2 : this.eagerInitializedCodes) {
            function2.apply(code2);
        }
        return function2;
    }

    protected abstract Function<Status.Code, Timer> newTimerFunction(MethodDescriptor<?, ?> var1);

    protected static class MetricSet {
        private final Counter requestCounter;
        private final Counter responseCounter;
        private final Function<Status.Code, Timer> timerFunction;

        public MetricSet(Counter counter, Counter counter2, Function<Status.Code, Timer> function) {
            this.requestCounter = counter;
            this.responseCounter = counter2;
            this.timerFunction = function;
        }

        public Counter getRequestCounter() {
            return this.requestCounter;
        }

        public Counter getResponseCounter() {
            return this.responseCounter;
        }

        public Consumer<Status.Code> newProcessingDurationTiming(MeterRegistry meterRegistry) {
            Timer.Sample sample = Timer.start(meterRegistry);
            return code -> sample.stop(this.timerFunction.apply((Status.Code)code));
        }
    }
}

