/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcClientObservationContext;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.ObservationGrpcClientCallListener;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;

class ObservationGrpcClientCall<ReqT, RespT>
extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
    private final Observation observation;
    private Observation.Scope scope;

    ObservationGrpcClientCall(ClientCall<ReqT, RespT> clientCall, Observation observation) {
        super(clientCall);
        this.observation = observation;
    }

    public void start(ClientCall.Listener<RespT> listener, Metadata metadata) {
        ((GrpcClientObservationContext)this.observation.getContext()).setCarrier(metadata);
        this.scope = this.observation.start().openScope();
        try {
            super.start(new ObservationGrpcClientCallListener<RespT>(listener, this.scope), metadata);
        }
        catch (Throwable throwable) {
            this.handleFailure(throwable);
            throw throwable;
        }
    }

    public void halfClose() {
        try {
            super.halfClose();
        }
        catch (Throwable throwable) {
            this.handleFailure(throwable);
            throw throwable;
        }
    }

    public void sendMessage(ReqT ReqT) {
        this.observation.event(GrpcObservationDocumentation.GrpcClientEvents.MESSAGE_SENT);
        super.sendMessage(ReqT);
    }

    private void handleFailure(Throwable throwable) {
        this.scope.close();
        this.observation.error(throwable).stop();
    }
}

