/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.DefaultGrpcServerObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerCall;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerCallListener;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ObservationGrpcServerInterceptor
implements ServerInterceptor {
    private static final GrpcServerObservationConvention DEFAULT_CONVENTION = new DefaultGrpcServerObservationConvention();
    private static final Map<String, Metadata.Key<String>> KEY_CACHE = new ConcurrentHashMap<String, Metadata.Key<String>>();
    private final ObservationRegistry registry;
    @Nullable
    private GrpcServerObservationConvention customConvention;

    public ObservationGrpcServerInterceptor(ObservationRegistry observationRegistry) {
        this.registry = observationRegistry;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Supplier<GrpcServerObservationContext> supplier = () -> {
            GrpcServerObservationContext grpcServerObservationContext = new GrpcServerObservationContext((metadata, string) -> {
                Metadata.Key key = KEY_CACHE.computeIfAbsent(string, string2 -> Metadata.Key.of((String)string, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                return (String)metadata.get(key);
            });
            grpcServerObservationContext.setCarrier(metadata);
            MethodDescriptor methodDescriptor = serverCall.getMethodDescriptor();
            String string2 = methodDescriptor.getServiceName();
            String string3 = methodDescriptor.getBareMethodName();
            String string4 = methodDescriptor.getFullMethodName();
            MethodDescriptor.MethodType methodType = methodDescriptor.getType();
            if (string2 != null) {
                grpcServerObservationContext.setServiceName(string2);
            }
            if (string3 != null) {
                grpcServerObservationContext.setMethodName(string3);
            }
            grpcServerObservationContext.setFullMethodName(string4);
            grpcServerObservationContext.setMethodType(methodType);
            grpcServerObservationContext.setAuthority(serverCall.getAuthority());
            return grpcServerObservationContext;
        };
        Observation observation = GrpcObservationDocumentation.SERVER.observation(this.customConvention, DEFAULT_CONVENTION, supplier, this.registry);
        if (observation.isNoop()) {
            return serverCallHandler.startCall(serverCall, metadata);
        }
        Observation.Scope scope = observation.start().openScope();
        ObservationGrpcServerCall<ReqT, RespT> observationGrpcServerCall = new ObservationGrpcServerCall<ReqT, RespT>(serverCall, scope);
        try {
            ServerCall.Listener listener = serverCallHandler.startCall(observationGrpcServerCall, metadata);
            return new ObservationGrpcServerCallListener(listener, scope);
        }
        catch (Exception exception) {
            scope.close();
            observation.error(exception).stop();
            throw exception;
        }
    }

    public void setCustomConvention(@Nullable GrpcServerObservationConvention grpcServerObservationConvention) {
        this.customConvention = grpcServerObservationConvention;
    }
}

