/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http.Outcome;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.ApacheHttpClientContext;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.ApacheHttpClientObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.DefaultApacheHttpClientObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.DefaultUriMapper;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.HttpContextUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.observation.ObservationOrTimerCompatibleInstrumentation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import com.contrastsecurity.thirdparty.org.apache.http.HttpClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpRequest;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpRequestExecutor;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;

@Incubating(since="1.2.0")
public class MicrometerHttpRequestExecutor
extends HttpRequestExecutor {
    @Deprecated
    public static final String DEFAULT_URI_PATTERN_HEADER = "URI_PATTERN";
    static final String METER_NAME = "httpcomponents.httpclient.request";
    private final MeterRegistry registry;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ApacheHttpClientObservationConvention convention;
    private final Function<HttpRequest, String> uriMapper;
    private final Iterable<Tag> extraTags;
    private final boolean exportTagsForRoute;

    private MicrometerHttpRequestExecutor(int n2, MeterRegistry meterRegistry, Function<HttpRequest, String> function, Iterable<Tag> iterable, boolean bl2, ObservationRegistry observationRegistry, @Nullable ApacheHttpClientObservationConvention apacheHttpClientObservationConvention) {
        super(n2);
        this.registry = Optional.ofNullable(meterRegistry).orElseThrow(() -> new IllegalArgumentException("registry is required but has been initialized with null"));
        this.uriMapper = Optional.ofNullable(function).orElseThrow(() -> new IllegalArgumentException("uriMapper is required but has been initialized with null"));
        this.extraTags = Optional.ofNullable(iterable).orElse(Collections.emptyList());
        this.exportTagsForRoute = bl2;
        this.observationRegistry = observationRegistry;
        this.convention = apacheHttpClientObservationConvention;
    }

    public static Builder builder(MeterRegistry meterRegistry) {
        return new Builder(meterRegistry);
    }

    @Override
    public HttpResponse execute(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        ObservationOrTimerCompatibleInstrumentation<ApacheHttpClientContext> observationOrTimerCompatibleInstrumentation = ObservationOrTimerCompatibleInstrumentation.start(this.registry, this.observationRegistry, () -> new ApacheHttpClientContext(httpRequest, httpContext, this.uriMapper, this.exportTagsForRoute), this.convention, DefaultApacheHttpClientObservationConvention.INSTANCE);
        String string = "UNKNOWN";
        Outcome outcome = Outcome.UNKNOWN;
        try {
            HttpResponse httpResponse = super.execute(httpRequest, httpClientConnection, httpContext);
            observationOrTimerCompatibleInstrumentation.setResponse(httpResponse);
            string = DefaultApacheHttpClientObservationConvention.INSTANCE.getStatusValue(httpResponse, null);
            outcome = DefaultApacheHttpClientObservationConvention.INSTANCE.getStatusOutcome(httpResponse);
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (HttpException | IOException | RuntimeException exception) {
            string = "IO_ERROR";
            observationOrTimerCompatibleInstrumentation.setThrowable(exception);
            throw exception;
        }
        finally {
            String string2 = string;
            String string3 = outcome.name();
            observationOrTimerCompatibleInstrumentation.stop(METER_NAME, "Duration of Apache HttpClient request execution", () -> Tags.of("method", DefaultApacheHttpClientObservationConvention.INSTANCE.getMethodString(httpRequest), "uri", this.uriMapper.apply(httpRequest), "status", string2, "outcome", string3).and(this.exportTagsForRoute ? HttpContextUtils.generateTagsForRoute(httpContext) : Tags.empty()).and(this.extraTags));
        }
    }

    public static class Builder {
        private final MeterRegistry registry;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private int waitForContinue = 3000;
        private Iterable<Tag> extraTags = Collections.emptyList();
        private Function<HttpRequest, String> uriMapper = new DefaultUriMapper();
        private boolean exportTagsForRoute = false;
        @Nullable
        private ApacheHttpClientObservationConvention observationConvention;

        Builder(MeterRegistry meterRegistry) {
            this.registry = meterRegistry;
        }

        public Builder waitForContinue(int n2) {
            this.waitForContinue = n2;
            return this;
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.extraTags = iterable;
            return this;
        }

        public Builder uriMapper(Function<HttpRequest, String> function) {
            this.uriMapper = function;
            return this;
        }

        public Builder exportTagsForRoute(boolean bl2) {
            this.exportTagsForRoute = bl2;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public Builder observationConvention(ApacheHttpClientObservationConvention apacheHttpClientObservationConvention) {
            this.observationConvention = apacheHttpClientObservationConvention;
            return this;
        }

        public MicrometerHttpRequestExecutor build() {
            return new MicrometerHttpRequestExecutor(this.waitForContinue, this.registry, this.uriMapper, this.extraTags, this.exportTagsForRoute, this.observationRegistry, this.observationConvention);
        }
    }
}

