/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jvm.JvmMemory;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

@NonNullApi
@NonNullFields
public class JvmGcMetrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(JvmGcMetrics.class);
    private final boolean managementExtensionsPresent = JvmGcMetrics.isManagementExtensionsPresent();
    final boolean isGenerationalGc = this.isGenerationalGcConfigured();
    private final Iterable<Tag> tags;
    @Nullable
    private String allocationPoolName;
    private final Set<String> longLivedPoolNames = new HashSet<String>();
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();
    private Counter allocatedBytes;
    @Nullable
    private Counter promotedBytes;
    private AtomicLong allocationPoolSizeAfter;
    private AtomicLong liveDataSize;
    private AtomicLong maxDataSize;
    GcMetricsNotificationListener gcNotificationListener;

    public JvmGcMetrics() {
        this(Collections.emptyList());
    }

    public JvmGcMetrics(Iterable<Tag> iterable) {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            String string = memoryPoolMXBean.getName();
            if (JvmMemory.isAllocationPool(string)) {
                this.allocationPoolName = string;
            }
            if (!JvmMemory.isLongLivedPool(string)) continue;
            this.longLivedPoolNames.add(string);
        }
        this.tags = iterable;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        if (!this.managementExtensionsPresent) {
            return;
        }
        this.gcNotificationListener = new GcMetricsNotificationListener(meterRegistry);
        double d2 = JvmMemory.getLongLivedHeapPools().mapToDouble(memoryPoolMXBean -> JvmMemory.getUsageValue(memoryPoolMXBean, MemoryUsage::getMax)).sum();
        this.maxDataSize = new AtomicLong((long)d2);
        Gauge.builder("jvm.gc.max.data.size", this.maxDataSize, AtomicLong::get).tags(this.tags).description("Max size of long-lived heap memory pool").baseUnit("bytes").register(meterRegistry);
        this.liveDataSize = new AtomicLong();
        Gauge.builder("jvm.gc.live.data.size", this.liveDataSize, AtomicLong::get).tags(this.tags).description("Size of long-lived heap memory pool after reclamation").baseUnit("bytes").register(meterRegistry);
        this.allocatedBytes = Counter.builder("jvm.gc.memory.allocated").tags(this.tags).baseUnit("bytes").description("Incremented for an increase in the size of the (young) heap memory pool after one GC to before the next").register(meterRegistry);
        this.promotedBytes = this.isGenerationalGc ? Counter.builder("jvm.gc.memory.promoted").tags(this.tags).baseUnit("bytes").description("Count of positive increases in the size of the old generation memory pool before GC to after GC").register(meterRegistry) : null;
        this.allocationPoolSizeAfter = new AtomicLong(0L);
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(garbageCollectorMXBean instanceof NotificationEmitter)) continue;
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)garbageCollectorMXBean);
            notificationEmitter.addNotificationListener(this.gcNotificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(this.gcNotificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    private boolean isGenerationalGcConfigured() {
        int n2 = 0;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!JvmMemory.isHeap(memoryPoolMXBean)) continue;
            String string = memoryPoolMXBean.getName();
            if (!string.contains("tenured") && ++n2 == 2) {
                return true;
            }
            if (!string.contains("GPGC")) continue;
            return true;
        }
        return false;
    }

    private static boolean isManagementExtensionsPresent() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            log.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, MemoryPoolMXBean.class.getClassLoader());
            return true;
        }
        catch (Throwable throwable) {
            log.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    class GcMetricsNotificationListener
    implements NotificationListener {
        private final MeterRegistry registry;

        GcMetricsNotificationListener(MeterRegistry meterRegistry) {
            this.registry = meterRegistry;
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            long l2;
            CompositeData compositeData = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = GarbageCollectionNotificationInfo.from(compositeData);
            String string2 = garbageCollectionNotificationInfo.getGcName();
            String string3 = garbageCollectionNotificationInfo.getGcCause();
            String string4 = garbageCollectionNotificationInfo.getGcAction();
            GcInfo gcInfo = garbageCollectionNotificationInfo.getGcInfo();
            long l3 = gcInfo.getDuration();
            Tags tags = Tags.of("gc", string2, "action", string4, "cause", string3).and(JvmGcMetrics.this.tags);
            if (JvmMemory.isConcurrentPhase(string3, string2)) {
                ((Timer.Builder)Timer.builder("jvm.gc.concurrent.phase.time").tags((Iterable)tags)).description("Time spent in concurrent phase").register(this.registry).record(l3, TimeUnit.MILLISECONDS);
            } else {
                ((Timer.Builder)Timer.builder("jvm.gc.pause").tags((Iterable)tags)).description("Time spent in GC pause").register(this.registry).record(l3, TimeUnit.MILLISECONDS);
            }
            Map<String, MemoryUsage> map = gcInfo.getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> map2 = gcInfo.getMemoryUsageAfterGc();
            this.countPoolSizeDelta(map, map2);
            long l4 = JvmGcMetrics.this.longLivedPoolNames.stream().mapToLong(string -> ((MemoryUsage)map.get(string)).getUsed()).sum();
            long l5 = JvmGcMetrics.this.longLivedPoolNames.stream().mapToLong(string -> ((MemoryUsage)map2.get(string)).getUsed()).sum();
            if (JvmGcMetrics.this.isGenerationalGc && (l2 = l5 - l4) > 0L) {
                JvmGcMetrics.this.promotedBytes.increment(l2);
            }
            if (l5 < l4 || this.shouldUpdateDataSizeMetrics(string2)) {
                JvmGcMetrics.this.liveDataSize.set(l5);
                JvmGcMetrics.this.maxDataSize.set(JvmGcMetrics.this.longLivedPoolNames.stream().mapToLong(string -> ((MemoryUsage)map2.get(string)).getMax()).sum());
            }
        }

        private void countPoolSizeDelta(Map<String, MemoryUsage> map, Map<String, MemoryUsage> map2) {
            if (JvmGcMetrics.this.allocationPoolName == null) {
                return;
            }
            long l2 = map.get(JvmGcMetrics.this.allocationPoolName).getUsed();
            long l3 = map2.get(JvmGcMetrics.this.allocationPoolName).getUsed();
            long l4 = l2 - JvmGcMetrics.this.allocationPoolSizeAfter.get();
            JvmGcMetrics.this.allocationPoolSizeAfter.set(l3);
            if (l4 > 0L) {
                JvmGcMetrics.this.allocatedBytes.increment(l4);
            }
        }

        private boolean shouldUpdateDataSizeMetrics(String string) {
            return this.nonGenerationalGcShouldUpdateDataSize(string) || this.isMajorGenerationalGc(string);
        }

        private boolean isMajorGenerationalGc(String string) {
            return GcGenerationAge.fromGcName(string) == GcGenerationAge.OLD;
        }

        private boolean nonGenerationalGcShouldUpdateDataSize(String string) {
            return !JvmGcMetrics.this.isGenerationalGc && !string.endsWith("Pauses");
        }
    }

    @NonNullApi
    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static final Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromGcName(String string) {
            return knownCollectors.getOrDefault(string, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                    this.put("global", OLD);
                    this.put("scavenge", YOUNG);
                    this.put("partial gc", YOUNG);
                    this.put("global garbage collect", OLD);
                    this.put("Epsilon", OLD);
                    this.put("GPGC New", YOUNG);
                    this.put("GPGC Old", OLD);
                    this.put("GPGC New Cycles", YOUNG);
                    this.put("GPGC Old Cycles", OLD);
                    this.put("GPGC New Pauses", YOUNG);
                    this.put("GPGC Old Pauses", OLD);
                }
            };
        }
    }
}

