/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSupport;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.ValueAtPercentile;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.DoubleFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

@Incubating(since="1.0.3")
public class HistogramGauges {
    volatile CountDownLatch polledGaugesLatch;
    private volatile HistogramSnapshot snapshot;
    private final HistogramSupport meter;
    private final int totalGauges;

    public static HistogramGauges registerWithCommonFormat(Timer timer, MeterRegistry meterRegistry) {
        return HistogramGauges.getHistogramGauges(timer, timer.getId(), timer.baseTimeUnit(), meterRegistry);
    }

    private static HistogramGauges getHistogramGauges(HistogramSupport histogramSupport, Meter.Id id, TimeUnit timeUnit, MeterRegistry meterRegistry) {
        return HistogramGauges.register(histogramSupport, meterRegistry, valueAtPercentile -> id.getName() + ".percentile", valueAtPercentile -> Tags.concat(id.getTagsAsIterable(), "phi", DoubleFormat.decimalOrNan(valueAtPercentile.percentile())), valueAtPercentile -> valueAtPercentile.value(timeUnit), countAtBucket -> id.getName() + ".histogram", countAtBucket -> Tags.concat(id.getTagsAsIterable(), "le", countAtBucket.isPositiveInf() ? "+Inf" : DoubleFormat.wholeOrDecimal(countAtBucket.bucket(timeUnit))));
    }

    public static HistogramGauges registerWithCommonFormat(LongTaskTimer longTaskTimer, MeterRegistry meterRegistry) {
        return HistogramGauges.getHistogramGauges(longTaskTimer, longTaskTimer.getId(), longTaskTimer.baseTimeUnit(), meterRegistry);
    }

    public static HistogramGauges registerWithCommonFormat(DistributionSummary distributionSummary, MeterRegistry meterRegistry) {
        Meter.Id id = distributionSummary.getId();
        return HistogramGauges.register(distributionSummary, meterRegistry, valueAtPercentile -> id.getName() + ".percentile", valueAtPercentile -> Tags.concat(id.getTagsAsIterable(), "phi", DoubleFormat.decimalOrNan(valueAtPercentile.percentile())), ValueAtPercentile::value, countAtBucket -> id.getName() + ".histogram", countAtBucket -> Tags.concat(id.getTagsAsIterable(), "le", countAtBucket.isPositiveInf() ? "+Inf" : DoubleFormat.wholeOrDecimal(countAtBucket.bucket())));
    }

    public static HistogramGauges register(HistogramSupport histogramSupport, MeterRegistry meterRegistry, Function<ValueAtPercentile, String> function, Function<ValueAtPercentile, Iterable<Tag>> function2, Function<ValueAtPercentile, Double> function3, Function<CountAtBucket, String> function4, Function<CountAtBucket, Iterable<Tag>> function5) {
        return new HistogramGauges(histogramSupport, meterRegistry, function, function2, function3, function4, function5);
    }

    private HistogramGauges(HistogramSupport histogramSupport2, MeterRegistry meterRegistry, Function<ValueAtPercentile, String> function, Function<ValueAtPercentile, Iterable<Tag>> function2, Function<ValueAtPercentile, Double> function3, Function<CountAtBucket, String> function4, Function<CountAtBucket, Iterable<Tag>> function5) {
        ToDoubleFunction<HistogramSupport> toDoubleFunction;
        int n2;
        int n3;
        HistogramSnapshot histogramSnapshot;
        this.meter = histogramSupport2;
        this.snapshot = histogramSnapshot = histogramSupport2.takeSnapshot();
        ValueAtPercentile[] valueAtPercentileArray = histogramSnapshot.percentileValues();
        CountAtBucket[] countAtBucketArray = histogramSnapshot.histogramCounts();
        this.totalGauges = valueAtPercentileArray.length + countAtBucketArray.length;
        this.polledGaugesLatch = new CountDownLatch(0);
        for (n3 = 0; n3 < valueAtPercentileArray.length; ++n3) {
            n2 = n3;
            toDoubleFunction = histogramSupport -> {
                this.snapshotIfNecessary();
                this.polledGaugesLatch.countDown();
                return (Double)function3.apply(this.snapshot.percentileValues()[n2]);
            };
            Gauge.builder(function.apply(valueAtPercentileArray[n3]), histogramSupport2, toDoubleFunction).tags(function2.apply(valueAtPercentileArray[n3])).baseUnit(histogramSupport2.getId().getBaseUnit()).synthetic(histogramSupport2.getId()).register(meterRegistry);
        }
        for (n3 = 0; n3 < countAtBucketArray.length; ++n3) {
            n2 = n3;
            toDoubleFunction = histogramSupport -> {
                this.snapshotIfNecessary();
                this.polledGaugesLatch.countDown();
                return this.snapshot.histogramCounts()[n2].count();
            };
            Gauge.builder(function4.apply(countAtBucketArray[n3]), histogramSupport2, toDoubleFunction).tags(function5.apply(countAtBucketArray[n3])).synthetic(histogramSupport2.getId()).register(meterRegistry);
        }
    }

    private void snapshotIfNecessary() {
        if (this.polledGaugesLatch.getCount() == 0L) {
            this.snapshot = this.meter.takeSnapshot();
            this.polledGaugesLatch = new CountDownLatch(this.totalGauges);
        }
    }
}

