/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.EWMA;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class DropwizardRate {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final AtomicLong lastTime;
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final Clock clock;

    DropwizardRate(Clock clock) {
        this.clock = clock;
        this.lastTime = new AtomicLong(clock.monotonicTime());
    }

    private synchronized void tickIfNecessary(long l2) {
        long l3 = this.lastTime.get();
        long l4 = this.clock.monotonicTime();
        long l5 = l4 - l3;
        if (l5 > TICK_INTERVAL) {
            long l6 = l4 - l5 % TICK_INTERVAL;
            if (this.lastTime.compareAndSet(l3, l6)) {
                long l7;
                long l8 = l5 / TICK_INTERVAL;
                long l9 = l2 / l8;
                for (l7 = 0L; l7 < l8; ++l7) {
                    this.m1Rate.update(l9);
                    this.m5Rate.update(l9);
                    this.m15Rate.update(l9);
                    this.m1Rate.tick();
                    this.m5Rate.tick();
                    this.m15Rate.tick();
                }
                l7 = l2 % l8;
                this.m1Rate.update(l7);
                this.m5Rate.update(l7);
                this.m15Rate.update(l7);
            }
        } else {
            this.m1Rate.update(l2);
            this.m5Rate.update(l2);
            this.m15Rate.update(l2);
        }
    }

    public void increment(long l2) {
        this.tickIfNecessary(l2);
    }

    public double getOneMinuteRate() {
        this.tickIfNecessary(0L);
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    public double getFifteenMinuteRate() {
        this.tickIfNecessary(0L);
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    public double getFiveMinuteRate() {
        this.tickIfNecessary(0L);
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }
}

