/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.push;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.push.PushRegistryConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PushMeterRegistry
extends MeterRegistry {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PushMeterRegistry.class);
    private static final double PERCENT_RANGE_OF_RANDOM_PUBLISHING_OFFSET = 0.8;
    private final PushRegistryConfig config;
    private final AtomicBoolean publishing = new AtomicBoolean(false);
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;

    protected PushMeterRegistry(PushRegistryConfig pushRegistryConfig, Clock clock) {
        super(clock);
        pushRegistryConfig.requireValid();
        this.config = pushRegistryConfig;
    }

    protected abstract void publish();

    void publishSafely() {
        if (this.publishing.compareAndSet(false, true)) {
            try {
                this.publish();
            }
            catch (Throwable throwable) {
                logger.warn("Unexpected exception thrown while publishing metrics for " + this.getClass().getSimpleName(), throwable);
            }
            finally {
                this.publishing.set(false);
            }
        } else {
            logger.warn("Publishing is already in progress. Skipping duplicate call to publish().");
        }
    }

    protected boolean isPublishing() {
        return this.publishing.get();
    }

    @Deprecated
    public final void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void start(ThreadFactory threadFactory) {
        if (this.scheduledExecutorService != null) {
            this.stop();
        }
        if (this.config.enabled()) {
            logger.info("publishing metrics for " + this.getClass().getSimpleName() + " every " + TimeUtils.format(this.config.step()));
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            long l2 = this.config.step().toMillis();
            long l3 = this.calculateInitialDelay();
            this.scheduledExecutorService.scheduleAtFixedRate(this::publishSafely, l3, l2, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void close() {
        this.stop();
        if (this.config.enabled() && !this.isClosed()) {
            this.publishSafely();
        }
        super.close();
    }

    long calculateInitialDelay() {
        long l2 = this.config.step().toMillis();
        Random random = new Random();
        long l3 = Math.max(0L, (long)((double)l2 * random.nextDouble() * 0.8) - 2L);
        long l4 = l2 - this.clock.wallTime() % l2;
        return l4 + 2L + l3;
    }
}

