/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepTuple2;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class StepFunctionTimer<T>
implements FunctionTimer,
StepMeter {
    private final Meter.Id id;
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnit;
    private final TimeUnit baseTimeUnit;
    private final Clock clock;
    private volatile long lastUpdateTime = -2000000L;
    private volatile long lastCount;
    private volatile double lastTime;
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final StepTuple2<Long, Double> countTotal;

    public StepFunctionTimer(Meter.Id id, Clock clock, long l2, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit, TimeUnit timeUnit2) {
        this.id = id;
        this.clock = clock;
        this.ref = new WeakReference<T>(t2);
        this.countFunction = toLongFunction;
        this.totalTimeFunction = toDoubleFunction;
        this.totalTimeFunctionUnit = timeUnit;
        this.baseTimeUnit = timeUnit2;
        this.countTotal = new StepTuple2<Long, Double>(clock, l2, 0L, 0.0, this.count::sumThenReset, this.total::sumThenReset);
    }

    @Override
    public double count() {
        this.accumulateCountAndTotal();
        return this.countTotal.poll1().longValue();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        this.accumulateCountAndTotal();
        return TimeUtils.convert(this.countTotal.poll2(), this.baseTimeUnit(), timeUnit);
    }

    private void accumulateCountAndTotal() {
        Object t2 = this.ref.get();
        if (t2 != null && (double)(this.clock.monotonicTime() - this.lastUpdateTime) > 1000000.0) {
            long l2 = this.lastCount;
            this.lastCount = Math.max(this.countFunction.applyAsLong(t2), 0L);
            this.count.add(this.lastCount - l2);
            double d2 = this.lastTime;
            this.lastTime = Math.max(TimeUtils.convert(this.totalTimeFunction.applyAsDouble(t2), this.totalTimeFunctionUnit, this.baseTimeUnit()), 0.0);
            this.total.add(this.lastTime - d2);
            this.lastUpdateTime = this.clock.monotonicTime();
        }
    }

    @Override
    public Meter.Id getId() {
        return this.id;
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public Meter.Type type() {
        return Meter.Type.TIMER;
    }

    @Override
    public void _closingRollover() {
        this.accumulateCountAndTotal();
        this.countTotal._closingRollover();
    }
}

