/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http;

enum HttpStatusClass {
    INFORMATIONAL(100, 200),
    SUCCESS(200, 300),
    REDIRECTION(300, 400),
    CLIENT_ERROR(400, 500),
    SERVER_ERROR(500, 600),
    UNKNOWN(0, 0){

        @Override
        public boolean contains(int n2) {
            return n2 < 100 || n2 >= 600;
        }
    };

    private final int min;
    private final int max;

    public static HttpStatusClass valueOf(int n2) {
        if (INFORMATIONAL.contains(n2)) {
            return INFORMATIONAL;
        }
        if (SUCCESS.contains(n2)) {
            return SUCCESS;
        }
        if (REDIRECTION.contains(n2)) {
            return REDIRECTION;
        }
        if (CLIENT_ERROR.contains(n2)) {
            return CLIENT_ERROR;
        }
        if (SERVER_ERROR.contains(n2)) {
            return SERVER_ERROR;
        }
        return UNKNOWN;
    }

    private HttpStatusClass(int n3, int n4) {
        this.min = n3;
        this.max = n4;
    }

    public boolean contains(int n2) {
        return n2 >= this.min && n2 < this.max;
    }
}

