/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.IOUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http.HttpSender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;

public class HttpUrlConnectionSender
implements HttpSender {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final Proxy proxy;

    public HttpUrlConnectionSender(Duration duration, Duration duration2) {
        this(duration, duration2, null);
    }

    public HttpUrlConnectionSender(Duration duration, Duration duration2, Proxy proxy) {
        this.connectTimeoutMs = (int)duration.toMillis();
        this.readTimeoutMs = (int)duration2.toMillis();
        this.proxy = proxy;
    }

    public HttpUrlConnectionSender() {
        this.connectTimeoutMs = 1000;
        this.readTimeoutMs = 10000;
        this.proxy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public HttpSender.Response send(HttpSender.Request request) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            void var5_11;
            httpURLConnection = this.proxy != null ? (HttpURLConnection)request.getUrl().openConnection(this.proxy) : (HttpURLConnection)request.getUrl().openConnection();
            httpURLConnection.setConnectTimeout(this.connectTimeoutMs);
            httpURLConnection.setReadTimeout(this.readTimeoutMs);
            HttpSender.Method method = request.getMethod();
            httpURLConnection.setRequestMethod(method.name());
            for (Map.Entry<String, String> object2 : request.getRequestHeaders().entrySet()) {
                httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
            }
            if (method != HttpSender.Method.GET) {
                httpURLConnection.setDoOutput(true);
                try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                    outputStream.write(request.getEntity());
                    outputStream.flush();
                }
            }
            int n2 = httpURLConnection.getResponseCode();
            Object var5_8 = null;
            try {
                if (httpURLConnection.getErrorStream() != null) {
                    String string = IOUtils.toString(httpURLConnection.getErrorStream());
                } else if (httpURLConnection.getInputStream() != null) {
                    String string = IOUtils.toString(httpURLConnection.getInputStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HttpSender.Response response = new HttpSender.Response(n2, (String)var5_11);
            return response;
        }
        finally {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }
}

