/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.observation;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValues;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNull;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.observation.NoopObservation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.NoopObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationView;
import com.contrastsecurity.thirdparty.io.micrometer.observation.SimpleObservation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Observation
extends ObservationView {
    public static final Observation NOOP = NoopObservation.INSTANCE;

    public static Observation start(String string, @Nullable ObservationRegistry observationRegistry) {
        return Observation.start(string, Context::new, observationRegistry);
    }

    public static <T extends Context> Observation start(String string, Supplier<T> supplier, @Nullable ObservationRegistry observationRegistry) {
        return Observation.createNotStarted(string, supplier, observationRegistry).start();
    }

    public static Observation createNotStarted(String string, @Nullable ObservationRegistry observationRegistry) {
        return Observation.createNotStarted(string, Context::new, observationRegistry);
    }

    public static <T extends Context> Observation createNotStarted(String string, Supplier<T> supplier, @Nullable ObservationRegistry observationRegistry) {
        if (observationRegistry == null || observationRegistry.isNoop()) {
            return NOOP;
        }
        Context context = (Context)supplier.get();
        if (!observationRegistry.observationConfig().isObservationEnabled(string, context)) {
            return NOOP;
        }
        return new SimpleObservation(string, observationRegistry, context == null ? new Context() : context);
    }

    public static <T extends Context> Observation createNotStarted(@Nullable ObservationConvention<T> observationConvention, ObservationConvention<T> observationConvention2, Supplier<T> supplier, @Nullable ObservationRegistry observationRegistry) {
        if (observationRegistry == null || observationRegistry.isNoop()) {
            return NOOP;
        }
        Context context = (Context)supplier.get();
        ObservationConvention<Object> observationConvention3 = observationConvention != null ? observationConvention : observationRegistry.observationConfig().getObservationConvention(context, observationConvention2);
        if (!observationRegistry.observationConfig().isObservationEnabled(observationConvention3.getName(), context)) {
            return NOOP;
        }
        return new SimpleObservation(observationConvention3, observationRegistry, context == null ? new Context() : context);
    }

    public static Observation start(ObservationConvention<Context> observationConvention, ObservationRegistry observationRegistry) {
        return Observation.start(observationConvention, Context::new, observationRegistry);
    }

    public static <T extends Context> Observation start(ObservationConvention<T> observationConvention, Supplier<T> supplier, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted(observationConvention, supplier, observationRegistry).start();
    }

    public static <T extends Context> Observation start(@Nullable ObservationConvention<T> observationConvention, ObservationConvention<T> observationConvention2, Supplier<T> supplier, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted(observationConvention, observationConvention2, supplier, observationRegistry).start();
    }

    public static Observation createNotStarted(ObservationConvention<Context> observationConvention, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted(observationConvention, Context::new, observationRegistry);
    }

    public static <T extends Context> Observation createNotStarted(ObservationConvention<T> observationConvention, Supplier<T> supplier, ObservationRegistry observationRegistry) {
        if (observationRegistry == null || observationRegistry.isNoop() || observationConvention == NoopObservationConvention.INSTANCE) {
            return NOOP;
        }
        Context context = (Context)supplier.get();
        if (!observationRegistry.observationConfig().isObservationEnabled(observationConvention.getName(), context)) {
            return NOOP;
        }
        return new SimpleObservation(observationConvention, observationRegistry, context == null ? new Context() : context);
    }

    public Observation contextualName(@Nullable String var1);

    public Observation parentObservation(@Nullable Observation var1);

    public Observation lowCardinalityKeyValue(KeyValue var1);

    default public Observation lowCardinalityKeyValue(String string, String string2) {
        return this.lowCardinalityKeyValue(KeyValue.of(string, string2));
    }

    default public Observation lowCardinalityKeyValues(KeyValues keyValues) {
        for (KeyValue keyValue : keyValues) {
            this.lowCardinalityKeyValue(keyValue);
        }
        return this;
    }

    public Observation highCardinalityKeyValue(KeyValue var1);

    default public Observation highCardinalityKeyValue(String string, String string2) {
        return this.highCardinalityKeyValue(KeyValue.of(string, string2));
    }

    default public Observation highCardinalityKeyValues(KeyValues keyValues) {
        for (KeyValue keyValue : keyValues) {
            this.highCardinalityKeyValue(keyValue);
        }
        return this;
    }

    default public boolean isNoop() {
        return this == NOOP;
    }

    public Observation observationConvention(ObservationConvention<?> var1);

    public Observation error(Throwable var1);

    public Observation event(Event var1);

    public Observation start();

    public Context getContext();

    @Override
    default public ContextView getContextView() {
        return this.getContext();
    }

    public void stop();

    public Scope openScope();

    default public void observe(Runnable runnable) {
        this.observeWithContext(context -> {
            runnable.run();
            return null;
        });
    }

    default public Runnable wrap(Runnable runnable) {
        return () -> this.observe(runnable);
    }

    default public <E extends Throwable> void observeChecked(CheckedRunnable<E> checkedRunnable) throws E {
        this.observeCheckedWithContext(context -> {
            checkedRunnable.run();
            return null;
        });
    }

    default public <E extends Throwable> CheckedRunnable<E> wrapChecked(CheckedRunnable<E> checkedRunnable) throws E {
        return () -> this.observeChecked(checkedRunnable);
    }

    @Nullable
    default public <T> T observe(Supplier<T> supplier) {
        return (T)this.observeWithContext(context -> supplier.get());
    }

    default public <T> Supplier<T> wrap(Supplier<T> supplier) {
        return () -> this.observe(supplier);
    }

    @Nullable
    default public <T, E extends Throwable> T observeChecked(CheckedCallable<T, E> checkedCallable) throws E {
        return (T)this.observeCheckedWithContext(context -> checkedCallable.call());
    }

    default public <T, E extends Throwable> CheckedCallable<T, E> wrapChecked(CheckedCallable<T, E> checkedCallable) throws E {
        return () -> this.observeChecked(checkedCallable);
    }

    @Nullable
    default public <C extends Context, T> T observeWithContext(Function<C, T> function) {
        this.start();
        try {
            T t2;
            block11: {
                Scope scope = this.openScope();
                try {
                    t2 = function.apply(this.getContext());
                    if (scope == null) break block11;
                    scope.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        this.error(throwable3);
                        throw throwable3;
                    }
                }
            }
            return t2;
        }
        finally {
            this.stop();
        }
    }

    @Nullable
    default public <C extends Context, T, E extends Throwable> T observeCheckedWithContext(CheckedFunction<C, T, E> checkedFunction) throws E {
        this.start();
        try {
            T t2;
            block11: {
                Scope scope = this.openScope();
                try {
                    t2 = checkedFunction.apply(this.getContext());
                    if (scope == null) break block11;
                    scope.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        this.error(throwable3);
                        throw throwable3;
                    }
                }
            }
            return t2;
        }
        finally {
            this.stop();
        }
    }

    default public void scoped(Runnable runnable) {
        try (Scope scope = this.openScope();){
            runnable.run();
        }
        catch (Exception exception) {
            this.error(exception);
            throw exception;
        }
    }

    default public <E extends Throwable> void scopedChecked(CheckedRunnable<E> checkedRunnable) throws E {
        try (Scope scope = this.openScope();){
            checkedRunnable.run();
        }
        catch (Throwable throwable) {
            this.error(throwable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T scoped(Supplier<T> supplier) {
        try (Scope scope = this.openScope();){
            T t2 = supplier.get();
            return t2;
        }
        catch (Exception exception) {
            this.error(exception);
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T, E extends Throwable> T scopedChecked(CheckedCallable<T, E> checkedCallable) throws E {
        try (Scope scope = this.openScope();){
            T t2 = checkedCallable.call();
            return t2;
        }
        catch (Throwable throwable3) {
            this.error(throwable3);
            throw throwable3;
        }
    }

    public static void tryScoped(@Nullable Observation observation, Runnable runnable) {
        if (observation != null) {
            observation.scoped(runnable);
        } else {
            runnable.run();
        }
    }

    public static <E extends Throwable> void tryScopedChecked(@Nullable Observation observation, CheckedRunnable<E> checkedRunnable) throws E {
        if (observation != null) {
            observation.scopedChecked(checkedRunnable);
        } else {
            checkedRunnable.run();
        }
    }

    public static <T> T tryScoped(@Nullable Observation observation, Supplier<T> supplier) {
        if (observation != null) {
            return observation.scoped(supplier);
        }
        return supplier.get();
    }

    public static <T, E extends Throwable> T tryScopedChecked(@Nullable Observation observation, CheckedCallable<T, E> checkedCallable) throws E {
        if (observation != null) {
            return observation.scopedChecked(checkedCallable);
        }
        return checkedCallable.call();
    }

    public static class Context
    implements ContextView {
        private final Map<Object, Object> map = new HashMap<Object, Object>();
        private String name;
        @Nullable
        private String contextualName;
        @Nullable
        private Throwable error;
        @Nullable
        private ObservationView parentObservation;
        private final Map<String, KeyValue> lowCardinalityKeyValues = new LinkedHashMap<String, KeyValue>();
        private final Map<String, KeyValue> highCardinalityKeyValues = new LinkedHashMap<String, KeyValue>();

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Override
        public String getContextualName() {
            return this.contextualName;
        }

        public void setContextualName(@Nullable String string) {
            this.contextualName = string;
        }

        @Override
        @Nullable
        public ObservationView getParentObservation() {
            return this.parentObservation;
        }

        public void setParentObservation(@Nullable ObservationView observationView) {
            this.parentObservation = observationView;
        }

        @Override
        @Nullable
        public Throwable getError() {
            return this.error;
        }

        public void setError(Throwable throwable) {
            this.error = throwable;
        }

        public <T> Context put(Object object, T t2) {
            this.map.put(object, t2);
            return this;
        }

        @Override
        @Nullable
        public <T> T get(Object object) {
            return (T)this.map.get(object);
        }

        public Object remove(Object object) {
            return this.map.remove(object);
        }

        @Override
        @NonNull
        public <T> T getRequired(Object object) {
            Object object2 = this.map.get(object);
            if (object2 == null) {
                throw new IllegalArgumentException("Context does not have an entry for key [" + object + "]");
            }
            return (T)object2;
        }

        @Override
        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public <T> T getOrDefault(Object object, T t2) {
            return (T)this.map.getOrDefault(object, t2);
        }

        public <T> T computeIfAbsent(Object object, Function<Object, ? extends T> function) {
            return this.map.computeIfAbsent(object, function);
        }

        public void clear() {
            this.map.clear();
        }

        public Context addLowCardinalityKeyValue(KeyValue keyValue) {
            this.lowCardinalityKeyValues.put(keyValue.getKey(), keyValue);
            return this;
        }

        public Context addHighCardinalityKeyValue(KeyValue keyValue) {
            this.highCardinalityKeyValues.put(keyValue.getKey(), keyValue);
            return this;
        }

        public Context removeLowCardinalityKeyValue(String string) {
            this.lowCardinalityKeyValues.remove(string);
            return this;
        }

        public Context removeHighCardinalityKeyValue(String string) {
            this.highCardinalityKeyValues.remove(string);
            return this;
        }

        public Context addLowCardinalityKeyValues(KeyValues keyValues) {
            for (KeyValue keyValue : keyValues) {
                this.addLowCardinalityKeyValue(keyValue);
            }
            return this;
        }

        public Context addHighCardinalityKeyValues(KeyValues keyValues) {
            for (KeyValue keyValue : keyValues) {
                this.addHighCardinalityKeyValue(keyValue);
            }
            return this;
        }

        public Context removeLowCardinalityKeyValues(String ... stringArray) {
            for (String string : stringArray) {
                this.removeLowCardinalityKeyValue(string);
            }
            return this;
        }

        public Context removeHighCardinalityKeyValues(String ... stringArray) {
            for (String string : stringArray) {
                this.removeHighCardinalityKeyValue(string);
            }
            return this;
        }

        @Override
        @NonNull
        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of(this.lowCardinalityKeyValues.values());
        }

        @Override
        @NonNull
        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of(this.highCardinalityKeyValues.values());
        }

        @Override
        public KeyValue getLowCardinalityKeyValue(String string) {
            return this.lowCardinalityKeyValues.get(string);
        }

        @Override
        public KeyValue getHighCardinalityKeyValue(String string) {
            return this.highCardinalityKeyValues.get(string);
        }

        @Override
        @NonNull
        public KeyValues getAllKeyValues() {
            return this.getLowCardinalityKeyValues().and(this.getHighCardinalityKeyValues());
        }

        public String toString() {
            return "name='" + this.name + '\'' + ", contextualName='" + this.contextualName + '\'' + ", error='" + this.error + '\'' + ", lowCardinalityKeyValues=" + this.toString(this.getLowCardinalityKeyValues()) + ", highCardinalityKeyValues=" + this.toString(this.getHighCardinalityKeyValues()) + ", map=" + this.toString(this.map) + ", parentObservation=" + this.parentObservation;
        }

        private String toString(KeyValues keyValues) {
            return keyValues.stream().map(keyValue -> String.format("%s='%s'", keyValue.getKey(), keyValue.getValue())).collect(Collectors.joining(", ", "[", "]"));
        }

        private String toString(Map<Object, Object> map) {
            return map.entrySet().stream().map(entry -> String.format("%s='%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ", "[", "]"));
        }
    }

    @FunctionalInterface
    public static interface CheckedRunnable<E extends Throwable> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R, E extends Throwable> {
        @Nullable
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface CheckedCallable<T, E extends Throwable> {
        public T call() throws E;
    }

    public static interface Scope
    extends AutoCloseable {
        public static final Scope NOOP = NoopObservation.NoopScope.INSTANCE;

        public Observation getCurrentObservation();

        @Override
        public void close();

        public void reset();

        public void makeCurrent();

        default public boolean isNoop() {
            return this == NOOP;
        }
    }

    public static interface ContextView {
        public String getName();

        @Nullable
        public String getContextualName();

        @Nullable
        public ObservationView getParentObservation();

        @Nullable
        public Throwable getError();

        @Nullable
        public <T> T get(Object var1);

        @NonNull
        public <T> T getRequired(Object var1);

        public boolean containsKey(Object var1);

        public <T> T getOrDefault(Object var1, T var2);

        default public <T> T getOrDefault(Object object, Supplier<T> supplier) {
            T t2 = this.get(object);
            return t2 != null ? t2 : supplier.get();
        }

        public KeyValues getLowCardinalityKeyValues();

        @NonNull
        public KeyValues getHighCardinalityKeyValues();

        @Nullable
        public KeyValue getLowCardinalityKeyValue(String var1);

        @Nullable
        public KeyValue getHighCardinalityKeyValue(String var1);

        @NonNull
        public KeyValues getAllKeyValues();
    }

    public static interface Event {
        public static Event of(final String string, final String string2) {
            return new Event(){

                @Override
                public String getName() {
                    return string;
                }

                @Override
                public String getContextualName() {
                    return string2;
                }

                public String toString() {
                    return "event.name='" + this.getName() + "', event.contextualName='" + this.getContextualName() + '\'';
                }
            };
        }

        public static Event of(String string) {
            return Event.of(string, string);
        }

        public String getName();

        default public String getContextualName() {
            return this.getName();
        }

        default public Event format(Object ... objectArray) {
            return Event.of(this.getName(), String.format(this.getContextualName(), objectArray));
        }
    }
}

