/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.observation;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.StringUtils;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationFilter;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationHandler;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SimpleObservation
implements Observation {
    private final ObservationRegistry registry;
    private final Observation.Context context;
    @Nullable
    private ObservationConvention convention;
    private final Deque<ObservationHandler> handlers;
    private final Collection<ObservationFilter> filters;
    private final Map<Thread, Deque<Observation.Scope>> enclosingScopes = new ConcurrentHashMap<Thread, Deque<Observation.Scope>>();

    SimpleObservation(@Nullable String string, ObservationRegistry observationRegistry, Observation.Context context) {
        this.registry = observationRegistry;
        this.context = context;
        this.context.setName(string);
        this.convention = SimpleObservation.getConventionFromConfig(observationRegistry, context);
        this.handlers = SimpleObservation.getHandlersFromConfig(observationRegistry, context);
        this.filters = observationRegistry.observationConfig().getObservationFilters();
        this.setParentFromCurrentObservation();
    }

    SimpleObservation(ObservationConvention<? extends Observation.Context> observationConvention, ObservationRegistry observationRegistry, Observation.Context context) {
        this.registry = observationRegistry;
        this.context = context;
        this.handlers = SimpleObservation.getHandlersFromConfig(observationRegistry, context);
        this.filters = observationRegistry.observationConfig().getObservationFilters();
        if (!observationConvention.supportsContext(context)) {
            throw new IllegalStateException("Convention [" + observationConvention + "] doesn't support context [" + context + "]");
        }
        this.convention = observationConvention;
        this.setParentFromCurrentObservation();
    }

    private void setParentFromCurrentObservation() {
        Observation observation = this.registry.getCurrentObservation();
        if (observation != null) {
            this.context.setParentObservation(observation);
        }
    }

    @Nullable
    private static ObservationConvention getConventionFromConfig(ObservationRegistry observationRegistry, Observation.Context context) {
        for (ObservationConvention<?> observationConvention : observationRegistry.observationConfig().getObservationConventions()) {
            if (!observationConvention.supportsContext(context)) continue;
            return observationConvention;
        }
        return null;
    }

    private static Deque<ObservationHandler> getHandlersFromConfig(ObservationRegistry observationRegistry, Observation.Context context) {
        Collection<ObservationHandler<?>> collection = observationRegistry.observationConfig().getObservationHandlers();
        ArrayDeque<ObservationHandler> arrayDeque = new ArrayDeque<ObservationHandler>(collection.size());
        for (ObservationHandler<?> observationHandler : collection) {
            if (!observationHandler.supportsContext(context)) continue;
            arrayDeque.add(observationHandler);
        }
        return arrayDeque;
    }

    @Override
    public Observation contextualName(@Nullable String string) {
        this.context.setContextualName(string);
        return this;
    }

    @Override
    public Observation parentObservation(@Nullable Observation observation) {
        this.context.setParentObservation(observation);
        return this;
    }

    @Override
    public Observation lowCardinalityKeyValue(KeyValue keyValue) {
        this.context.addLowCardinalityKeyValue(keyValue);
        return this;
    }

    @Override
    public Observation highCardinalityKeyValue(KeyValue keyValue) {
        this.context.addHighCardinalityKeyValue(keyValue);
        return this;
    }

    @Override
    public Observation observationConvention(ObservationConvention<?> observationConvention) {
        if (observationConvention.supportsContext(this.context)) {
            this.convention = observationConvention;
        }
        return this;
    }

    @Override
    public Observation error(Throwable throwable) {
        this.context.setError(throwable);
        this.notifyOnError();
        return this;
    }

    @Override
    public Observation event(Observation.Event event) {
        this.notifyOnEvent(event);
        return this;
    }

    @Override
    public Observation start() {
        if (this.convention != null) {
            this.context.addLowCardinalityKeyValues(this.convention.getLowCardinalityKeyValues(this.context));
            this.context.addHighCardinalityKeyValues(this.convention.getHighCardinalityKeyValues(this.context));
            String string = this.convention.getName();
            if (StringUtils.isNotBlank(string)) {
                this.context.setName(string);
            }
        }
        this.notifyOnObservationStarted();
        return this;
    }

    @Override
    public Observation.Context getContext() {
        return this.context;
    }

    @Override
    public void stop() {
        Object object;
        if (this.convention != null) {
            this.context.addLowCardinalityKeyValues(this.convention.getLowCardinalityKeyValues(this.context));
            this.context.addHighCardinalityKeyValues(this.convention.getHighCardinalityKeyValues(this.context));
            object = this.convention.getContextualName(this.context);
            if (StringUtils.isNotBlank((String)object)) {
                this.context.setContextualName((String)object);
            }
        }
        object = this.context;
        for (ObservationFilter observationFilter : this.filters) {
            object = observationFilter.map((Observation.Context)object);
        }
        this.notifyOnObservationStopped((Observation.Context)object);
    }

    @Override
    public Observation.Scope openScope() {
        Observation.Scope scope;
        Deque<Observation.Scope> deque = this.enclosingScopes.get(Thread.currentThread());
        if (deque == null) {
            deque = new ArrayDeque<Observation.Scope>();
            this.enclosingScopes.put(Thread.currentThread(), deque);
        }
        if ((scope = this.registry.getCurrentObservationScope()) != null) {
            deque.addFirst(scope);
        }
        SimpleScope simpleScope = new SimpleScope(this.registry, this);
        this.notifyOnScopeOpened();
        return simpleScope;
    }

    @Override
    @Nullable
    public Observation.Scope getEnclosingScope() {
        Deque<Observation.Scope> deque = this.enclosingScopes.get(Thread.currentThread());
        if (deque != null && !deque.isEmpty()) {
            return deque.pop();
        }
        return null;
    }

    public String toString() {
        return "{name=" + this.context.getName() + "(" + this.context.getContextualName() + "), error=" + this.context.getError() + ", context=" + this.context + '}';
    }

    private void notifyOnObservationStarted() {
        for (ObservationHandler observationHandler : this.handlers) {
            observationHandler.onStart(this.context);
        }
    }

    private void notifyOnError() {
        for (ObservationHandler observationHandler : this.handlers) {
            observationHandler.onError(this.context);
        }
    }

    private void notifyOnEvent(Observation.Event event) {
        for (ObservationHandler observationHandler : this.handlers) {
            observationHandler.onEvent(event, this.context);
        }
    }

    private void notifyOnScopeOpened() {
        for (ObservationHandler observationHandler : this.handlers) {
            observationHandler.onScopeOpened(this.context);
        }
    }

    private void notifyOnScopeClosed() {
        Iterator<ObservationHandler> iterator = this.handlers.descendingIterator();
        while (iterator.hasNext()) {
            ObservationHandler observationHandler = iterator.next();
            observationHandler.onScopeClosed(this.context);
        }
    }

    private void notifyOnScopeMakeCurrent() {
        for (ObservationHandler observationHandler : this.handlers) {
            observationHandler.onScopeOpened(this.context);
        }
    }

    private void notifyOnScopeReset() {
        for (ObservationHandler observationHandler : this.handlers) {
            observationHandler.onScopeReset(this.context);
        }
    }

    private void notifyOnObservationStopped(Observation.Context context) {
        this.handlers.descendingIterator().forEachRemaining(observationHandler -> observationHandler.onStop(context));
    }

    static class SimpleScope
    implements Observation.Scope {
        private final ObservationRegistry registry;
        private final SimpleObservation currentObservation;
        @Nullable
        private final Observation.Scope previousObservationScope;

        SimpleScope(ObservationRegistry observationRegistry, SimpleObservation simpleObservation) {
            this.registry = observationRegistry;
            this.currentObservation = simpleObservation;
            this.previousObservationScope = observationRegistry.getCurrentObservationScope();
            this.registry.setCurrentObservationScope(this);
        }

        @Override
        public Observation getCurrentObservation() {
            return this.currentObservation;
        }

        @Override
        public void close() {
            Deque deque = (Deque)this.currentObservation.enclosingScopes.get(Thread.currentThread());
            if (deque != null && !deque.isEmpty()) {
                deque.removeFirst();
            }
            this.registry.setCurrentObservationScope(this.previousObservationScope);
            this.currentObservation.notifyOnScopeClosed();
        }

        @Override
        public void reset() {
            this.registry.setCurrentObservationScope(null);
            SimpleScope simpleScope = this;
            do {
                this.registry.setCurrentObservationScope(simpleScope.previousObservationScope);
                simpleScope.currentObservation.notifyOnScopeReset();
            } while ((simpleScope = (SimpleScope)simpleScope.previousObservationScope) != null);
            this.registry.setCurrentObservationScope(null);
        }

        @Override
        public void makeCurrent() {
            this.currentObservation.notifyOnScopeReset();
            ArrayDeque<SimpleScope> arrayDeque = new ArrayDeque<SimpleScope>();
            SimpleScope simpleScope = this;
            do {
                arrayDeque.addFirst(simpleScope);
            } while ((simpleScope = (SimpleScope)simpleScope.previousObservationScope) != null);
            for (SimpleScope simpleScope2 : arrayDeque) {
                simpleScope2.currentObservation.notifyOnScopeMakeCurrent();
            }
            this.registry.setCurrentObservationScope(this);
        }
    }
}

